/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.adapter;

import io.holunda.camunda.bpm.data.adapter.ReadAdapter;
import io.holunda.camunda.bpm.data.adapter.VariableNotFoundException;
import io.holunda.camunda.bpm.data.adapter.WriteAdapter;
import java.util.function.Function;

public abstract class AbstractReadWriteAdapter<T>
implements ReadAdapter<T>,
WriteAdapter<T> {
    protected final String variableName;

    public AbstractReadWriteAdapter(String variableName) {
        this.variableName = variableName;
    }

    @Override
    public void set(T value) {
        this.set(value, false);
    }

    @Override
    public void setLocal(T value) {
        this.setLocal(value, false);
    }

    @Override
    public T get() {
        return this.getOptional().orElseThrow(() -> new VariableNotFoundException("Couldn't find required variable '" + this.variableName + "'"));
    }

    @Override
    public T getLocal() {
        return this.getLocalOptional().orElseThrow(() -> new VariableNotFoundException("Couldn't find required local variable '" + this.variableName + "'"));
    }

    @Override
    public void update(Function<T, T> valueProcessor, boolean isTransient) {
        T newValue;
        T oldValue = this.get();
        if (!oldValue.equals(newValue = valueProcessor.apply(oldValue))) {
            this.set(newValue, isTransient);
        }
    }

    @Override
    public void updateLocal(Function<T, T> valueProcessor, boolean isTransient) {
        T newValue;
        T oldValue = this.getLocal();
        if (!oldValue.equals(newValue = valueProcessor.apply(oldValue))) {
            this.setLocal(newValue, isTransient);
        }
    }

    @Override
    public void update(Function<T, T> valueProcessor) {
        this.update(valueProcessor, false);
    }

    @Override
    public void updateLocal(Function<T, T> valueProcessor) {
        this.updateLocal(valueProcessor, false);
    }
}

