/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.reader;

import io.holunda.camunda.bpm.data.factory.VariableFactory;
import io.holunda.camunda.bpm.data.reader.VariableReader;
import java.util.Objects;
import java.util.Optional;
import org.camunda.bpm.engine.CaseService;
import org.jetbrains.annotations.NotNull;

public class CaseServiceVariableReader
implements VariableReader {
    private final CaseService caseService;
    private final String caseExecutionId;

    public CaseServiceVariableReader(CaseService caseService, String caseExecutionId) {
        this.caseService = caseService;
        this.caseExecutionId = caseExecutionId;
    }

    @Override
    @NotNull
    public <T> Optional<T> getOptional(VariableFactory<T> variableFactory) {
        return variableFactory.from(this.caseService, this.caseExecutionId).getOptional();
    }

    @Override
    @NotNull
    public <T> T get(VariableFactory<T> variableFactory) {
        return variableFactory.from(this.caseService, this.caseExecutionId).get();
    }

    @Override
    @NotNull
    public <T> T getLocal(VariableFactory<T> variableFactory) {
        return variableFactory.from(this.caseService, this.caseExecutionId).getLocal();
    }

    @Override
    @NotNull
    public <T> Optional<T> getLocalOptional(VariableFactory<T> variableFactory) {
        return variableFactory.from(this.caseService, this.caseExecutionId).getLocalOptional();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseServiceVariableReader that = (CaseServiceVariableReader)o;
        if (!Objects.equals(this.caseService, that.caseService)) {
            return false;
        }
        return Objects.equals(this.caseExecutionId, that.caseExecutionId);
    }

    public int hashCode() {
        int result = this.caseService != null ? this.caseService.hashCode() : 0;
        result = 31 * result + (this.caseExecutionId != null ? this.caseExecutionId.hashCode() : 0);
        return result;
    }
}

