/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.adapter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import io.holunda.camunda.bpm.data.adapter.WrongVariableTypeException;
import java.util.Collection;
import java.util.Map;
import org.camunda.bpm.engine.variable.impl.value.ObjectValueImpl;
import org.camunda.bpm.engine.variable.value.TypedValue;

public class CollectionTypedValueUtil {
    private CollectionTypedValueUtil() {
    }

    public static <T, C extends Collection<T>> C readFromTypedValue(TypedValue typedValue, String variableName, Class<T> memberClazz, ObjectMapper objectMapper, CollectionType collectionType) {
        if (typedValue == null) {
            return null;
        }
        if (typedValue instanceof ObjectValueImpl) {
            ObjectValueImpl objectValue = (ObjectValueImpl)typedValue;
            String json = objectValue.getValueSerialized();
            try {
                Collection values = (Collection)objectMapper.readValue(json, (JavaType)collectionType);
                if (values.isEmpty()) {
                    return (C)values;
                }
                if (memberClazz.isAssignableFrom(values.iterator().next().getClass())) {
                    return (C)values;
                }
                throw new WrongVariableTypeException("Error reading " + variableName + ": Wrong member type detected, expected " + memberClazz.getName() + ", but was not found in " + values);
            }
            catch (JsonProcessingException jpe) {
                throw new WrongVariableTypeException("Error reading " + variableName + ": Couldn't read value from " + json);
            }
        }
        throw new WrongVariableTypeException("Error reading " + variableName + ": Couldn't read value from " + typedValue);
    }

    public static <K, V> Map<K, V> readFromTypedValue(TypedValue typedValue, String variableName, Class<K> keyClazz, Class<V> valueClazz, ObjectMapper objectMapper, MapType mapType) {
        if (typedValue == null) {
            return null;
        }
        if (typedValue instanceof ObjectValueImpl) {
            ObjectValueImpl objectValue = (ObjectValueImpl)typedValue;
            String json = objectValue.getValueSerialized();
            try {
                Map map = (Map)objectMapper.readValue(json, (JavaType)mapType);
                if (map.isEmpty()) {
                    return map;
                }
                Map.Entry entry = map.entrySet().iterator().next();
                if (valueClazz.isAssignableFrom(entry.getValue().getClass()) && keyClazz.isAssignableFrom(entry.getKey().getClass())) {
                    return map;
                }
                throw new WrongVariableTypeException("Error reading " + variableName + ": Wrong map type detected, expected key " + keyClazz.getName() + " and value " + valueClazz.getName() + ", but was not found in " + map);
            }
            catch (JsonProcessingException jpe) {
                throw new WrongVariableTypeException("Error reading " + variableName + ": Couldn't read value from " + json);
            }
        }
        throw new WrongVariableTypeException("Error reading " + variableName + ": Couldn't read value from " + typedValue);
    }
}

