/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.ChannelCredentials;
import io.grpc.ClientStreamTracer;
import io.grpc.Grpc;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.InternalChannelz;
import io.grpc.InternalLogId;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.SecurityLevel;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.TlsChannelCredentials;
import io.grpc.internal.CertificateUtils;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.DisconnectError;
import io.grpc.internal.GoAwayDisconnectError;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.Http2Ping;
import io.grpc.internal.InUseStateAggregator;
import io.grpc.internal.KeepAliveManager;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.NoopSslSession;
import io.grpc.internal.SerializingExecutor;
import io.grpc.internal.SimpleDisconnectError;
import io.grpc.internal.StatsTraceContext;
import io.grpc.internal.TransportTracer;
import io.grpc.okhttp.AsyncSink;
import io.grpc.okhttp.ExceptionHandlingFrameWriter;
import io.grpc.okhttp.NoopSslSocket;
import io.grpc.okhttp.OkHttpChannelBuilder;
import io.grpc.okhttp.OkHttpClientStream;
import io.grpc.okhttp.OkHttpFrameLogger;
import io.grpc.okhttp.OkHttpSettingsUtil;
import io.grpc.okhttp.OkHttpTlsUpgrader;
import io.grpc.okhttp.OutboundFlowController;
import io.grpc.okhttp.Utils;
import io.grpc.okhttp.internal.ConnectionSpec;
import io.grpc.okhttp.internal.Credentials;
import io.grpc.okhttp.internal.OkHostnameVerifier;
import io.grpc.okhttp.internal.StatusLine;
import io.grpc.okhttp.internal.framed.ErrorCode;
import io.grpc.okhttp.internal.framed.FrameReader;
import io.grpc.okhttp.internal.framed.FrameWriter;
import io.grpc.okhttp.internal.framed.Header;
import io.grpc.okhttp.internal.framed.HeadersMode;
import io.grpc.okhttp.internal.framed.Http2;
import io.grpc.okhttp.internal.framed.Settings;
import io.grpc.okhttp.internal.framed.Variant;
import io.grpc.okhttp.internal.proxy.HttpUrl;
import io.grpc.okhttp.internal.proxy.Request;
import io.perfmark.PerfMark;
import io.perfmark.Tag;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;

class OkHttpClientTransport
implements ConnectionClientTransport,
ExceptionHandlingFrameWriter.TransportExceptionHandler,
OutboundFlowController.Transport,
KeepAliveManager.ClientKeepAlivePinger.TransportWithDisconnectReason {
    private static final Map<ErrorCode, Status> ERROR_CODE_TO_STATUS = OkHttpClientTransport.buildErrorCodeToStatusMap();
    private static final Logger log = Logger.getLogger(OkHttpClientTransport.class.getName());
    private static final String GRPC_ENABLE_PER_RPC_AUTHORITY_CHECK = "GRPC_ENABLE_PER_RPC_AUTHORITY_CHECK";
    static boolean enablePerRpcAuthorityCheck = GrpcUtil.getFlag((String)"GRPC_ENABLE_PER_RPC_AUTHORITY_CHECK", (boolean)false);
    private Socket sock;
    private SSLSession sslSession;
    private static final Class<?> x509ExtendedTrustManagerClass;
    private static final Method checkServerTrustedMethod;
    private final InetSocketAddress address;
    private final String defaultAuthority;
    private final String userAgent;
    private final Random random = new Random();
    private final Supplier<Stopwatch> stopwatchFactory;
    private final int initialWindowSize;
    private final Variant variant;
    private ManagedClientTransport.Listener listener;
    @GuardedBy(value="lock")
    private ExceptionHandlingFrameWriter frameWriter;
    private OutboundFlowController outboundFlow;
    private final Object lock = new Object();
    private final InternalLogId logId;
    @GuardedBy(value="lock")
    private int nextStreamId;
    @GuardedBy(value="lock")
    private final Map<Integer, OkHttpClientStream> streams = new HashMap<Integer, OkHttpClientStream>();
    private final Executor executor;
    private final SerializingExecutor serializingExecutor;
    private final ScheduledExecutorService scheduler;
    private final int maxMessageSize;
    private int connectionUnacknowledgedBytesRead;
    private ClientFrameHandler clientFrameHandler;
    private Attributes attributes;
    @GuardedBy(value="lock")
    private Status goAwayStatus;
    @GuardedBy(value="lock")
    private boolean goAwaySent;
    @GuardedBy(value="lock")
    private Http2Ping ping;
    @GuardedBy(value="lock")
    private boolean stopped;
    @GuardedBy(value="lock")
    private boolean hasStream;
    private final SocketFactory socketFactory;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private Socket socket;
    @GuardedBy(value="lock")
    private int maxConcurrentStreams = 0;
    @GuardedBy(value="lock")
    private final Deque<OkHttpClientStream> pendingStreams = new LinkedList<OkHttpClientStream>();
    private final ConnectionSpec connectionSpec;
    private KeepAliveManager keepAliveManager;
    private boolean enableKeepAlive;
    private long keepAliveTimeNanos;
    private long keepAliveTimeoutNanos;
    private boolean keepAliveWithoutCalls;
    private final Runnable tooManyPingsRunnable;
    private final int maxInboundMetadataSize;
    private final boolean useGetForSafeMethods;
    @GuardedBy(value="lock")
    private final TransportTracer transportTracer;
    private final TrustManager x509TrustManager;
    @GuardedBy(value="lock")
    private final Map<String, Status> authorityVerificationResults = new LruCache<Status>();
    @GuardedBy(value="lock")
    private final InUseStateAggregator<OkHttpClientStream> inUseState = new InUseStateAggregator<OkHttpClientStream>(){

        protected void handleInUse() {
            OkHttpClientTransport.this.listener.transportInUse(true);
        }

        protected void handleNotInUse() {
            OkHttpClientTransport.this.listener.transportInUse(false);
        }
    };
    @GuardedBy(value="lock")
    private InternalChannelz.Security securityInfo;
    @Nullable
    @VisibleForTesting
    final HttpConnectProxiedSocketAddress proxiedAddr;
    @VisibleForTesting
    int proxySocketTimeout = 30000;
    Runnable connectingCallback;
    SettableFuture<Void> connectedFuture;

    private static Map<ErrorCode, Status> buildErrorCodeToStatusMap() {
        EnumMap<ErrorCode, Status> errorToStatus = new EnumMap<ErrorCode, Status>(ErrorCode.class);
        errorToStatus.put(ErrorCode.NO_ERROR, Status.INTERNAL.withDescription("No error: A GRPC status of OK should have been sent"));
        errorToStatus.put(ErrorCode.PROTOCOL_ERROR, Status.INTERNAL.withDescription("Protocol error"));
        errorToStatus.put(ErrorCode.INTERNAL_ERROR, Status.INTERNAL.withDescription("Internal error"));
        errorToStatus.put(ErrorCode.FLOW_CONTROL_ERROR, Status.INTERNAL.withDescription("Flow control error"));
        errorToStatus.put(ErrorCode.STREAM_CLOSED, Status.INTERNAL.withDescription("Stream closed"));
        errorToStatus.put(ErrorCode.FRAME_TOO_LARGE, Status.INTERNAL.withDescription("Frame too large"));
        errorToStatus.put(ErrorCode.REFUSED_STREAM, Status.UNAVAILABLE.withDescription("Refused stream"));
        errorToStatus.put(ErrorCode.CANCEL, Status.CANCELLED.withDescription("Cancelled"));
        errorToStatus.put(ErrorCode.COMPRESSION_ERROR, Status.INTERNAL.withDescription("Compression error"));
        errorToStatus.put(ErrorCode.CONNECT_ERROR, Status.INTERNAL.withDescription("Connect error"));
        errorToStatus.put(ErrorCode.ENHANCE_YOUR_CALM, Status.RESOURCE_EXHAUSTED.withDescription("Enhance your calm"));
        errorToStatus.put(ErrorCode.INADEQUATE_SECURITY, Status.PERMISSION_DENIED.withDescription("Inadequate security"));
        return Collections.unmodifiableMap(errorToStatus);
    }

    public OkHttpClientTransport(OkHttpChannelBuilder.OkHttpTransportFactory transportFactory, InetSocketAddress address, String authority, @Nullable String userAgent, Attributes eagAttrs, @Nullable HttpConnectProxiedSocketAddress proxiedAddr, Runnable tooManyPingsRunnable, ChannelCredentials channelCredentials) {
        this(transportFactory, address, authority, userAgent, eagAttrs, (Supplier<Stopwatch>)GrpcUtil.STOPWATCH_SUPPLIER, new Http2(), proxiedAddr, tooManyPingsRunnable, channelCredentials);
    }

    private OkHttpClientTransport(OkHttpChannelBuilder.OkHttpTransportFactory transportFactory, InetSocketAddress address, String authority, @Nullable String userAgent, Attributes eagAttrs, Supplier<Stopwatch> stopwatchFactory, Variant variant, @Nullable HttpConnectProxiedSocketAddress proxiedAddr, Runnable tooManyPingsRunnable, ChannelCredentials channelCredentials) {
        TrustManager tempX509TrustManager;
        this.address = (InetSocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.defaultAuthority = authority;
        this.maxMessageSize = transportFactory.maxMessageSize;
        this.initialWindowSize = transportFactory.flowControlWindow;
        this.executor = (Executor)Preconditions.checkNotNull((Object)transportFactory.executor, (Object)"executor");
        this.serializingExecutor = new SerializingExecutor(transportFactory.executor);
        this.scheduler = (ScheduledExecutorService)Preconditions.checkNotNull((Object)transportFactory.scheduledExecutorService, (Object)"scheduledExecutorService");
        this.nextStreamId = 3;
        this.socketFactory = transportFactory.socketFactory == null ? SocketFactory.getDefault() : transportFactory.socketFactory;
        this.sslSocketFactory = transportFactory.sslSocketFactory;
        this.hostnameVerifier = transportFactory.hostnameVerifier != null ? transportFactory.hostnameVerifier : OkHostnameVerifier.INSTANCE;
        this.connectionSpec = (ConnectionSpec)Preconditions.checkNotNull((Object)transportFactory.connectionSpec, (Object)"connectionSpec");
        this.stopwatchFactory = (Supplier)Preconditions.checkNotNull(stopwatchFactory, (Object)"stopwatchFactory");
        this.variant = (Variant)Preconditions.checkNotNull((Object)variant, (Object)"variant");
        this.userAgent = GrpcUtil.getGrpcUserAgent((String)"okhttp", (String)userAgent);
        this.proxiedAddr = proxiedAddr;
        this.tooManyPingsRunnable = (Runnable)Preconditions.checkNotNull((Object)tooManyPingsRunnable, (Object)"tooManyPingsRunnable");
        this.maxInboundMetadataSize = transportFactory.maxInboundMetadataSize;
        this.transportTracer = transportFactory.transportTracerFactory.create();
        this.logId = InternalLogId.allocate(this.getClass(), (String)address.toString());
        this.attributes = Attributes.newBuilder().set(GrpcAttributes.ATTR_CLIENT_EAG_ATTRS, (Object)eagAttrs).build();
        this.useGetForSafeMethods = transportFactory.useGetForSafeMethods;
        this.initTransportTracer();
        if (channelCredentials instanceof TlsChannelCredentials && x509ExtendedTrustManagerClass != null) {
            try {
                tempX509TrustManager = this.getTrustManager((TlsChannelCredentials)channelCredentials);
            }
            catch (GeneralSecurityException e) {
                tempX509TrustManager = null;
                log.log(Level.WARNING, "Obtaining X509ExtendedTrustManager for the transport failed.Per-rpc authority overrides will be disallowed.", e);
            }
        } else {
            tempX509TrustManager = null;
        }
        this.x509TrustManager = tempX509TrustManager;
    }

    @VisibleForTesting
    OkHttpClientTransport(OkHttpChannelBuilder.OkHttpTransportFactory transportFactory, String userAgent, Supplier<Stopwatch> stopwatchFactory, Variant variant, @Nullable Runnable connectingCallback, SettableFuture<Void> connectedFuture, Runnable tooManyPingsRunnable) {
        this(transportFactory, new InetSocketAddress("127.0.0.1", 80), "notarealauthority:80", userAgent, Attributes.EMPTY, stopwatchFactory, variant, null, tooManyPingsRunnable, null);
        this.connectingCallback = connectingCallback;
        this.connectedFuture = (SettableFuture)Preconditions.checkNotNull(connectedFuture, (Object)"connectedFuture");
    }

    boolean isUsingPlaintext() {
        return this.sslSocketFactory == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTransportTracer() {
        Object object = this.lock;
        synchronized (object) {
            this.transportTracer.setFlowControlWindowReader(new TransportTracer.FlowControlReader(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public TransportTracer.FlowControlWindows read() {
                    Object object = OkHttpClientTransport.this.lock;
                    synchronized (object) {
                        long local = OkHttpClientTransport.this.outboundFlow == null ? -1L : (long)OkHttpClientTransport.this.outboundFlow.windowUpdate(null, 0);
                        long remote = (long)((float)OkHttpClientTransport.this.initialWindowSize * 0.5f);
                        return new TransportTracer.FlowControlWindows(local, remote);
                    }
                }
            });
        }
    }

    void enableKeepAlive(boolean enable, long keepAliveTimeNanos, long keepAliveTimeoutNanos, boolean keepAliveWithoutCalls) {
        this.enableKeepAlive = enable;
        this.keepAliveTimeNanos = keepAliveTimeNanos;
        this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
        this.keepAliveWithoutCalls = keepAliveWithoutCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping(ClientTransport.PingCallback callback, Executor executor) {
        Http2Ping p;
        long data = 0L;
        Object object = this.lock;
        synchronized (object) {
            boolean writePing;
            Preconditions.checkState((this.frameWriter != null ? 1 : 0) != 0);
            if (this.stopped) {
                Http2Ping.notifyFailed((ClientTransport.PingCallback)callback, (Executor)executor, (Status)this.getPingFailure());
                return;
            }
            if (this.ping != null) {
                p = this.ping;
                writePing = false;
            } else {
                data = this.random.nextLong();
                Stopwatch stopwatch = (Stopwatch)this.stopwatchFactory.get();
                stopwatch.start();
                p = this.ping = new Http2Ping(data, stopwatch);
                writePing = true;
                this.transportTracer.reportKeepAliveSent();
            }
            if (writePing) {
                this.frameWriter.ping(false, (int)(data >>> 32), (int)data);
            }
        }
        p.addCallback(callback, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OkHttpClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        Preconditions.checkNotNull(method, (Object)"method");
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        StatsTraceContext statsTraceContext = StatsTraceContext.newClientContext((ClientStreamTracer[])tracers, (Attributes)this.getAttributes(), (Metadata)headers);
        Object object = this.lock;
        synchronized (object) {
            return new OkHttpClientStream(method, headers, this.frameWriter, this, this.outboundFlow, this.lock, this.maxMessageSize, this.initialWindowSize, this.defaultAuthority, this.userAgent, statsTraceContext, this.transportTracer, callOptions, this.useGetForSafeMethods);
        }
    }

    private TrustManager getTrustManager(TlsChannelCredentials tlsCreds) throws GeneralSecurityException {
        TrustManager[] tm;
        if (tlsCreds.getTrustManagers() != null) {
            tm = tlsCreds.getTrustManagers().toArray(new TrustManager[0]);
        } else if (tlsCreds.getRootCertificates() != null) {
            tm = CertificateUtils.createTrustManager((byte[])tlsCreds.getRootCertificates());
        } else {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init((KeyStore)null);
            tm = tmf.getTrustManagers();
        }
        for (TrustManager trustManager : tm) {
            if (!(trustManager instanceof X509TrustManager)) continue;
            return trustManager;
        }
        return null;
    }

    @GuardedBy(value="lock")
    void streamReadyToStart(OkHttpClientStream clientStream, String authority) {
        if (this.goAwayStatus != null) {
            clientStream.transportState().transportReportStatus(this.goAwayStatus, ClientStreamListener.RpcProgress.MISCARRIED, true, new Metadata());
        } else {
            if (this.socket instanceof SSLSocket && !authority.equals(this.defaultAuthority)) {
                Status authorityVerificationResult;
                if (this.authorityVerificationResults.containsKey(authority)) {
                    authorityVerificationResult = this.authorityVerificationResults.get(authority);
                } else {
                    authorityVerificationResult = this.verifyAuthority(authority);
                    this.authorityVerificationResults.put(authority, authorityVerificationResult);
                }
                if (!authorityVerificationResult.isOk() && enablePerRpcAuthorityCheck) {
                    clientStream.transportState().transportReportStatus(authorityVerificationResult, ClientStreamListener.RpcProgress.PROCESSED, true, new Metadata());
                    return;
                }
            }
            if (this.streams.size() >= this.maxConcurrentStreams) {
                this.pendingStreams.add(clientStream);
                this.setInUse(clientStream);
            } else {
                this.startStream(clientStream);
            }
        }
    }

    private Status verifyAuthority(String authority) {
        Status authorityVerificationResult = this.hostnameVerifier.verify(authority, ((SSLSocket)this.socket).getSession()) ? Status.OK : Status.UNAVAILABLE.withDescription(String.format("HostNameVerifier verification failed for authority '%s'", authority));
        if (!authorityVerificationResult.isOk() && !enablePerRpcAuthorityCheck) {
            log.log(Level.WARNING, String.format("HostNameVerifier verification failed for authority '%s'. This will be an error in the future.", authority));
        }
        if (authorityVerificationResult.isOk()) {
            if (this.x509TrustManager == null) {
                authorityVerificationResult = Status.UNAVAILABLE.withDescription(String.format("Could not verify authority '%s' for the rpc with no X509TrustManager available", authority));
            } else if (x509ExtendedTrustManagerClass.isInstance(this.x509TrustManager)) {
                try {
                    Certificate[] peerCertificates = this.sslSession.getPeerCertificates();
                    X509Certificate[] x509PeerCertificates = new X509Certificate[peerCertificates.length];
                    for (int i = 0; i < peerCertificates.length; ++i) {
                        x509PeerCertificates[i] = (X509Certificate)peerCertificates[i];
                    }
                    checkServerTrustedMethod.invoke((Object)this.x509TrustManager, x509PeerCertificates, "RSA", new SslSocketWrapper((SSLSocket)this.socket, authority));
                    authorityVerificationResult = Status.OK;
                }
                catch (IllegalAccessException | InvocationTargetException | SSLPeerUnverifiedException e) {
                    authorityVerificationResult = Status.UNAVAILABLE.withCause((Throwable)e).withDescription("Peer verification failed");
                }
                if (authorityVerificationResult.getCause() != null) {
                    log.log(Level.WARNING, authorityVerificationResult.getDescription() + ". This will be an error in the future.", authorityVerificationResult.getCause());
                } else {
                    log.log(Level.WARNING, authorityVerificationResult.getDescription() + ". This will be an error in the future.");
                }
            }
        }
        return authorityVerificationResult;
    }

    @GuardedBy(value="lock")
    private void startStream(OkHttpClientStream stream) {
        Preconditions.checkState((stream.transportState().id() == -1 ? 1 : 0) != 0, (Object)"StreamId already assigned");
        this.streams.put(this.nextStreamId, stream);
        this.setInUse(stream);
        stream.transportState().start(this.nextStreamId);
        if (stream.getType() != MethodDescriptor.MethodType.UNARY && stream.getType() != MethodDescriptor.MethodType.SERVER_STREAMING || stream.useGet()) {
            this.frameWriter.flush();
        }
        if (this.nextStreamId >= 0x7FFFFFFD) {
            this.nextStreamId = Integer.MAX_VALUE;
            this.startGoAway(Integer.MAX_VALUE, ErrorCode.NO_ERROR, Status.UNAVAILABLE.withDescription("Stream ids exhausted"));
        } else {
            this.nextStreamId += 2;
        }
    }

    @GuardedBy(value="lock")
    private boolean startPendingStreams() {
        boolean hasStreamStarted = false;
        while (!this.pendingStreams.isEmpty() && this.streams.size() < this.maxConcurrentStreams) {
            OkHttpClientStream stream = this.pendingStreams.poll();
            this.startStream(stream);
            hasStreamStarted = true;
        }
        return hasStreamStarted;
    }

    @GuardedBy(value="lock")
    void removePendingStream(OkHttpClientStream pendingStream) {
        this.pendingStreams.remove((Object)pendingStream);
        this.maybeClearInUse(pendingStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable start(ManagedClientTransport.Listener listener) {
        this.listener = (ManagedClientTransport.Listener)Preconditions.checkNotNull((Object)listener, (Object)"listener");
        if (this.enableKeepAlive) {
            this.keepAliveManager = new KeepAliveManager((KeepAliveManager.KeepAlivePinger)new KeepAliveManager.ClientKeepAlivePinger((KeepAliveManager.ClientKeepAlivePinger.TransportWithDisconnectReason)this), this.scheduler, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls);
            this.keepAliveManager.onTransportStarted();
        }
        int maxQueuedControlFrames = 10000;
        final AsyncSink asyncSink = AsyncSink.sink(this.serializingExecutor, this, maxQueuedControlFrames);
        FrameWriter rawFrameWriter = asyncSink.limitControlFramesWriter(this.variant.newWriter(Okio.buffer((Sink)asyncSink), true));
        Object object = this.lock;
        synchronized (object) {
            this.frameWriter = new ExceptionHandlingFrameWriter(this, rawFrameWriter);
            this.outboundFlow = new OutboundFlowController(this, this.frameWriter);
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch latchForExtraThread = new CountDownLatch(1);
        final CyclicBarrier barrier = new CyclicBarrier(2);
        this.serializingExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BufferedSource source = Okio.buffer((Source)new Source(){

                    public long read(Buffer sink, long byteCount) {
                        return -1L;
                    }

                    public Timeout timeout() {
                        return Timeout.NONE;
                    }

                    public void close() {
                    }
                });
                try {
                    try {
                        latch.await();
                        barrier.await(1000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (BrokenBarrierException | TimeoutException e) {
                        OkHttpClientTransport.this.startGoAway(0, ErrorCode.INTERNAL_ERROR, Status.UNAVAILABLE.withDescription("Timed out waiting for second handshake thread. The transport executor pool may have run out of threads"));
                        OkHttpClientTransport.this.clientFrameHandler = new ClientFrameHandler(OkHttpClientTransport.this.variant.newReader(source, true));
                        latchForExtraThread.countDown();
                        return;
                    }
                    if (OkHttpClientTransport.this.proxiedAddr == null) {
                        OkHttpClientTransport.this.sock = OkHttpClientTransport.this.socketFactory.createSocket(OkHttpClientTransport.this.address.getAddress(), OkHttpClientTransport.this.address.getPort());
                    } else if (OkHttpClientTransport.this.proxiedAddr.getProxyAddress() instanceof InetSocketAddress) {
                        OkHttpClientTransport.this.sock = OkHttpClientTransport.this.createHttpProxySocket(OkHttpClientTransport.this.proxiedAddr.getTargetAddress(), (InetSocketAddress)OkHttpClientTransport.this.proxiedAddr.getProxyAddress(), OkHttpClientTransport.this.proxiedAddr.getUsername(), OkHttpClientTransport.this.proxiedAddr.getPassword());
                    } else {
                        throw Status.INTERNAL.withDescription("Unsupported SocketAddress implementation " + OkHttpClientTransport.this.proxiedAddr.getProxyAddress().getClass()).asException();
                    }
                    if (OkHttpClientTransport.this.sslSocketFactory != null) {
                        SSLSocket sslSocket = OkHttpTlsUpgrader.upgrade(OkHttpClientTransport.this.sslSocketFactory, OkHttpClientTransport.this.hostnameVerifier, OkHttpClientTransport.this.sock, OkHttpClientTransport.this.getOverridenHost(), OkHttpClientTransport.this.getOverridenPort(), OkHttpClientTransport.this.connectionSpec);
                        OkHttpClientTransport.this.sslSession = sslSocket.getSession();
                        OkHttpClientTransport.this.sock = sslSocket;
                    }
                    OkHttpClientTransport.this.sock.setTcpNoDelay(true);
                    source = Okio.buffer((Source)Okio.source((Socket)OkHttpClientTransport.this.sock));
                    asyncSink.becomeConnected(Okio.sink((Socket)OkHttpClientTransport.this.sock), OkHttpClientTransport.this.sock);
                    OkHttpClientTransport.this.attributes = OkHttpClientTransport.this.attributes.toBuilder().set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)OkHttpClientTransport.this.sock.getRemoteSocketAddress()).set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, (Object)OkHttpClientTransport.this.sock.getLocalSocketAddress()).set(Grpc.TRANSPORT_ATTR_SSL_SESSION, (Object)OkHttpClientTransport.this.sslSession).set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)(OkHttpClientTransport.this.sslSession == null ? SecurityLevel.NONE : SecurityLevel.PRIVACY_AND_INTEGRITY)).build();
                }
                catch (StatusException e) {
                    OkHttpClientTransport.this.startGoAway(0, ErrorCode.INTERNAL_ERROR, e.getStatus());
                    return;
                }
                catch (Exception e) {
                    OkHttpClientTransport.this.onException(e);
                    return;
                }
                finally {
                    OkHttpClientTransport.this.clientFrameHandler = new ClientFrameHandler(OkHttpClientTransport.this.variant.newReader(source, true));
                    latchForExtraThread.countDown();
                }
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    OkHttpClientTransport.this.socket = (Socket)Preconditions.checkNotNull((Object)OkHttpClientTransport.this.sock, (Object)"socket");
                    if (OkHttpClientTransport.this.sslSession != null) {
                        OkHttpClientTransport.this.securityInfo = new InternalChannelz.Security(new InternalChannelz.Tls(OkHttpClientTransport.this.sslSession));
                    }
                }
            }
        });
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    barrier.await(1000L, TimeUnit.MILLISECONDS);
                    latchForExtraThread.await();
                }
                catch (BrokenBarrierException | TimeoutException exception) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
        try {
            this.sendConnectionPrefaceAndSettings();
        }
        finally {
            latch.countDown();
        }
        this.serializingExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (OkHttpClientTransport.this.connectingCallback != null) {
                    OkHttpClientTransport.this.connectingCallback.run();
                }
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    OkHttpClientTransport.this.maxConcurrentStreams = Integer.MAX_VALUE;
                    Preconditions.checkState((boolean)OkHttpClientTransport.this.pendingStreams.isEmpty(), (Object)"Pending streams detected during transport start. RPCs should not be started before transport is ready.");
                }
                OkHttpClientTransport.this.executor.execute(OkHttpClientTransport.this.clientFrameHandler);
                if (OkHttpClientTransport.this.connectedFuture != null) {
                    OkHttpClientTransport.this.connectedFuture.set(null);
                }
            }
        });
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendConnectionPrefaceAndSettings() {
        Object object = this.lock;
        synchronized (object) {
            this.frameWriter.connectionPreface();
            Settings settings = new Settings();
            OkHttpSettingsUtil.set(settings, 7, this.initialWindowSize);
            this.frameWriter.settings(settings);
            if (this.initialWindowSize > 65535) {
                this.frameWriter.windowUpdate(0, this.initialWindowSize - 65535);
            }
        }
    }

    private Socket createHttpProxySocket(InetSocketAddress address, InetSocketAddress proxyAddress, String proxyUsername, String proxyPassword) throws StatusException {
        Socket sock = null;
        try {
            sock = proxyAddress.getAddress() != null ? this.socketFactory.createSocket(proxyAddress.getAddress(), proxyAddress.getPort()) : this.socketFactory.createSocket(proxyAddress.getHostName(), proxyAddress.getPort());
            sock.setTcpNoDelay(true);
            sock.setSoTimeout(this.proxySocketTimeout);
            Source source = Okio.source((Socket)sock);
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((Socket)sock));
            Request proxyRequest = this.createHttpProxyRequest(address, proxyUsername, proxyPassword);
            HttpUrl url = proxyRequest.httpUrl();
            String requestLine = String.format(Locale.US, "CONNECT %s:%d HTTP/1.1", url.host(), url.port());
            sink.writeUtf8(requestLine).writeUtf8("\r\n");
            int size = proxyRequest.headers().size();
            for (int i = 0; i < size; ++i) {
                sink.writeUtf8(proxyRequest.headers().name(i)).writeUtf8(": ").writeUtf8(proxyRequest.headers().value(i)).writeUtf8("\r\n");
            }
            sink.writeUtf8("\r\n");
            sink.flush();
            StatusLine statusLine = StatusLine.parse(OkHttpClientTransport.readUtf8LineStrictUnbuffered(source));
            while (!OkHttpClientTransport.readUtf8LineStrictUnbuffered(source).equals("")) {
            }
            if (statusLine.code < 200 || statusLine.code >= 300) {
                Buffer body = new Buffer();
                try {
                    sock.shutdownOutput();
                    source.read(body, 1024L);
                }
                catch (IOException ex) {
                    body.writeUtf8("Unable to read body: " + ex.toString());
                }
                try {
                    sock.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                String message = String.format(Locale.US, "Response returned from proxy was not successful (expected 2xx, got %d %s). Response body:\n%s", statusLine.code, statusLine.message, body.readUtf8());
                throw Status.UNAVAILABLE.withDescription(message).asException();
            }
            sock.setSoTimeout(0);
            return sock;
        }
        catch (IOException e) {
            if (sock != null) {
                GrpcUtil.closeQuietly(sock);
            }
            throw Status.UNAVAILABLE.withDescription("Failed trying to connect with proxy").withCause((Throwable)e).asException();
        }
    }

    private Request createHttpProxyRequest(InetSocketAddress address, String proxyUsername, String proxyPassword) {
        HttpUrl tunnelUrl = new HttpUrl.Builder().scheme("https").host(address.getHostName()).port(address.getPort()).build();
        Request.Builder request = new Request.Builder().url(tunnelUrl).header("Host", tunnelUrl.host() + ":" + tunnelUrl.port()).header("User-Agent", this.userAgent);
        if (proxyUsername != null && proxyPassword != null) {
            request.header("Proxy-Authorization", Credentials.basic(proxyUsername, proxyPassword));
        }
        return request.build();
    }

    private static String readUtf8LineStrictUnbuffered(Source source) throws IOException {
        Buffer buffer = new Buffer();
        do {
            if (source.read(buffer, 1L) != -1L) continue;
            throw new EOFException("\\n not found: " + buffer.readByteString().hex());
        } while (buffer.getByte(buffer.size() - 1L) != 10);
        return buffer.readUtf8LineStrict();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("logId", this.logId.getId()).add("address", (Object)this.address).toString();
    }

    public InternalLogId getLogId() {
        return this.logId;
    }

    @VisibleForTesting
    String getOverridenHost() {
        URI uri = GrpcUtil.authorityToUri((String)this.defaultAuthority);
        if (uri.getHost() != null) {
            return uri.getHost();
        }
        return this.defaultAuthority;
    }

    @VisibleForTesting
    int getOverridenPort() {
        URI uri = GrpcUtil.authorityToUri((String)this.defaultAuthority);
        if (uri.getPort() != -1) {
            return uri.getPort();
        }
        return this.address.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(Status reason) {
        Object object = this.lock;
        synchronized (object) {
            if (this.goAwayStatus != null) {
                return;
            }
            this.goAwayStatus = reason;
            this.listener.transportShutdown(this.goAwayStatus, (DisconnectError)SimpleDisconnectError.SUBCHANNEL_SHUTDOWN);
            this.stopIfNecessary();
        }
    }

    public void shutdownNow(Status reason) {
        this.shutdownNow(reason, (DisconnectError)SimpleDisconnectError.SUBCHANNEL_SHUTDOWN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownNow(Status reason, DisconnectError disconnectError) {
        this.shutdown(reason);
        Object object = this.lock;
        synchronized (object) {
            Iterator<Map.Entry<Integer, OkHttpClientStream>> it = this.streams.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, OkHttpClientStream> entry = it.next();
                it.remove();
                entry.getValue().transportState().transportReportStatus(reason, false, new Metadata());
                this.maybeClearInUse(entry.getValue());
            }
            for (OkHttpClientStream stream : this.pendingStreams) {
                stream.transportState().transportReportStatus(reason, ClientStreamListener.RpcProgress.MISCARRIED, true, new Metadata());
                this.maybeClearInUse(stream);
            }
            this.pendingStreams.clear();
            this.stopIfNecessary();
        }
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutboundFlowController.StreamState[] getActiveStreams() {
        Object object = this.lock;
        synchronized (object) {
            OutboundFlowController.StreamState[] flowStreams = new OutboundFlowController.StreamState[this.streams.size()];
            int i = 0;
            for (OkHttpClientStream stream : this.streams.values()) {
                flowStreams[i++] = stream.transportState().getOutboundFlowState();
            }
            return flowStreams;
        }
    }

    @VisibleForTesting
    ClientFrameHandler getHandler() {
        return this.clientFrameHandler;
    }

    @VisibleForTesting
    SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getPendingStreamSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.pendingStreams.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void setNextStreamId(int nextStreamId) {
        Object object = this.lock;
        synchronized (object) {
            this.nextStreamId = nextStreamId;
        }
    }

    @Override
    public void onException(Throwable failureCause) {
        Preconditions.checkNotNull((Object)failureCause, (Object)"failureCause");
        Status status = Status.UNAVAILABLE.withCause(failureCause);
        this.startGoAway(0, ErrorCode.INTERNAL_ERROR, status);
    }

    private void onError(ErrorCode errorCode, String moreDetail) {
        this.startGoAway(0, errorCode, OkHttpClientTransport.toGrpcStatus(errorCode).augmentDescription(moreDetail));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startGoAway(int lastKnownStreamId, ErrorCode errorCode, Status status) {
        Object object = this.lock;
        synchronized (object) {
            if (this.goAwayStatus == null) {
                this.goAwayStatus = status;
                GrpcUtil.Http2Error http2Error = errorCode == null ? GrpcUtil.Http2Error.NO_ERROR : GrpcUtil.Http2Error.forCode((long)errorCode.httpCode);
                this.listener.transportShutdown(status, (DisconnectError)new GoAwayDisconnectError(http2Error));
            }
            if (errorCode != null && !this.goAwaySent) {
                this.goAwaySent = true;
                this.frameWriter.goAway(0, errorCode, new byte[0]);
            }
            Iterator<Map.Entry<Integer, OkHttpClientStream>> it = this.streams.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, OkHttpClientStream> entry = it.next();
                if (entry.getKey() <= lastKnownStreamId) continue;
                it.remove();
                entry.getValue().transportState().transportReportStatus(status, ClientStreamListener.RpcProgress.REFUSED, false, new Metadata());
                this.maybeClearInUse(entry.getValue());
            }
            for (OkHttpClientStream stream : this.pendingStreams) {
                stream.transportState().transportReportStatus(status, ClientStreamListener.RpcProgress.MISCARRIED, true, new Metadata());
                this.maybeClearInUse(stream);
            }
            this.pendingStreams.clear();
            this.stopIfNecessary();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishStream(int streamId, @Nullable Status status, ClientStreamListener.RpcProgress rpcProgress, boolean stopDelivery, @Nullable ErrorCode errorCode, @Nullable Metadata trailers) {
        Object object = this.lock;
        synchronized (object) {
            OkHttpClientStream stream = this.streams.remove(streamId);
            if (stream != null) {
                if (errorCode != null) {
                    this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                }
                if (status != null) {
                    stream.transportState().transportReportStatus(status, rpcProgress, stopDelivery, trailers != null ? trailers : new Metadata());
                }
                if (!this.startPendingStreams()) {
                    this.stopIfNecessary();
                }
                this.maybeClearInUse(stream);
            }
        }
    }

    @GuardedBy(value="lock")
    private void stopIfNecessary() {
        if (this.goAwayStatus == null || !this.streams.isEmpty() || !this.pendingStreams.isEmpty()) {
            return;
        }
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.keepAliveManager != null) {
            this.keepAliveManager.onTransportTermination();
        }
        if (this.ping != null) {
            this.ping.failed(this.getPingFailure());
            this.ping = null;
        }
        if (!this.goAwaySent) {
            this.goAwaySent = true;
            this.frameWriter.goAway(0, ErrorCode.NO_ERROR, new byte[0]);
        }
        this.frameWriter.close();
    }

    @GuardedBy(value="lock")
    private void maybeClearInUse(OkHttpClientStream stream) {
        if (this.hasStream && this.pendingStreams.isEmpty() && this.streams.isEmpty()) {
            this.hasStream = false;
            if (this.keepAliveManager != null) {
                this.keepAliveManager.onTransportIdle();
            }
        }
        if (stream.shouldBeCountedForInUse()) {
            this.inUseState.updateObjectInUse((Object)stream, false);
        }
    }

    @GuardedBy(value="lock")
    private void setInUse(OkHttpClientStream stream) {
        if (!this.hasStream) {
            this.hasStream = true;
            if (this.keepAliveManager != null) {
                this.keepAliveManager.onTransportActive();
            }
        }
        if (stream.shouldBeCountedForInUse()) {
            this.inUseState.updateObjectInUse((Object)stream, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status getPingFailure() {
        Object object = this.lock;
        synchronized (object) {
            if (this.goAwayStatus != null) {
                return this.goAwayStatus;
            }
            return Status.UNAVAILABLE.withDescription("Connection closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean mayHaveCreatedStream(int streamId) {
        Object object = this.lock;
        synchronized (object) {
            return streamId < this.nextStreamId && (streamId & 1) == 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OkHttpClientStream getStream(int streamId) {
        Object object = this.lock;
        synchronized (object) {
            return this.streams.get(streamId);
        }
    }

    @VisibleForTesting
    static Status toGrpcStatus(ErrorCode code) {
        Status status = ERROR_CODE_TO_STATUS.get((Object)code);
        return status != null ? status : Status.UNKNOWN.withDescription("Unknown http2 error code: " + code.httpCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        SettableFuture ret = SettableFuture.create();
        Object object = this.lock;
        synchronized (object) {
            if (this.socket == null) {
                ret.set((Object)new InternalChannelz.SocketStats(this.transportTracer.getStats(), null, null, new InternalChannelz.SocketOptions.Builder().build(), null));
            } else {
                ret.set((Object)new InternalChannelz.SocketStats(this.transportTracer.getStats(), this.socket.getLocalSocketAddress(), this.socket.getRemoteSocketAddress(), Utils.getSocketOptions(this.socket), this.securityInfo));
            }
            return ret;
        }
    }

    static {
        Class<?> x509ExtendedTrustManagerClass1 = null;
        Method checkServerTrustedMethod1 = null;
        try {
            x509ExtendedTrustManagerClass1 = Class.forName("javax.net.ssl.X509ExtendedTrustManager");
            checkServerTrustedMethod1 = x509ExtendedTrustManagerClass1.getMethod("checkServerTrusted", X509Certificate[].class, String.class, Socket.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        x509ExtendedTrustManagerClass = x509ExtendedTrustManagerClass1;
        checkServerTrustedMethod = checkServerTrustedMethod1;
    }

    static class FakeSslSession
    extends NoopSslSession {
        private final String peerHost;

        FakeSslSession(String peerHost) {
            this.peerHost = peerHost;
        }

        public String getPeerHost() {
            return this.peerHost;
        }
    }

    static final class SslSocketWrapper
    extends NoopSslSocket {
        private final SSLSession sslSession;
        private final SSLSocket sslSocket;

        SslSocketWrapper(SSLSocket sslSocket, String peerHost) {
            this.sslSocket = sslSocket;
            this.sslSession = new FakeSslSession(peerHost);
        }

        @Override
        public SSLSession getHandshakeSession() {
            return this.sslSession;
        }

        @Override
        public boolean isConnected() {
            return this.sslSocket.isConnected();
        }

        @Override
        public SSLParameters getSSLParameters() {
            return this.sslSocket.getSSLParameters();
        }
    }

    class ClientFrameHandler
    implements FrameReader.Handler,
    Runnable {
        private final OkHttpFrameLogger logger = new OkHttpFrameLogger(Level.FINE, OkHttpClientTransport.class);
        FrameReader frameReader;
        boolean firstSettings = true;

        ClientFrameHandler(FrameReader frameReader) {
            this.frameReader = frameReader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String threadName = Thread.currentThread().getName();
            Thread.currentThread().setName("OkHttpClientTransport");
            try {
                Status status;
                while (this.frameReader.nextFrame(this)) {
                    if (OkHttpClientTransport.this.keepAliveManager == null) continue;
                    OkHttpClientTransport.this.keepAliveManager.onDataReceived();
                }
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    status = OkHttpClientTransport.this.goAwayStatus;
                }
                if (status == null) {
                    status = Status.UNAVAILABLE.withDescription("End of stream or IOException");
                }
                OkHttpClientTransport.this.startGoAway(0, ErrorCode.INTERNAL_ERROR, status);
            }
            catch (Throwable t) {
                OkHttpClientTransport.this.startGoAway(0, ErrorCode.PROTOCOL_ERROR, Status.INTERNAL.withDescription("error in frame handler").withCause(t));
            }
            finally {
                block20: {
                    try {
                        this.frameReader.close();
                    }
                    catch (IOException ex) {
                        log.log(Level.INFO, "Exception closing frame reader", ex);
                    }
                    catch (RuntimeException e) {
                        if ("bio == null".equals(e.getMessage())) break block20;
                        throw e;
                    }
                }
                OkHttpClientTransport.this.listener.transportTerminated();
                Thread.currentThread().setName(threadName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void data(boolean inFinished, int streamId, BufferedSource in, int length, int paddedLength) throws IOException {
            Object object;
            this.logger.logData(OkHttpFrameLogger.Direction.INBOUND, streamId, in.getBuffer(), length, inFinished);
            OkHttpClientStream stream = OkHttpClientTransport.this.getStream(streamId);
            if (stream == null) {
                if (!OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                    OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received data for unknown stream: " + streamId);
                    return;
                }
                object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.STREAM_CLOSED);
                }
                in.skip((long)length);
            } else {
                in.require((long)length);
                Buffer buf = new Buffer();
                buf.write(in.getBuffer(), (long)length);
                PerfMark.event((String)"OkHttpClientTransport$ClientFrameHandler.data", (Tag)stream.transportState().tag());
                Object object2 = OkHttpClientTransport.this.lock;
                synchronized (object2) {
                    stream.transportState().transportDataReceived(buf, inFinished, paddedLength - length);
                }
            }
            OkHttpClientTransport.this.connectionUnacknowledgedBytesRead += paddedLength;
            if ((float)OkHttpClientTransport.this.connectionUnacknowledgedBytesRead >= (float)OkHttpClientTransport.this.initialWindowSize * 0.5f) {
                object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    OkHttpClientTransport.this.frameWriter.windowUpdate(0, OkHttpClientTransport.this.connectionUnacknowledgedBytesRead);
                }
                OkHttpClientTransport.this.connectionUnacknowledgedBytesRead = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void headers(boolean outFinished, boolean inFinished, int streamId, int associatedStreamId, List<Header> headerBlock, HeadersMode headersMode) {
            int metadataSize;
            this.logger.logHeaders(OkHttpFrameLogger.Direction.INBOUND, streamId, headerBlock, inFinished);
            boolean unknownStream = false;
            Status failedStatus = null;
            if (OkHttpClientTransport.this.maxInboundMetadataSize != Integer.MAX_VALUE && (metadataSize = this.headerBlockSize(headerBlock)) > OkHttpClientTransport.this.maxInboundMetadataSize) {
                failedStatus = Status.RESOURCE_EXHAUSTED.withDescription(String.format(Locale.US, "Response %s metadata larger than %d: %d", inFinished ? "trailer" : "header", OkHttpClientTransport.this.maxInboundMetadataSize, metadataSize));
            }
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                OkHttpClientStream stream = (OkHttpClientStream)((Object)OkHttpClientTransport.this.streams.get(streamId));
                if (stream == null) {
                    if (OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                        OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.STREAM_CLOSED);
                    } else {
                        unknownStream = true;
                    }
                } else if (failedStatus == null) {
                    PerfMark.event((String)"OkHttpClientTransport$ClientFrameHandler.headers", (Tag)stream.transportState().tag());
                    stream.transportState().transportHeadersReceived(headerBlock, inFinished);
                } else {
                    if (!inFinished) {
                        OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.CANCEL);
                    }
                    stream.transportState().transportReportStatus(failedStatus, false, new Metadata());
                }
            }
            if (unknownStream) {
                OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received header for unknown stream: " + streamId);
            }
        }

        private int headerBlockSize(List<Header> headerBlock) {
            long size = 0L;
            for (int i = 0; i < headerBlock.size(); ++i) {
                Header header = headerBlock.get(i);
                size += (long)(32 + header.name.size() + header.value.size());
            }
            size = Math.min(size, Integer.MAX_VALUE);
            return (int)size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void rstStream(int streamId, ErrorCode errorCode) {
            this.logger.logRstStream(OkHttpFrameLogger.Direction.INBOUND, streamId, errorCode);
            Status status = OkHttpClientTransport.toGrpcStatus(errorCode).augmentDescription("Rst Stream");
            boolean stopDelivery = status.getCode() == Status.Code.CANCELLED || status.getCode() == Status.Code.DEADLINE_EXCEEDED;
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                OkHttpClientStream stream = (OkHttpClientStream)((Object)OkHttpClientTransport.this.streams.get(streamId));
                if (stream != null) {
                    PerfMark.event((String)"OkHttpClientTransport$ClientFrameHandler.rstStream", (Tag)stream.transportState().tag());
                    OkHttpClientTransport.this.finishStream(streamId, status, errorCode == ErrorCode.REFUSED_STREAM ? ClientStreamListener.RpcProgress.REFUSED : ClientStreamListener.RpcProgress.PROCESSED, stopDelivery, null, null);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void settings(boolean clearPrevious, Settings settings) {
            this.logger.logSettings(OkHttpFrameLogger.Direction.INBOUND, settings);
            boolean outboundWindowSizeIncreased = false;
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                if (OkHttpSettingsUtil.isSet(settings, 4)) {
                    int receivedMaxConcurrentStreams = OkHttpSettingsUtil.get(settings, 4);
                    OkHttpClientTransport.this.maxConcurrentStreams = receivedMaxConcurrentStreams;
                }
                if (OkHttpSettingsUtil.isSet(settings, 7)) {
                    int initialWindowSize = OkHttpSettingsUtil.get(settings, 7);
                    outboundWindowSizeIncreased = OkHttpClientTransport.this.outboundFlow.initialOutboundWindowSize(initialWindowSize);
                }
                if (this.firstSettings) {
                    OkHttpClientTransport.this.attributes = OkHttpClientTransport.this.listener.filterTransport(OkHttpClientTransport.this.attributes);
                    OkHttpClientTransport.this.listener.transportReady();
                    this.firstSettings = false;
                }
                OkHttpClientTransport.this.frameWriter.ackSettings(settings);
                if (outboundWindowSizeIncreased) {
                    OkHttpClientTransport.this.outboundFlow.writeStreams();
                }
                OkHttpClientTransport.this.startPendingStreams();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ping(boolean ack, int payload1, int payload2) {
            long ackPayload = (long)payload1 << 32 | (long)payload2 & 0xFFFFFFFFL;
            this.logger.logPing(OkHttpFrameLogger.Direction.INBOUND, ackPayload);
            if (!ack) {
                Object object = OkHttpClientTransport.this.lock;
                synchronized (object) {
                    OkHttpClientTransport.this.frameWriter.ping(true, payload1, payload2);
                }
            }
            Http2Ping p = null;
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                if (OkHttpClientTransport.this.ping != null) {
                    if (OkHttpClientTransport.this.ping.payload() == ackPayload) {
                        p = OkHttpClientTransport.this.ping;
                        OkHttpClientTransport.this.ping = null;
                    } else {
                        log.log(Level.WARNING, String.format(Locale.US, "Received unexpected ping ack. Expecting %d, got %d", OkHttpClientTransport.this.ping.payload(), ackPayload));
                    }
                } else {
                    log.warning("Received unexpected ping ack. No ping outstanding");
                }
            }
            if (p != null) {
                p.complete();
            }
        }

        @Override
        public void ackSettings() {
        }

        @Override
        public void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            this.logger.logGoAway(OkHttpFrameLogger.Direction.INBOUND, lastGoodStreamId, errorCode, debugData);
            if (errorCode == ErrorCode.ENHANCE_YOUR_CALM) {
                String data = debugData.utf8();
                log.log(Level.WARNING, String.format("%s: Received GOAWAY with ENHANCE_YOUR_CALM. Debug data: %s", this, data));
                if ("too_many_pings".equals(data)) {
                    OkHttpClientTransport.this.tooManyPingsRunnable.run();
                }
            }
            Status status = GrpcUtil.Http2Error.statusForCode((long)errorCode.httpCode).augmentDescription("Received Goaway");
            if (debugData.size() > 0) {
                status = status.augmentDescription(debugData.utf8());
            }
            OkHttpClientTransport.this.startGoAway(lastGoodStreamId, null, status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) throws IOException {
            this.logger.logPushPromise(OkHttpFrameLogger.Direction.INBOUND, streamId, promisedStreamId, requestHeaders);
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                OkHttpClientTransport.this.frameWriter.rstStream(streamId, ErrorCode.PROTOCOL_ERROR);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowUpdate(int streamId, long delta) {
            this.logger.logWindowsUpdate(OkHttpFrameLogger.Direction.INBOUND, streamId, delta);
            if (delta == 0L) {
                String errorMsg = "Received 0 flow control window increment.";
                if (streamId == 0) {
                    OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, errorMsg);
                } else {
                    OkHttpClientTransport.this.finishStream(streamId, Status.INTERNAL.withDescription(errorMsg), ClientStreamListener.RpcProgress.PROCESSED, false, ErrorCode.PROTOCOL_ERROR, null);
                }
                return;
            }
            boolean unknownStream = false;
            Object object = OkHttpClientTransport.this.lock;
            synchronized (object) {
                if (streamId == 0) {
                    OkHttpClientTransport.this.outboundFlow.windowUpdate(null, (int)delta);
                    return;
                }
                OkHttpClientStream stream = (OkHttpClientStream)((Object)OkHttpClientTransport.this.streams.get(streamId));
                if (stream != null) {
                    OkHttpClientTransport.this.outboundFlow.windowUpdate(stream.transportState().getOutboundFlowState(), (int)delta);
                } else if (!OkHttpClientTransport.this.mayHaveCreatedStream(streamId)) {
                    unknownStream = true;
                }
            }
            if (unknownStream) {
                OkHttpClientTransport.this.onError(ErrorCode.PROTOCOL_ERROR, "Received window_update for unknown stream: " + streamId);
            }
        }

        @Override
        public void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        @Override
        public void alternateService(int streamId, String origin, ByteString protocol, String host, int port, long maxAge) {
        }
    }

    private static class LruCache<T>
    extends LinkedHashMap<String, T> {
        private LruCache() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, T> eldest) {
            return this.size() > 100;
        }
    }
}

