/*
 * Copyright 2015 The gRPC Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.grpc;

import javax.annotation.Nullable;

/**
 * StatusRuntimeException without stack trace, implemented as a subclass, as the
 * {@code String, Throwable, boolean, boolean} constructor is not available in the supported
 * version of Android.
 *
 * @see StatusRuntimeException
 */
class InternalStatusRuntimeException extends StatusRuntimeException {
  private static final long serialVersionUID = 0;

  public InternalStatusRuntimeException(Status status, @Nullable Metadata trailers) {
    super(status, trailers);
  }

  @Override
  public synchronized Throwable fillInStackTrace() {
    return this;
  }
}
