/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.android;

import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;

class UdsSocket
extends Socket {
    private final LocalSocket localSocket;
    private final LocalSocketAddress localSocketAddress;
    @GuardedBy(value="this")
    private boolean closed = false;
    @GuardedBy(value="this")
    private boolean inputShutdown = false;
    @GuardedBy(value="this")
    private boolean outputShutdown = false;

    public UdsSocket(LocalSocketAddress localSocketAddress) {
        this.localSocketAddress = localSocketAddress;
        this.localSocket = new LocalSocket();
    }

    @Override
    public void bind(SocketAddress bindpoint) {
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (!this.inputShutdown) {
            this.shutdownInput();
        }
        if (!this.outputShutdown) {
            this.shutdownOutput();
        }
        this.localSocket.close();
        this.closed = true;
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.localSocket.connect(this.localSocketAddress);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.localSocket.connect(this.localSocketAddress, timeout);
    }

    @Override
    public SocketChannel getChannel() {
        throw new UnsupportedOperationException("getChannel() not supported");
    }

    @Override
    public InetAddress getInetAddress() {
        throw new UnsupportedOperationException("getInetAddress() not supported");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FilterInputStream(this.localSocket.getInputStream()){

            @Override
            public void close() throws IOException {
                UdsSocket.this.close();
            }
        };
    }

    @Override
    public boolean getKeepAlive() {
        throw new UnsupportedOperationException("Unsupported operation getKeepAlive()");
    }

    @Override
    public InetAddress getLocalAddress() {
        throw new UnsupportedOperationException("Unsupported operation getLocalAddress()");
    }

    @Override
    public int getLocalPort() {
        throw new UnsupportedOperationException("Unsupported operation getLocalPort()");
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return new SocketAddress(){};
    }

    @Override
    public boolean getOOBInline() {
        throw new UnsupportedOperationException("Unsupported operation getOOBInline()");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return new FilterOutputStream(this.localSocket.getOutputStream()){

            @Override
            public void close() throws IOException {
                UdsSocket.this.close();
            }
        };
    }

    @Override
    public int getPort() {
        throw new UnsupportedOperationException("Unsupported operation getPort()");
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        try {
            return this.localSocket.getReceiveBufferSize();
        }
        catch (IOException e) {
            throw UdsSocket.toSocketException(e);
        }
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return new SocketAddress(){};
    }

    @Override
    public boolean getReuseAddress() {
        throw new UnsupportedOperationException("Unsupported operation getReuseAddress()");
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        try {
            return this.localSocket.getSendBufferSize();
        }
        catch (IOException e) {
            throw UdsSocket.toSocketException(e);
        }
    }

    @Override
    public int getSoLinger() {
        return -1;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        try {
            return this.localSocket.getSoTimeout();
        }
        catch (IOException e) {
            throw UdsSocket.toSocketException(e);
        }
    }

    @Override
    public boolean getTcpNoDelay() {
        return true;
    }

    @Override
    public int getTrafficClass() {
        throw new UnsupportedOperationException("Unsupported operation getTrafficClass()");
    }

    @Override
    public boolean isBound() {
        return this.localSocket.isBound();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isConnected() {
        return this.localSocket.isConnected();
    }

    @Override
    public synchronized boolean isInputShutdown() {
        return this.inputShutdown;
    }

    @Override
    public synchronized boolean isOutputShutdown() {
        return this.outputShutdown;
    }

    @Override
    public void sendUrgentData(int data) {
        throw new UnsupportedOperationException("Unsupported operation sendUrgentData()");
    }

    @Override
    public void setKeepAlive(boolean on) {
        throw new UnsupportedOperationException("Unsupported operation setKeepAlive()");
    }

    @Override
    public void setOOBInline(boolean on) {
        throw new UnsupportedOperationException("Unsupported operation setOOBInline()");
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        throw new UnsupportedOperationException("Unsupported operation setPerformancePreferences()");
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        try {
            this.localSocket.setReceiveBufferSize(size);
        }
        catch (IOException e) {
            throw UdsSocket.toSocketException(e);
        }
    }

    @Override
    public void setReuseAddress(boolean on) {
        throw new UnsupportedOperationException("Unsupported operation setReuseAddress()");
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        try {
            this.localSocket.setSendBufferSize(size);
        }
        catch (IOException e) {
            throw UdsSocket.toSocketException(e);
        }
    }

    @Override
    public void setSoLinger(boolean on, int linger) {
        throw new UnsupportedOperationException("Unsupported operation setSoLinger()");
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        try {
            this.localSocket.setSoTimeout(timeout);
        }
        catch (IOException e) {
            throw UdsSocket.toSocketException(e);
        }
    }

    @Override
    public void setTcpNoDelay(boolean on) {
    }

    @Override
    public void setTrafficClass(int tc) {
        throw new UnsupportedOperationException("Unsupported operation setTrafficClass()");
    }

    @Override
    public synchronized void shutdownInput() throws IOException {
        this.localSocket.shutdownInput();
        this.inputShutdown = true;
    }

    @Override
    public synchronized void shutdownOutput() throws IOException {
        this.localSocket.shutdownOutput();
        this.outputShutdown = true;
    }

    private static SocketException toSocketException(Throwable e) {
        SocketException se = new SocketException();
        se.initCause(e);
        return se;
    }
}

