/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.fallback;

import io.github.resilience4j.fallback.FallbackDecorator;
import io.github.resilience4j.fallback.FallbackMethod;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;

public class CompletionStageFallbackDecorator
implements FallbackDecorator {
    @Override
    public boolean supports(Class<?> target) {
        return CompletionStage.class.isAssignableFrom(target);
    }

    @Override
    public CheckedFunction0<Object> decorate(FallbackMethod fallbackMethod, CheckedFunction0<Object> supplier) {
        return supplier.andThen((CheckedFunction1 & Serializable)request -> {
            CompletionStage completionStage = (CompletionStage)request;
            CompletableFuture promise = new CompletableFuture();
            completionStage.whenComplete((result, throwable) -> {
                if (throwable != null) {
                    if (throwable instanceof CompletionException || throwable instanceof ExecutionException) {
                        this.tryRecover(fallbackMethod, promise, throwable.getCause());
                    } else {
                        this.tryRecover(fallbackMethod, promise, (Throwable)throwable);
                    }
                } else {
                    promise.complete(result);
                }
            });
            return promise;
        });
    }

    private void tryRecover(FallbackMethod fallbackMethod, CompletableFuture promise, Throwable throwable) {
        try {
            CompletionStage completionStage = (CompletionStage)fallbackMethod.fallback(throwable);
            completionStage.whenComplete((fallbackResult, fallbackThrowable) -> {
                if (fallbackThrowable != null) {
                    promise.completeExceptionally((Throwable)fallbackThrowable);
                } else {
                    promise.complete(fallbackResult);
                }
            });
        }
        catch (Throwable fallbackThrowable2) {
            promise.completeExceptionally(fallbackThrowable2);
        }
    }
}

