/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.springboot3.micrometer.monitoring.endpoint;

import io.github.resilience4j.common.micrometer.monitoring.endpoint.TimerEventDTOFactory;
import io.github.resilience4j.common.micrometer.monitoring.endpoint.TimerEventsEndpointResponse;
import io.github.resilience4j.consumer.CircularEventConsumer;
import io.github.resilience4j.consumer.EventConsumerRegistry;
import io.github.resilience4j.micrometer.event.TimerEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.Selector;

@Endpoint(id="timerevents")
public class TimerEventsEndpoint {
    private final EventConsumerRegistry<TimerEvent> eventConsumerRegistry;

    public TimerEventsEndpoint(EventConsumerRegistry<TimerEvent> eventConsumerRegistry) {
        this.eventConsumerRegistry = eventConsumerRegistry;
    }

    @ReadOperation
    public TimerEventsEndpointResponse getAllTimerEvents() {
        return new TimerEventsEndpointResponse(this.eventConsumerRegistry.getAllEventConsumer().stream().flatMap(CircularEventConsumer::getBufferedEventsStream).sorted(Comparator.comparing(TimerEvent::getCreationTime)).map(TimerEventDTOFactory::createTimerEventDTO).collect(Collectors.toList()));
    }

    @ReadOperation
    public TimerEventsEndpointResponse getEventsFilteredByTimerName(@Selector String name) {
        return new TimerEventsEndpointResponse(this.getTimerEvents(name).stream().map(TimerEventDTOFactory::createTimerEventDTO).collect(Collectors.toList()));
    }

    @ReadOperation
    public TimerEventsEndpointResponse getEventsFilteredByTimerNameAndEventType(@Selector String name, @Selector String eventType) {
        return new TimerEventsEndpointResponse(this.getTimerEvents(name).stream().filter(event -> event.getEventType() == TimerEvent.Type.valueOf((String)eventType.toUpperCase())).map(TimerEventDTOFactory::createTimerEventDTO).collect(Collectors.toList()));
    }

    private List<TimerEvent> getTimerEvents(String name) {
        CircularEventConsumer syncEvents = this.eventConsumerRegistry.getEventConsumer(name);
        if (syncEvents != null) {
            return syncEvents.getBufferedEventsStream().filter(event -> event.getTimerName().equals(name)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

