/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.reactor.micrometer.operator;

import io.github.resilience4j.micrometer.Timer;
import io.github.resilience4j.reactor.AbstractSubscriber;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import reactor.core.CoreSubscriber;

class TimerSubscriber<T>
extends AbstractSubscriber<T> {
    private final Timer.Context context;
    private final AtomicBoolean successSignaled = new AtomicBoolean(false);

    TimerSubscriber(Timer timer, CoreSubscriber<? super T> downstreamSubscriber) {
        super(downstreamSubscriber);
        this.context = Objects.requireNonNull(timer, "Timer is null").createContext();
    }

    protected void hookOnNext(T value) {
        if (!this.isDisposed()) {
            this.downstreamSubscriber.onNext(value);
        }
    }

    protected void hookOnComplete() {
        if (this.successSignaled.compareAndSet(false, true)) {
            this.context.onSuccess();
        }
        this.downstreamSubscriber.onComplete();
    }

    protected void hookOnCancel() {
        if (!this.successSignaled.get()) {
            this.context.onSuccess();
        }
    }

    protected void hookOnError(Throwable e) {
        this.context.onFailure(e);
        this.downstreamSubscriber.onError(e);
    }
}

