/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.feign;

import io.github.resilience4j.core.functions.CheckedFunction;
import io.github.resilience4j.feign.FallbackHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Function;
import java.util.function.Predicate;

class FallbackFactory<T>
implements FallbackHandler<T> {
    private final Function<Exception, T> fallbackSupplier;

    FallbackFactory(Function<Exception, T> fallbackSupplier) {
        this.fallbackSupplier = fallbackSupplier;
    }

    @Override
    public CheckedFunction<Object[], Object> decorate(CheckedFunction<Object[], Object> invocationCall, Method method, Predicate<Exception> filter) {
        return args -> {
            try {
                return invocationCall.apply(args);
            }
            catch (Exception exception) {
                if (filter.test(exception)) {
                    T fallbackInstance = this.fallbackSupplier.apply(exception);
                    Method fallbackMethod = this.validateAndGetFallbackMethod(fallbackInstance, method);
                    try {
                        return fallbackMethod.invoke(fallbackInstance, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
                throw exception;
            }
        };
    }
}

