/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render;

import com.openhtmltopdf.context.ContentFunctionFactory;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.FSRGBColor;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.derived.BorderPropertySet;
import com.openhtmltopdf.css.style.derived.RectPropertySet;
import com.openhtmltopdf.extend.StructureType;
import com.openhtmltopdf.layout.InlineBoxing;
import com.openhtmltopdf.layout.InlinePaintable;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.PaintingInfo;
import com.openhtmltopdf.render.AnonymousBlockBox;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.CharCounts;
import com.openhtmltopdf.render.FSFontMetrics;
import com.openhtmltopdf.render.InlineText;
import com.openhtmltopdf.render.JustificationInfo;
import com.openhtmltopdf.render.LineBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.TextDecoration;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.w3c.dom.Element;

public class InlineLayoutBox
extends Box
implements InlinePaintable {
    private int _baseline;
    private boolean _startsHere;
    private boolean _endsHere;
    private List<Object> _inlineChildren;
    private boolean _pending;
    private int _inlineWidth;
    private List<TextDecoration> _textDecorations;
    private int _containingBlockWidth;

    public InlineLayoutBox(LayoutContext c, Element elem, CalculatedStyle style, int cbWidth) {
        this();
        this.setElement(elem);
        this.setStyle(style);
        this.setContainingBlockWidth(cbWidth);
        this.setMarginTop(c, 0);
        this.setMarginBottom(c, 0);
        this.setPending(true);
        this.calculateHeight(c);
    }

    private InlineLayoutBox() {
        this.setState(3);
    }

    public InlineLayoutBox copyOf() {
        InlineLayoutBox result = new InlineLayoutBox();
        result.setElement(this.getElement());
        result.setStyle(this.getStyle());
        result.setHeight(this.getHeight());
        result._pending = this._pending;
        result.setContainingLayer(this.getContainingLayer());
        return result;
    }

    public void calculateHeight(LayoutContext c) {
        BorderPropertySet border = this.getBorder(c);
        RectPropertySet padding = this.getPadding(c);
        FSFontMetrics metrics = this.getStyle().getFSFontMetrics(c);
        this.setHeight((int)Math.ceil(border.top() + padding.top() + metrics.getAscent() + metrics.getDescent() + padding.bottom() + border.bottom()));
    }

    public int getBaseline() {
        return this._baseline;
    }

    public void setBaseline(int baseline) {
        this._baseline = baseline;
    }

    public int getInlineChildCount() {
        return this._inlineChildren == null ? 0 : this._inlineChildren.size();
    }

    public void addInlineChild(LayoutContext c, Object child) {
        this.addInlineChild(c, child, true);
    }

    public void addInlineChild(LayoutContext c, Object child, boolean callUnmarkPending) {
        if (this._inlineChildren == null) {
            this._inlineChildren = new ArrayList<Object>();
        }
        this._inlineChildren.add(child);
        if (callUnmarkPending && this.isPending()) {
            this.unmarkPending(c);
        }
        if (child instanceof Box) {
            Box b = (Box)child;
            b.setParent(this);
            b.initContainingLayer(c);
        } else if (child instanceof InlineText) {
            ((InlineText)child).setParent(this);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public List<Object> getInlineChildren() {
        return this._inlineChildren == null ? Collections.emptyList() : this._inlineChildren;
    }

    public Object getInlineChild(int i) {
        if (this._inlineChildren == null) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._inlineChildren.get(i);
    }

    public int getInlineWidth(CssContext cssCtx) {
        return this._inlineWidth;
    }

    public void prunePending(LayoutContext c) {
        if (this.getInlineChildCount() > 0) {
            Object child;
            for (int i = this.getInlineChildCount() - 1; i >= 0 && (child = this.getInlineChild(i)) instanceof InlineLayoutBox; --i) {
                InlineLayoutBox iB = (InlineLayoutBox)child;
                iB.prunePending(c);
                if (!iB.isPending()) break;
                if (iB.getElement() != null && iB.getElement().hasAttribute("id")) {
                    c.removeBoxId(iB.getElement().getAttribute("id"));
                }
                this.removeChild(i);
            }
        }
    }

    public boolean isEndsHere() {
        return this._endsHere;
    }

    public void setEndsHere(boolean endsHere) {
        this._endsHere = endsHere;
    }

    public boolean isStartsHere() {
        return this._startsHere;
    }

    public void setStartsHere(boolean startsHere) {
        this._startsHere = startsHere;
    }

    public boolean isPending() {
        return this._pending;
    }

    public void setPending(boolean b) {
        this._pending = b;
    }

    public void unmarkPending(LayoutContext c) {
        InlineLayoutBox iB;
        this._pending = false;
        if (this.getParent() instanceof InlineLayoutBox && (iB = (InlineLayoutBox)this.getParent()).isPending()) {
            iB.unmarkPending(c);
        }
        this.setStartsHere(true);
        if (this.getStyle().requiresLayer()) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.LAYOUT_NO_INLINE_LAYERS);
        }
    }

    @Override
    public void connectChildrenToCurrentLayer(LayoutContext c) {
        if (this.getInlineChildCount() > 0) {
            for (int i = 0; i < this.getInlineChildCount(); ++i) {
                Object obj = this.getInlineChild(i);
                if (!(obj instanceof Box)) continue;
                Box box = (Box)obj;
                box.setContainingLayer(c.getLayer());
                box.connectChildrenToCurrentLayer(c);
            }
        }
    }

    public void paintSelection(RenderingContext c) {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object child = this.getInlineChild(i);
            if (!(child instanceof InlineText)) continue;
            ((InlineText)child).paintSelection(c);
        }
    }

    @Override
    public void paintInline(RenderingContext c) {
        if (!this.getStyle().isVisible(c, this)) {
            return;
        }
        Object token1 = c.getOutputDevice().startStructure(StructureType.BACKGROUND, this);
        this.paintBackground(c);
        this.paintBorder(c);
        if (c.debugDrawInlineBoxes()) {
            this.paintDebugOutline(c);
        }
        List<TextDecoration> textDecorations = this.getTextDecorations();
        for (TextDecoration tD : textDecorations) {
            IdentValue ident = tD.getIdentValue();
            if (ident != IdentValue.UNDERLINE && ident != IdentValue.OVERLINE) continue;
            c.getOutputDevice().drawTextDecoration(c, this, tD);
        }
        c.getOutputDevice().endStructure(token1);
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object child = this.getInlineChild(i);
            if (child instanceof InlineText) {
                Object tokenText = c.getOutputDevice().startStructure(StructureType.TEXT, this);
                ((InlineText)child).paint(c);
                c.getOutputDevice().endStructure(tokenText);
                continue;
            }
            if (!(child instanceof Box)) continue;
            Object tokenChildBox = c.getOutputDevice().startStructure(StructureType.INLINE_CHILD_BOX, (Box)child);
            c.getOutputDevice().endStructure(tokenChildBox);
        }
        Object token3 = c.getOutputDevice().startStructure(StructureType.BACKGROUND, this);
        for (TextDecoration tD : textDecorations) {
            IdentValue ident = tD.getIdentValue();
            if (ident != IdentValue.LINE_THROUGH) continue;
            c.getOutputDevice().drawTextDecoration(c, this, tD);
        }
        c.getOutputDevice().endStructure(token3);
    }

    @Override
    public boolean hasNonTextContent(CssContext c) {
        if (this._textDecorations != null && this._textDecorations.size() > 0) {
            return true;
        }
        return super.hasNonTextContent(c);
    }

    public boolean isAllTextItems(CssContext c) {
        return this.getInlineChildren().stream().allMatch(child -> child instanceof InlineText);
    }

    @Override
    public int getBorderSides() {
        int result = 5;
        if (this._startsHere) {
            result += 2;
        }
        if (this._endsHere) {
            result += 8;
        }
        return result;
    }

    @Override
    public Rectangle getBorderEdge(int left, int top, CssContext cssCtx) {
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        if (this._startsHere || this._endsHere) {
            RectPropertySet margin = this.getMargin(cssCtx);
            if (this._startsHere) {
                marginLeft = margin.left();
            }
            if (this._endsHere) {
                marginRight = margin.right();
            }
        }
        BorderPropertySet border = this.getBorder(cssCtx);
        RectPropertySet padding = this.getPadding(cssCtx);
        Rectangle result = new Rectangle((int)((float)left + marginLeft), (int)((float)top - border.top() - padding.top()), (int)((float)this.getInlineWidth(cssCtx) - marginLeft - marginRight), this.getHeight());
        return result;
    }

    @Override
    public Rectangle getMarginEdge(int left, int top, CssContext cssCtx, int tx, int ty) {
        Rectangle result = this.getBorderEdge(left, top, cssCtx);
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        if (this._startsHere || this._endsHere) {
            RectPropertySet margin = this.getMargin(cssCtx);
            if (this._startsHere) {
                marginLeft = margin.left();
            }
            if (this._endsHere) {
                marginRight = margin.right();
            }
        }
        if (marginRight > 0.0f) {
            result.width = (int)((float)result.width + marginRight);
        }
        if (marginLeft > 0.0f) {
            result.x = (int)((float)result.x - marginLeft);
            result.width = (int)((float)result.width + marginLeft);
        }
        result.translate(tx, ty);
        return result;
    }

    @Override
    public Rectangle getContentAreaEdge(int left, int top, CssContext cssCtx) {
        BorderPropertySet border = this.getBorder(cssCtx);
        RectPropertySet padding = this.getPadding(cssCtx);
        float marginLeft = 0.0f;
        float marginRight = 0.0f;
        float borderLeft = 0.0f;
        float borderRight = 0.0f;
        float paddingLeft = 0.0f;
        float paddingRight = 0.0f;
        if (this._startsHere || this._endsHere) {
            RectPropertySet margin = this.getMargin(cssCtx);
            if (this._startsHere) {
                marginLeft = margin.left();
                borderLeft = border.left();
                paddingLeft = padding.left();
            }
            if (this._endsHere) {
                marginRight = margin.right();
                borderRight = border.right();
                paddingRight = padding.right();
            }
        }
        Rectangle result = new Rectangle((int)((float)left + marginLeft + borderLeft + paddingLeft), (int)((float)top - border.top() - padding.top()), (int)((float)this.getInlineWidth(cssCtx) - marginLeft - borderLeft - paddingLeft - paddingRight - borderRight - marginRight), this.getHeight());
        return result;
    }

    public int getLeftMarginBorderPadding(CssContext cssCtx) {
        if (this._startsHere) {
            return this.getMarginBorderPadding(cssCtx, 1);
        }
        return 0;
    }

    public int getRightMarginPaddingBorder(CssContext cssCtx) {
        if (this._endsHere) {
            return this.getMarginBorderPadding(cssCtx, 2);
        }
        return 0;
    }

    public int getInlineWidth() {
        return this._inlineWidth;
    }

    public void setInlineWidth(int inlineWidth) {
        this._inlineWidth = inlineWidth;
    }

    public boolean isContainsVisibleContent() {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Box b;
            InlineLayoutBox iB;
            InlineText iT;
            Object child = this.getInlineChild(i);
            if (!(child instanceof InlineText ? !(iT = (InlineText)child).isEmpty() : (child instanceof InlineLayoutBox ? (iB = (InlineLayoutBox)child).isContainsVisibleContent() : (b = (Box)child).getWidth() > 0 || b.getHeight() > 0))) continue;
            return true;
        }
        return false;
    }

    public List<TextDecoration> getTextDecorations() {
        return this._textDecorations == null ? Collections.emptyList() : this._textDecorations;
    }

    public void setTextDecorations(List<TextDecoration> textDecoration) {
        this._textDecorations = textDecoration;
    }

    private void addToContentList(List<Box> list) {
        list.add(this);
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object child = this.getInlineChild(i);
            if (child instanceof InlineLayoutBox) {
                ((InlineLayoutBox)child).addToContentList(list);
                continue;
            }
            if (!(child instanceof Box)) continue;
            list.add((Box)child);
        }
    }

    public LineBox getLineBox() {
        return (LineBox)this.findAncestor(bx -> bx instanceof LineBox);
    }

    public List<Box> getElementWithContent() {
        ArrayList<Box> result = new ArrayList<Box>();
        BlockBox container = this.getLineBox().getParent();
        do {
            List<Box> elementBoxes = container.getElementBoxes(this.getElement());
            for (int i = 0; i < elementBoxes.size(); ++i) {
                InlineLayoutBox iB = (InlineLayoutBox)elementBoxes.get(i);
                iB.addToContentList(result);
            }
        } while (container instanceof AnonymousBlockBox && !this.containsEnd(result) && (container = this.addFollowingBlockBoxes(container, result)) != null);
        return result;
    }

    private AnonymousBlockBox addFollowingBlockBoxes(BlockBox container, List<Box> result) {
        int current;
        Box parent = container.getParent();
        for (current = 0; current < parent.getChildCount(); ++current) {
            if (parent.getChild(current) != container) continue;
            ++current;
            break;
        }
        while (current < parent.getChildCount() && !(parent.getChild(current) instanceof AnonymousBlockBox)) {
            result.add(parent.getChild(current));
            ++current;
        }
        return current == parent.getChildCount() ? null : (AnonymousBlockBox)parent.getChild(current);
    }

    private boolean isEndingBox(Box b) {
        if (b instanceof InlineLayoutBox) {
            InlineLayoutBox iB = (InlineLayoutBox)b;
            if (this.getElement() == iB.getElement() && iB.isEndsHere()) {
                return true;
            }
        }
        return false;
    }

    private boolean containsEnd(List<Box> result) {
        return result.stream().anyMatch(this::isEndingBox);
    }

    @Override
    public List<Box> getElementBoxes(Element elem) {
        ArrayList<Box> result = new ArrayList<Box>();
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object child = this.getInlineChild(i);
            if (!(child instanceof Box)) continue;
            Box b = (Box)child;
            if (b.getElement() == elem) {
                result.add(b);
            }
            result.addAll(b.getElementBoxes(elem));
        }
        return result;
    }

    @Override
    public Dimension positionRelative(CssContext cssCtx) {
        Dimension delta = super.positionRelative(cssCtx);
        this.setX(this.getX() - delta.width);
        this.setY(this.getY() - delta.height);
        List<Box> toTranslate = this.getElementWithContent();
        for (int i = 0; i < toTranslate.size(); ++i) {
            Box b = toTranslate.get(i);
            b.setX(b.getX() + delta.width);
            b.setY(b.getY() + delta.height);
            b.calcCanvasLocation();
            b.calcChildLocations();
        }
        return delta;
    }

    public void addAllChildren(List<? super Box> list, Layer layer) {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object child = this.getInlineChild(i);
            if (!(child instanceof Box) || ((Box)child).getContainingLayer() != layer) continue;
            list.add((Box)child);
            if (!(child instanceof InlineLayoutBox)) continue;
            ((InlineLayoutBox)child).addAllChildren(list, layer);
        }
    }

    public void paintDebugOutline(RenderingContext c) {
        c.getOutputDevice().drawDebugOutline(c, this, FSRGBColor.BLUE);
    }

    @Override
    protected void resetChildren(LayoutContext c) {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object object = this.getInlineChild(i);
            if (!(object instanceof Box)) continue;
            ((Box)object).reset(c);
        }
    }

    @Override
    public boolean removeChild(Box child) {
        if (this._inlineChildren != null) {
            return this._inlineChildren.remove(child);
        }
        return false;
    }

    @Override
    public boolean removeChild(int i) {
        if (this._inlineChildren != null) {
            this._inlineChildren.remove(i);
            return true;
        }
        return false;
    }

    @Override
    protected Box getPrevious(Box child) {
        if (this._inlineChildren == null) {
            return null;
        }
        for (int i = 0; i < this._inlineChildren.size() - 1; ++i) {
            Object obj = this._inlineChildren.get(i);
            if (obj != child) continue;
            if (i == 0) {
                return null;
            }
            Object previous = this._inlineChildren.get(i - 1);
            return previous instanceof Box ? (Box)previous : null;
        }
        return null;
    }

    @Override
    protected Box getNext(Box child) {
        if (this._inlineChildren == null) {
            return null;
        }
        for (int i = 0; i < this._inlineChildren.size() - 1; ++i) {
            Object obj = this._inlineChildren.get(i);
            if (obj != child) continue;
            Object next = this._inlineChildren.get(i + 1);
            return next instanceof Box ? (Box)next : null;
        }
        return null;
    }

    @Override
    public void calcCanvasLocation() {
        LineBox lineBox = this.getLineBox();
        this.setAbsX(lineBox.getAbsX() + this.getX());
        this.setAbsY(lineBox.getAbsY() + this.getY());
    }

    @Override
    public void calcChildLocations() {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object obj = this.getInlineChild(i);
            if (!(obj instanceof Box)) continue;
            Box child = (Box)obj;
            child.calcCanvasLocation();
            child.calcChildLocations();
        }
    }

    @Override
    protected void calcChildPaintingInfo(CssContext c, PaintingInfo result, boolean useCache) {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object obj = this.getInlineChild(i);
            if (!(obj instanceof Box)) continue;
            PaintingInfo info = ((Box)obj).calcPaintingInfo(c, useCache);
            this.moveIfGreater(result.getOuterMarginCorner(), info.getOuterMarginCorner());
            result.getAggregateBounds().add(info.getAggregateBounds());
        }
    }

    public void lookForDynamicFunctions(RenderingContext c, boolean evaluateLeaders) {
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object obj = this.getInlineChild(i);
            if (obj instanceof InlineText) {
                InlineText iT = (InlineText)obj;
                if (!iT.isDynamicFunction() || !evaluateLeaders && iT.getFunctionData().getContentFunction() instanceof ContentFunctionFactory.LeaderFunction) continue;
                iT.updateDynamicValue(c);
                continue;
            }
            if (!(obj instanceof InlineLayoutBox)) continue;
            ((InlineLayoutBox)obj).lookForDynamicFunctions(c, evaluateLeaders);
        }
    }

    public InlineText findTrailingText() {
        if (this.getInlineChildCount() == 0) {
            return null;
        }
        InlineText result = null;
        for (int offset = this.getInlineChildCount() - 1; offset >= 0; --offset) {
            Object child = this.getInlineChild(offset);
            if (child instanceof InlineText) {
                result = (InlineText)child;
                if (result.isEmpty()) continue;
                return result;
            }
            if (child instanceof InlineLayoutBox) {
                result = ((InlineLayoutBox)child).findTrailingText();
                if (result != null && result.isEmpty()) continue;
                return result;
            }
            return null;
        }
        return result;
    }

    public void calculateTextDecoration(LayoutContext c) {
        List<TextDecoration> decorations = InlineBoxing.calculateTextDecorations(this, this.getBaseline(), this.getStyle().getFSFontMetrics(c));
        this.setTextDecorations(decorations);
    }

    @Override
    public Box find(CssContext cssCtx, int absX, int absY, boolean findAnonymous) {
        PaintingInfo pI = this.getPaintingInfo();
        if (pI != null && !pI.getAggregateBounds().contains(absX, absY)) {
            return null;
        }
        Box result = null;
        for (int i = 0; i < this.getInlineChildCount(); ++i) {
            Object child = this.getInlineChild(i);
            if (!(child instanceof Box) || (result = ((Box)child).find(cssCtx, absX, absY, findAnonymous)) == null) continue;
            return result;
        }
        Rectangle edge = this.getContentAreaEdge(this.getAbsX(), this.getAbsY(), cssCtx);
        Box box = result = edge.contains(absX, absY) && this.getStyle().isVisible(null, this) ? this : null;
        if (!findAnonymous && result != null && this.getElement() == null) {
            return this.getParent().getParent();
        }
        return result;
    }

    @Override
    public int getContainingBlockWidth() {
        return this._containingBlockWidth;
    }

    public void setContainingBlockWidth(int containingBlockWidth) {
        this._containingBlockWidth = containingBlockWidth;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("InlineLayoutBox: ");
        if (this.getElement() != null) {
            result.append("<");
            result.append(this.getElement().getNodeName());
            result.append("> ");
        } else {
            result.append("(anonymous) ");
        }
        if (this.isStartsHere() || this.isEndsHere()) {
            result.append("(");
            if (this.isStartsHere()) {
                result.append("S");
            }
            if (this.isEndsHere()) {
                result.append("E");
            }
            result.append(") ");
        }
        result.append("(baseline=");
        result.append(this._baseline);
        result.append(") ");
        result.append("(" + this.getAbsX() + "," + this.getAbsY() + ")->(" + this.getInlineWidth() + " x " + this.getHeight() + ")");
        return result.toString();
    }

    @Override
    public String dump(LayoutContext c, String indent, int which) {
        if (which != 2) {
            throw new IllegalArgumentException();
        }
        StringBuilder result = new StringBuilder(indent);
        result.append(this);
        result.append('\n');
        Iterator<Object> i = this.getInlineChildren().iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof Box) {
                Box b = (Box)obj;
                result.append(b.dump(c, indent + "  ", which));
                if (result.charAt(result.length() - 1) == '\n') {
                    result.deleteCharAt(result.length() - 1);
                }
            } else {
                result.append(indent + "  ");
                result.append(obj.toString());
            }
            if (!i.hasNext()) continue;
            result.append('\n');
        }
        return result.toString();
    }

    @Override
    public void collectText(RenderingContext c, StringBuilder buffer) {
        for (Object obj : this.getInlineChildren()) {
            if (obj instanceof InlineText) {
                buffer.append(((InlineText)obj).getTextExportText());
                continue;
            }
            ((Box)obj).collectText(c, buffer);
        }
    }

    public void countJustifiableChars(CharCounts counts) {
        boolean justifyThis = this.getStyle().isTextJustify();
        for (Object o : this.getInlineChildren()) {
            if (o instanceof InlineLayoutBox) {
                ((InlineLayoutBox)o).countJustifiableChars(counts);
                continue;
            }
            if (!(o instanceof InlineText) || !justifyThis) continue;
            ((InlineText)o).countJustifiableChars(counts);
        }
    }

    public float adjustHorizontalPosition(JustificationInfo info, float adjust) {
        float runningTotal = adjust;
        float result = 0.0f;
        for (Object o : this.getInlineChildren()) {
            float adj;
            if (o instanceof InlineText) {
                InlineText iT = (InlineText)o;
                iT.setX(iT.getX() + Math.round(result));
                adj = iT.calcTotalAdjustment(info);
                iT.setWidth((int)((float)iT.getWidth() + adj));
                result += adj;
                runningTotal += adj;
                continue;
            }
            Box b = (Box)o;
            b.setX(b.getX() + Math.round(runningTotal));
            if (!(b instanceof InlineLayoutBox)) continue;
            adj = ((InlineLayoutBox)b).adjustHorizontalPosition(info, runningTotal);
            result += adj;
            runningTotal += adj;
        }
        this.setInlineWidth((int)((float)this.getInlineWidth() + result));
        return result;
    }

    public float adjustHorizontalPositionRTL(JustificationInfo info, float adjust) {
        float runningTotal = adjust;
        float result = 0.0f;
        for (Object o : this.getInlineChildren()) {
            float adj;
            if (o instanceof InlineText) {
                InlineText iT = (InlineText)o;
                adj = iT.calcTotalAdjustment(info);
                iT.setWidth((int)((float)iT.getWidth() + adj));
                runningTotal += adj;
                iT.setX(iT.getX() - Math.round(result += adj));
                continue;
            }
            Box b = (Box)o;
            if (b instanceof InlineLayoutBox) {
                adj = ((InlineLayoutBox)b).adjustHorizontalPositionRTL(info, runningTotal);
                result += adj;
                runningTotal += adj;
            }
            b.setX(b.getX() - Math.round(runningTotal));
        }
        this.setInlineWidth((int)((float)this.getInlineWidth() + result));
        return result;
    }

    @Override
    public int getEffectiveWidth() {
        return this.getInlineWidth();
    }
}

