/*
 * Decompiled with CFR 0.152.
 */
package feign.form.multipart;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import feign.codec.EncodeException;
import feign.form.multipart.AbstractWriter;
import feign.form.multipart.Output;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleFileWriter
extends AbstractWriter {
    @SuppressFBWarnings(justification="generated code")
    private static final Logger log = LoggerFactory.getLogger(SingleFileWriter.class);

    @Override
    public boolean isApplicable(Object value) {
        return value instanceof File;
    }

    @Override
    protected void write(Output output, String key, Object value) throws EncodeException {
        File file = (File)value;
        this.writeFileMetadata(output, key, file.getName(), null);
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            byte[] buf = new byte[1024];
            int length = ((InputStream)input).read(buf);
            while (length > 0) {
                output.write(buf, 0, length);
                length = ((InputStream)input).read(buf);
            }
        }
        catch (IOException ex) {
            String message = String.format("Writing file's '%s' content error", file.getName());
            throw new EncodeException(message, (Throwable)ex);
        }
        finally {
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException ex) {
                    log.error("Closing file '{}' error", (Object)file.getName(), (Object)ex);
                }
            }
        }
    }
}

