/*
 * Decompiled with CFR 0.152.
 */
package feign.form;

import feign.Request;
import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.form.ContentProcessor;
import feign.form.ContentType;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;

public class UrlencodedFormContentProcessor
implements ContentProcessor {
    @Override
    public void process(RequestTemplate template, Charset charset, Map<String, Object> data) throws EncodeException {
        StringBuilder bodyData = new StringBuilder();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (bodyData.length() > 0) {
                bodyData.append('&');
            }
            bodyData.append(this.createKeyValuePair(entry, charset));
        }
        String contentTypeValue = this.getSupportedContentType().getHeader() + "; charset=" + charset.name();
        byte[] bytes = bodyData.toString().getBytes(charset);
        Request.Body body = Request.Body.encoded((byte[])bytes, (Charset)charset);
        template.header("Content-Type", Collections.emptyList());
        template.header("Content-Type", new String[]{contentTypeValue});
        template.body(body);
    }

    @Override
    public ContentType getSupportedContentType() {
        return ContentType.URLENCODED;
    }

    private String createKeyValuePair(Map.Entry<String, Object> entry, Charset charset) {
        return URLEncoder.encode(entry.getKey(), charset.name()) + '=' + URLEncoder.encode(entry.getValue().toString(), charset.name());
    }
}

