/*
 * Decompiled with CFR 0.152.
 */
package com.wang.avi.indicators;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.view.animation.LinearInterpolator;
import com.wang.avi.Indicator;
import java.util.ArrayList;

public class BallTrianglePathIndicator
extends Indicator {
    float[] translateX = new float[3];
    float[] translateY = new float[3];

    @Override
    public void draw(Canvas canvas, Paint paint) {
        paint.setStrokeWidth(3.0f);
        paint.setStyle(Paint.Style.STROKE);
        for (int i = 0; i < 3; ++i) {
            canvas.save();
            canvas.translate(this.translateX[i], this.translateY[i]);
            canvas.drawCircle(0.0f, 0.0f, (float)(this.getWidth() / 10), paint);
            canvas.restore();
        }
    }

    @Override
    public ArrayList<ValueAnimator> onCreateAnimators() {
        ArrayList<ValueAnimator> animators = new ArrayList<ValueAnimator>();
        float startX = this.getWidth() / 5;
        float startY = this.getWidth() / 5;
        for (int i = 0; i < 3; ++i) {
            final int index = i;
            ValueAnimator translateXAnim = ValueAnimator.ofFloat((float[])new float[]{this.getWidth() / 2, (float)this.getWidth() - startX, startX, this.getWidth() / 2});
            if (i == 1) {
                translateXAnim = ValueAnimator.ofFloat((float[])new float[]{(float)this.getWidth() - startX, startX, this.getWidth() / 2, (float)this.getWidth() - startX});
            } else if (i == 2) {
                translateXAnim = ValueAnimator.ofFloat((float[])new float[]{startX, this.getWidth() / 2, (float)this.getWidth() - startX, startX});
            }
            ValueAnimator translateYAnim = ValueAnimator.ofFloat((float[])new float[]{startY, (float)this.getHeight() - startY, (float)this.getHeight() - startY, startY});
            if (i == 1) {
                translateYAnim = ValueAnimator.ofFloat((float[])new float[]{(float)this.getHeight() - startY, (float)this.getHeight() - startY, startY, (float)this.getHeight() - startY});
            } else if (i == 2) {
                translateYAnim = ValueAnimator.ofFloat((float[])new float[]{(float)this.getHeight() - startY, startY, (float)this.getHeight() - startY, (float)this.getHeight() - startY});
            }
            translateXAnim.setDuration(2000L);
            translateXAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            translateXAnim.setRepeatCount(-1);
            this.addUpdateListener(translateXAnim, new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallTrianglePathIndicator.this.translateX[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallTrianglePathIndicator.this.postInvalidate();
                }
            });
            translateYAnim.setDuration(2000L);
            translateYAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            translateYAnim.setRepeatCount(-1);
            this.addUpdateListener(translateYAnim, new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    BallTrianglePathIndicator.this.translateY[index] = ((Float)animation.getAnimatedValue()).floatValue();
                    BallTrianglePathIndicator.this.postInvalidate();
                }
            });
            animators.add(translateXAnim);
            animators.add(translateYAnim);
        }
        return animators;
    }
}

