/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.FromServer;
import groovyx.net.http.HttpBuilder;
import groovyx.net.http.HttpConfig;
import groovyx.net.http.HttpConfigs;
import groovyx.net.http.HttpObjectConfig;
import groovyx.net.http.ProxyInfo;
import groovyx.net.http.ToServer;
import groovyx.net.http.util.IoUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaHttpBuilder
extends HttpBuilder {
    private static final Logger log = LoggerFactory.getLogger(JavaHttpBuilder.class);
    private static final Logger contentLog = LoggerFactory.getLogger((String)"groovy.net.http.JavaHttpBuilder.content");
    private static final Logger headerLog = LoggerFactory.getLogger((String)"groovy.net.http.JavaHttpBuilder.headers");
    private final ChainedHttpConfig config;
    private final Executor executor;
    private final SSLContext sslContext;
    private final ProxyInfo proxyInfo;
    private final HostnameVerifier hostnameVerifier;
    private final HttpObjectConfig.Client clientConfig;

    protected JavaHttpBuilder(HttpObjectConfig config) {
        super(config);
        this.config = new HttpConfigs.ThreadSafeHttpConfig(config.getChainedConfig());
        this.executor = config.getExecution().getExecutor();
        this.clientConfig = config.getClient();
        this.hostnameVerifier = config.getExecution().getHostnameVerifier();
        this.sslContext = config.getExecution().getSslContext();
        this.proxyInfo = config.getExecution().getProxyInfo();
    }

    @Override
    public Object getClientImplementation() {
        throw new UnsupportedOperationException("The core Java implementation does not support direct client access.");
    }

    @Override
    protected ChainedHttpConfig getObjectConfig() {
        return this.config;
    }

    private Object createAndExecute(ChainedHttpConfig config, String verb) {
        try {
            Action action = new Action(this.clientConfig.getClientCustomizer(), config, verb);
            return action.execute();
        }
        catch (Exception e) {
            return this.handleException(config.getChainedResponse(), e);
        }
    }

    @Override
    protected Object doGet(ChainedHttpConfig requestConfig) {
        return this.createAndExecute(requestConfig, "GET");
    }

    @Override
    protected Object doHead(ChainedHttpConfig requestConfig) {
        return this.createAndExecute(requestConfig, "HEAD");
    }

    @Override
    protected Object doPost(ChainedHttpConfig requestConfig) {
        return this.createAndExecute(requestConfig, "POST");
    }

    @Override
    protected Object doPut(ChainedHttpConfig requestConfig) {
        return this.createAndExecute(requestConfig, "PUT");
    }

    @Override
    protected Object doDelete(ChainedHttpConfig requestConfig) {
        return this.createAndExecute(requestConfig, "DELETE");
    }

    @Override
    protected Object doPatch(ChainedHttpConfig requestConfig) {
        throw new UnsupportedOperationException("java.net.HttpURLConnection does not support the PATCH method. Use the Apache or OkHttp providers instead.");
    }

    @Override
    protected Object doOptions(ChainedHttpConfig config) {
        return this.createAndExecute(config, "OPTIONS");
    }

    @Override
    protected Object doTrace(ChainedHttpConfig config) {
        return this.createAndExecute(config, "TRACE");
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void close() {
    }

    static {
        Authenticator.setDefault(new ThreadLocalAuth());
    }

    protected static class ThreadLocalAuth
    extends Authenticator {
        private static final ThreadLocal<PasswordAuthentication> tlAuth = new ThreadLocal();

        protected ThreadLocalAuth() {
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            return tlAuth.get();
        }

        public static final <V> V with(PasswordAuthentication pa, Callable<V> callable) throws Exception {
            tlAuth.set(pa);
            try {
                V v = callable.call();
                return v;
            }
            finally {
                tlAuth.set(null);
            }
        }
    }

    protected class Action {
        private final HttpURLConnection connection;
        private final ChainedHttpConfig requestConfig;
        private final URI theUri;

        private boolean isProxied() {
            return JavaHttpBuilder.this.proxyInfo != null && JavaHttpBuilder.this.proxyInfo.getProxy().type() != Proxy.Type.DIRECT;
        }

        public Action(Consumer<Object> clientCustomizer, ChainedHttpConfig requestConfig, String verb) throws IOException, URISyntaxException {
            this.requestConfig = requestConfig;
            ChainedHttpConfig.ChainedRequest cr = requestConfig.getChainedRequest();
            this.theUri = cr.getUri().toURI();
            URL url = this.theUri.toURL();
            this.connection = (HttpURLConnection)(this.isProxied() ? url.openConnection(JavaHttpBuilder.this.proxyInfo.getProxy()) : url.openConnection());
            this.connection.setRequestMethod(verb);
            if (cr.actualBody() != null) {
                this.connection.setDoOutput(true);
            }
            if (clientCustomizer != null) {
                clientCustomizer.accept(this.connection);
            }
        }

        private void addHeaders() throws URISyntaxException {
            ChainedHttpConfig.ChainedRequest cr = this.requestConfig.getChainedRequest();
            for (Map.Entry<String, CharSequence> entry : cr.actualHeaders(new LinkedHashMap<String, CharSequence>()).entrySet()) {
                this.connection.addRequestProperty(entry.getKey(), entry.getValue() != null ? entry.getValue().toString() : null);
            }
            String contentType = cr.actualContentType();
            if (contentType != null) {
                Charset charset = cr.actualCharset();
                if (charset != null) {
                    this.connection.addRequestProperty("Content-Type", contentType + "; charset=" + charset.toString().toLowerCase());
                } else {
                    this.connection.addRequestProperty("Content-Type", contentType);
                }
            }
            this.connection.addRequestProperty("Accept-Encoding", "gzip, deflate");
            for (Map.Entry<String, String> e : JavaHttpBuilder.this.cookiesToAdd(JavaHttpBuilder.this.clientConfig, cr).entrySet()) {
                this.connection.addRequestProperty(e.getKey(), e.getValue());
            }
            if (headerLog.isDebugEnabled()) {
                this.connection.getRequestProperties().forEach((name, values) -> headerLog.debug("Request-Header: {} -> {}", name, values));
            }
        }

        private PasswordAuthentication getAuthInfo() {
            HttpConfig.Auth auth = this.requestConfig.getChainedRequest().actualAuth();
            if (auth == null) {
                return null;
            }
            if (auth.getAuthType() == HttpConfig.AuthType.BASIC || auth.getAuthType() == HttpConfig.AuthType.DIGEST) {
                return new PasswordAuthentication(auth.getUser(), auth.getPassword().toCharArray());
            }
            throw new UnsupportedOperationException("HttpURLConnection does not support " + (Object)((Object)auth.getAuthType()) + " authentication");
        }

        public Object execute() throws Exception {
            return ThreadLocalAuth.with(this.getAuthInfo(), () -> {
                if (JavaHttpBuilder.this.sslContext != null && this.connection instanceof HttpsURLConnection) {
                    HttpsURLConnection https = (HttpsURLConnection)this.connection;
                    if (JavaHttpBuilder.this.hostnameVerifier != null) {
                        https.setHostnameVerifier(JavaHttpBuilder.this.hostnameVerifier);
                    }
                    https.setSSLSocketFactory(JavaHttpBuilder.this.sslContext.getSocketFactory());
                }
                ChainedHttpConfig.ChainedRequest cr = this.requestConfig.getChainedRequest();
                JavaToServer j2s = null;
                if (cr.actualBody() != null) {
                    j2s = new JavaToServer();
                    this.requestConfig.findEncoder().accept(this.requestConfig, j2s);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Request-URI({}): {}", (Object)this.connection.getRequestMethod(), (Object)this.theUri);
                }
                this.addHeaders();
                this.connection.connect();
                if (j2s != null) {
                    if (contentLog.isDebugEnabled()) {
                        contentLog.debug("Request-Body({}): {}", (Object)this.requestConfig.getChainedRequest().actualContentType(), (Object)j2s.content());
                    }
                    j2s.transfer();
                }
                JavaFromServer fromServer = new JavaFromServer(this.theUri);
                if (contentLog.isDebugEnabled()) {
                    contentLog.debug("Response-Body: {}", (Object)fromServer.content());
                }
                if (headerLog.isDebugEnabled()) {
                    fromServer.getHeaders().forEach(header -> headerLog.debug("Response-Header: {} -> {}", (Object)header.getKey(), (Object)header.getValue()));
                }
                return HttpBuilder.ResponseHandlerFunction.HANDLER_FUNCTION.apply(this.requestConfig, fromServer);
            });
        }

        protected class JavaFromServer
        implements FromServer {
            private final BufferedInputStream is;
            private final List<FromServer.Header<?>> headers;
            private final URI uri;
            private final int statusCode;
            private final String message;

            public JavaFromServer(URI originalUri) throws IOException {
                this.uri = originalUri;
                this.headers = this.populateHeaders();
                JavaHttpBuilder.this.addCookieStore(this.uri, this.headers);
                this.statusCode = Action.this.connection.getResponseCode();
                this.message = Action.this.connection.getResponseMessage();
                BufferedInputStream bis = this.buffered(this.correctInputStream());
                this.is = bis == null ? null : this.handleEncoding(bis);
            }

            String content() {
                try {
                    return IoUtils.copyAsString(this.is);
                }
                catch (IOException ioe) {
                    log.warn("Unable to render response stream due to error (may not affect actual content)", (Throwable)ioe);
                }
                catch (IllegalStateException ise) {
                    log.error("Unable to reset response stream - actual content may be corrupted (consider disabling content logging)", (Throwable)ise);
                }
                return "<no-information>";
            }

            private BufferedInputStream buffered(InputStream is) throws IOException {
                if (is == null) {
                    return null;
                }
                BufferedInputStream bis = new BufferedInputStream(is);
                bis.mark(0);
                if (bis.read() == -1) {
                    return null;
                }
                bis.reset();
                return bis;
            }

            private InputStream correctInputStream() throws IOException {
                if (this.getStatusCode() < 400) {
                    return Action.this.connection.getInputStream();
                }
                return Action.this.connection.getErrorStream();
            }

            private BufferedInputStream handleEncoding(BufferedInputStream is) throws IOException {
                FromServer.Header<?> encodingHeader = FromServer.Header.find(this.headers, "Content-Encoding");
                if (encodingHeader != null) {
                    if (encodingHeader.getValue().equals("gzip")) {
                        return new BufferedInputStream(new GZIPInputStream(is));
                    }
                    if (encodingHeader.getValue().equals("deflate")) {
                        return new BufferedInputStream(new InflaterInputStream(is));
                    }
                }
                return is;
            }

            private String clean(String str) {
                if (str == null) {
                    return null;
                }
                String tmp = str.trim();
                return "".equals(tmp) ? null : tmp;
            }

            private List<FromServer.Header<?>> populateHeaders() {
                ArrayList ret = new ArrayList();
                for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                    String key = this.clean(Action.this.connection.getHeaderFieldKey(i));
                    String value = this.clean(Action.this.connection.getHeaderField(i));
                    if (key == null && value == null) break;
                    if (key == null || value == null) continue;
                    ret.add(FromServer.Header.keyValue(key.trim(), value.trim()));
                }
                return Collections.unmodifiableList(ret);
            }

            @Override
            public InputStream getInputStream() {
                return this.is;
            }

            @Override
            public final int getStatusCode() {
                return this.statusCode;
            }

            @Override
            public String getMessage() {
                return this.message;
            }

            @Override
            public List<FromServer.Header<?>> getHeaders() {
                return this.headers;
            }

            @Override
            public boolean getHasBody() {
                return this.is != null;
            }

            @Override
            public URI getUri() {
                return this.uri;
            }

            @Override
            public void finish() {
            }
        }

        protected class JavaToServer
        implements ToServer {
            private BufferedInputStream inputStream;

            protected JavaToServer() {
            }

            @Override
            public void toServer(InputStream inputStream) {
                this.inputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
            }

            void transfer() throws IOException {
                IoUtils.transfer(this.inputStream, Action.this.connection.getOutputStream(), true);
            }

            public String content() {
                block4: {
                    try {
                        return IoUtils.copyAsString(this.inputStream);
                    }
                    catch (IOException ioe) {
                        if (log.isWarnEnabled()) {
                            log.warn("Unable to render request stream due to error (may not affect actual content)", (Throwable)ioe);
                        }
                    }
                    catch (IllegalStateException ise) {
                        if (!log.isErrorEnabled()) break block4;
                        log.error("Unable to reset request stream - actual content may be corrupted (consider disabling content logging)", (Throwable)ise);
                    }
                }
                return "<no-information>";
            }
        }
    }
}

