/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.ChainedHttpConfig;
import groovyx.net.http.HttpConfig;
import groovyx.net.http.HttpConfigs;
import groovyx.net.http.HttpObjectConfig;
import groovyx.net.http.HttpVerb;
import groovyx.net.http.ProxyInfo;
import groovyx.net.http.util.Misc;
import groovyx.net.http.util.SslUtils;
import java.io.File;
import java.net.Proxy;
import java.net.UnknownHostException;
import java.util.EnumMap;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public class HttpObjectConfigImpl
implements HttpObjectConfig {
    private final ChainedHttpConfig config = HttpConfigs.basic(HttpConfigs.root());
    final Exec exec = new Exec();
    final ClientConfig clientConfig = new ClientConfig();

    @Override
    public ChainedHttpConfig getChainedConfig() {
        return this.config;
    }

    public static Object nullInterceptor(ChainedHttpConfig config, Function<ChainedHttpConfig, Object> func) {
        return func.apply(config);
    }

    @Override
    public HttpConfig.Request getRequest() {
        return this.config.getRequest();
    }

    @Override
    public HttpConfig.Response getResponse() {
        return this.config.getResponse();
    }

    public HttpConfig getParent() {
        return this.config.getParent();
    }

    @Override
    public HttpObjectConfig.Execution getExecution() {
        return this.exec;
    }

    @Override
    public HttpObjectConfig.Client getClient() {
        return this.clientConfig;
    }

    @Override
    public void context(String contentType, Object id, Object obj) {
        this.config.context(contentType, id, obj);
    }

    private static class SingleThreaded
    implements Executor {
        public static final SingleThreaded instance = new SingleThreaded();

        private SingleThreaded() {
        }

        @Override
        public void execute(Runnable r) {
            r.run();
        }
    }

    private static class ClientConfig
    implements HttpObjectConfig.Client {
        private boolean cookiesEnabled = true;
        private int cookieVersion = 0;
        private File cookieFolder;
        private Consumer<Object> clientCustomizer;

        private ClientConfig() {
        }

        @Override
        public void setCookieVersion(int version) {
            this.cookieVersion = version;
        }

        @Override
        public int getCookieVersion() {
            return this.cookieVersion;
        }

        @Override
        public File getCookieFolder() {
            return this.cookieFolder;
        }

        @Override
        public void setCookieFolder(File val) {
            this.cookieFolder = val;
        }

        @Override
        public boolean getCookiesEnabled() {
            return this.cookiesEnabled;
        }

        @Override
        public void setCookiesEnabled(boolean val) {
            this.cookiesEnabled = val;
        }

        @Override
        public void clientCustomizer(Consumer<Object> customizer) {
            this.clientCustomizer = customizer;
        }

        @Override
        public Consumer<Object> getClientCustomizer() {
            return this.clientCustomizer;
        }
    }

    private static class Exec
    implements HttpObjectConfig.Execution {
        private int maxThreads = 1;
        private Executor executor = SingleThreaded.instance;
        private SSLContext sslContext;
        private HostnameVerifier hostnameVerifier;
        private final EnumMap<HttpVerb, BiFunction<ChainedHttpConfig, Function<ChainedHttpConfig, Object>, Object>> interceptors = new EnumMap(HttpVerb.class);
        private ProxyInfo proxyInfo;

        public Exec() {
            for (HttpVerb verb : HttpVerb.values()) {
                this.interceptors.put(verb, HttpObjectConfigImpl::nullInterceptor);
            }
            if (Misc.isPropertySet("groovyx.net.http.ignore-ssl-issues")) {
                this.setSslContext(SslUtils.acceptingSslContext());
                this.setHostnameVerifier(SslUtils.ANY_HOSTNAME);
            }
        }

        @Override
        public void setMaxThreads(int val) {
            if (val < 1) {
                throw new IllegalArgumentException("Max Threads cannot be less than 1");
            }
            this.maxThreads = val;
        }

        @Override
        public int getMaxThreads() {
            return this.maxThreads;
        }

        @Override
        public void setExecutor(Executor val) {
            if (val == null) {
                throw new NullPointerException();
            }
            this.executor = val;
        }

        @Override
        public Executor getExecutor() {
            return this.executor;
        }

        @Override
        public void setSslContext(SSLContext val) {
            this.sslContext = val;
        }

        @Override
        public SSLContext getSslContext() {
            return this.sslContext;
        }

        @Override
        public void setHostnameVerifier(HostnameVerifier verifier) {
            this.hostnameVerifier = verifier;
        }

        @Override
        public HostnameVerifier getHostnameVerifier() {
            return this.hostnameVerifier;
        }

        @Override
        public void interceptor(HttpVerb verb, BiFunction<ChainedHttpConfig, Function<ChainedHttpConfig, Object>, Object> func) {
            if (func == null) {
                throw new NullPointerException("func cannot be null");
            }
            this.interceptors.put(verb, func);
        }

        @Override
        public void interceptor(HttpVerb[] verbs, BiFunction<ChainedHttpConfig, Function<ChainedHttpConfig, Object>, Object> func) {
            for (HttpVerb verb : verbs) {
                this.interceptors.put(verb, func);
            }
        }

        @Override
        public EnumMap<HttpVerb, BiFunction<ChainedHttpConfig, Function<ChainedHttpConfig, Object>, Object>> getInterceptors() {
            return this.interceptors;
        }

        @Override
        public ProxyInfo getProxyInfo() {
            return this.proxyInfo;
        }

        @Override
        public void proxy(Proxy proxy, boolean secure) {
            this.proxyInfo = new ProxyInfo(proxy, secure);
        }

        @Override
        public void proxy(String host, int port, Proxy.Type type, boolean secure) throws UnknownHostException {
            this.proxyInfo = new ProxyInfo(host, port, type, secure);
        }
    }
}

