/*
 * Decompiled with CFR 0.152.
 */
package groovyx.net.http;

import groovyx.net.http.TransportingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Form {
    private static ThreadLocal<Buffers> tlBuffers = new ThreadLocal<Buffers>(){

        @Override
        protected Buffers initialValue() {
            return new Buffers();
        }
    };

    private static void toBuffers(InputStream is, Charset charset) throws IOException {
        tlBuffers.get().clear();
        InputStreamReader reader = new InputStreamReader(is, charset);
        StringBuilder builder = Form.tlBuffers.get().builder;
        char[] buffer = Form.tlBuffers.get().buffer;
        int total = 0;
        while ((total = ((Reader)reader).read(buffer, 0, 1024)) != -1) {
            builder.append(buffer, 0, total);
        }
    }

    public static Map<String, List<String>> decode(InputStream is, Charset charset) {
        try {
            Form.toBuffers(is, charset);
            return Form.decode(Form.tlBuffers.get().builder, charset);
        }
        catch (IOException e) {
            throw new TransportingException("Error in decoding form", e);
        }
    }

    public static Map<String, List<String>> decode(StringBuilder builder, Charset charset) throws IOException {
        LinkedHashMap<String, List<String>> ret = new LinkedHashMap<String, List<String>>();
        int lower = 0;
        while (lower < builder.length()) {
            int ampAt;
            int eqAt = builder.indexOf("=", lower);
            if (eqAt == -1) {
                eqAt = builder.length();
            }
            if ((ampAt = builder.indexOf("&", eqAt)) == -1) {
                ampAt = builder.length();
            }
            String key = URLDecoder.decode(builder.substring(lower, eqAt), charset.toString());
            String value = eqAt == ampAt ? null : URLDecoder.decode(builder.substring(eqAt + 1, ampAt), charset.toString());
            ArrayList<String> values = (ArrayList<String>)ret.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                ret.put(key, values);
            }
            if (ampAt - eqAt > 1) {
                values.add(value);
            }
            lower = ampAt + 1;
        }
        return ret;
    }

    public static List<?> checkValue(Object v) {
        if (v instanceof List) {
            List list = (List)v;
            if (list.size() > 0) {
                return list;
            }
            return Collections.singletonList("");
        }
        if (v != null) {
            return Collections.singletonList(v);
        }
        return Collections.singletonList("");
    }

    public static String encode(Map<?, ?> map, Charset charset) {
        try {
            tlBuffers.get().clear();
            StringBuilder builder = Form.tlBuffers.get().builder;
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                for (Object value : Form.checkValue(entry.getValue())) {
                    builder.append(URLEncoder.encode(entry.getKey().toString(), charset.toString())).append("=");
                    builder.append(URLEncoder.encode(value.toString(), charset.toString())).append("&");
                }
            }
            return builder.substring(0, builder.length() - 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new TransportingException("Error in encoding form", e);
        }
    }

    private static class Buffers {
        final StringBuilder builder = new StringBuilder(1024);
        final char[] buffer = new char[1024];

        private Buffers() {
        }

        public void clear() {
            this.builder.setLength(0);
        }
    }
}

