/*
 * Decompiled with CFR 0.152.
 */
package io.github.gradlenexus.publishplugin;

import io.github.gradlenexus.publishplugin.AbstractNexusStagingRepositoryTask;
import io.github.gradlenexus.publishplugin.NexusRepository;
import io.github.gradlenexus.publishplugin.internal.DetermineStagingProfileIdKt;
import io.github.gradlenexus.publishplugin.internal.NexusClient;
import io.github.gradlenexus.publishplugin.internal.StagingRepositoryDescriptor;
import io.github.gradlenexus.publishplugin.internal.StagingRepositoryDescriptorRegistryBuildService;
import io.github.gradlenexus.publishplugin.shadow.kotlin.Metadata;
import io.github.gradlenexus.publishplugin.shadow.kotlin.jvm.internal.Intrinsics;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.HttpUrl;
import io.github.gradlenexus.publishplugin.shadow.org.jetbrains.annotations.NotNull;
import java.net.URI;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\r"}, d2={"Lio/github/gradlenexus/publishplugin/InitializeNexusStagingRepository;", "Lio/github/gradlenexus/publishplugin/AbstractNexusStagingRepositoryTask;", "()V", "packageGroup", "Lorg/gradle/api/provider/Property;", "", "getPackageGroup", "()Lorg/gradle/api/provider/Property;", "registry", "Lio/github/gradlenexus/publishplugin/internal/StagingRepositoryDescriptorRegistryBuildService;", "getRegistry", "createStagingRepo", "", "publish-plugin"})
public abstract class InitializeNexusStagingRepository
extends AbstractNexusStagingRepositoryTask {
    @Internal
    @NotNull
    public abstract Property<StagingRepositoryDescriptorRegistryBuildService> getRegistry();

    @Optional
    @Input
    @NotNull
    public abstract Property<String> getPackageGroup();

    @TaskAction
    public final void createStagingRepo() {
        NexusRepository repository = (NexusRepository)this.getRepository().get();
        URI serverUrl = (URI)repository.getNexusUrl().get();
        NexusClient client = this.createNexusClient();
        Logger logger = this.getLogger();
        Intrinsics.checkExpressionValueIsNotNull(logger, "logger");
        NexusRepository nexusRepository = repository;
        Intrinsics.checkExpressionValueIsNotNull(nexusRepository, "repository");
        Object object = this.getPackageGroup().get();
        Intrinsics.checkExpressionValueIsNotNull(object, "packageGroup.get()");
        String stagingProfileId = DetermineStagingProfileIdKt.determineStagingProfileId(client, logger, nexusRepository, (String)object);
        this.getLogger().info("Creating staging repository for {} at {}, stagingProfileId '{}'", new Object[]{repository.getName(), serverUrl, stagingProfileId});
        Object object2 = this.getRepositoryDescription().get();
        Intrinsics.checkExpressionValueIsNotNull(object2, "repositoryDescription.get()");
        StagingRepositoryDescriptor descriptor = client.createStagingRepository(stagingProfileId, (String)object2);
        HttpUrl httpUrl = HttpUrl.get(serverUrl);
        if (httpUrl == null) {
            Intrinsics.throwNpe();
        }
        HttpUrl consumerUrl = httpUrl.newBuilder().addEncodedPathSegments("repositories/" + descriptor.getStagingRepositoryId() + "/content/").build();
        this.getLogger().lifecycle("Created staging repository '{}' at {}", new Object[]{descriptor.getStagingRepositoryId(), consumerUrl});
        ((StagingRepositoryDescriptorRegistryBuildService)this.getRegistry().get()).getRegistry().set(repository.getName(), descriptor);
    }
}

