/*
 * Decompiled with CFR 0.152.
 */
package io.github.gradlenexus.publishplugin.shadow.retrofit2.converter.gson;

import io.github.gradlenexus.publishplugin.shadow.com.google.gson.Gson;
import io.github.gradlenexus.publishplugin.shadow.com.google.gson.JsonIOException;
import io.github.gradlenexus.publishplugin.shadow.com.google.gson.TypeAdapter;
import io.github.gradlenexus.publishplugin.shadow.com.google.gson.stream.JsonReader;
import io.github.gradlenexus.publishplugin.shadow.com.google.gson.stream.JsonToken;
import io.github.gradlenexus.publishplugin.shadow.okhttp3.ResponseBody;
import io.github.gradlenexus.publishplugin.shadow.retrofit2.Converter;
import java.io.IOException;

final class GsonResponseBodyConverter<T>
implements Converter<ResponseBody, T> {
    private final Gson gson;
    private final TypeAdapter<T> adapter;

    GsonResponseBodyConverter(Gson gson, TypeAdapter<T> adapter) {
        this.gson = gson;
        this.adapter = adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T convert(ResponseBody value) throws IOException {
        JsonReader jsonReader = this.gson.newJsonReader(value.charStream());
        try {
            T result = this.adapter.read(jsonReader);
            if (jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonIOException("JSON document was not fully consumed.");
            }
            T t = result;
            return t;
        }
        finally {
            value.close();
        }
    }
}

