/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.HttpConfiguration;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory$;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.DelegatingSslContext;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005s!B\u0001\u0003\u0011\u0003Y\u0011AE*tY\u000e{g\u000e^3yiN4\u0015m\u0019;pefT!a\u0001\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000b\u0019\tA\u0001\u001b;ua*\u0011q\u0001C\u0001\bO\u0006$H.\u001b8h\u0015\u0005I\u0011AA5p\u0007\u0001\u0001\"\u0001D\u0007\u000e\u0003\t1QA\u0004\u0002\t\u0002=\u0011!cU:m\u0007>tG/\u001a=ug\u001a\u000b7\r^8ssN\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005Y\u0001b\u0002\u000e\u000e\u0005\u0004%IaG\u0001\u0017\t\u00164\u0017-\u001e7u'Nd7+Z2ve\u0016\u0014\u0016M\u001c3p[V\tA\u0004\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005A1/Z2ve&$\u0018PC\u0001\"\u0003\u0011Q\u0017M^1\n\u0005\rr\"\u0001D*fGV\u0014XMU1oI>l\u0007BB\u0013\u000eA\u0003%A$A\fEK\u001a\fW\u000f\u001c;Tg2\u001cVmY;sKJ\u000bg\u000eZ8nA!9q%\u0004b\u0001\n\u0013A\u0013\u0001\u0006#fM\u0006,H\u000e\u001e+skN$X*\u00198bO\u0016\u00148/F\u0001*!\r\t\"\u0006L\u0005\u0003WI\u0011Q!\u0011:sCf\u0004\"!\f\u001b\u000e\u00039R!a\f\u0019\u0002\u0007M\u001cHN\u0003\u00022e\u0005\u0019a.\u001a;\u000b\u0003M\nQA[1wCbL!!\u000e\u0018\u0003\u0019Q\u0013Xo\u001d;NC:\fw-\u001a:\t\r]j\u0001\u0015!\u0003*\u0003U!UMZ1vYR$&/^:u\u001b\u0006t\u0017mZ3sg\u0002Bq!O\u0007C\u0002\u0013%!(A\u0002Ba:,\u0012a\u000f\t\u0003y\tk\u0011!\u0010\u0006\u0003_yR!a\u0010!\u0002\u000f!\fg\u000e\u001a7fe*\u0011\u0011\tC\u0001\u0006]\u0016$H/_\u0005\u0003\u0007v\u0012\u0011$\u00119qY&\u001c\u0017\r^5p]B\u0013x\u000e^8d_2\u001cuN\u001c4jO\"1Q)\u0004Q\u0001\nm\nA!\u00119oA\u0019!aB\u0001\u0001H'\r1\u0005\u0003\u0013\t\u0003\u0013Bk\u0011A\u0013\u0006\u0003\u00172\u000bAb]2bY\u0006dwnZ4j]\u001eT!!\u0014(\u0002\u0011QL\b/Z:bM\u0016T\u0011aT\u0001\u0004G>l\u0017BA)K\u00055\u0019FO]5di2{wmZ5oO\"A1K\u0012B\u0001B\u0003%A+\u0001\u0006iiR\u00048i\u001c8gS\u001e\u0004\"!\u0016.\u000e\u0003YS!a\u0016-\u0002\r\r|gNZ5h\u0015\tIf!\u0001\u0003d_J,\u0017BA.W\u0005EAE\u000f\u001e9D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006/\u0019#\t!\u0018\u000b\u0003=~\u0003\"\u0001\u0004$\t\u000bMc\u0006\u0019\u0001+\t\u000f\u00054%\u0019!C\u0005E\u0006A2o\u001d7TKN\u001c\u0018n\u001c8US6,w.\u001e;TK\u000e|g\u000eZ:\u0016\u0003\r\u0004\"!\u00053\n\u0005\u0015\u0014\"\u0001\u0002'p]\u001eDaa\u001a$!\u0002\u0013\u0019\u0017!G:tYN+7o]5p]RKW.Z8viN+7m\u001c8eg\u0002Bq!\u001b$C\u0002\u0013%!.\u0001\tf]\u0006\u0014G.\u001a3Qe>$xnY8mgV\t1\u000eE\u0002\u0012U1\u0004\"!\u001c;\u000f\u00059\u0014\bCA8\u0013\u001b\u0005\u0001(BA9\u000b\u0003\u0019a$o\\8u}%\u00111OE\u0001\u0007!J,G-\u001a4\n\u0005U4(AB*ue&twM\u0003\u0002t%!1\u0001P\u0012Q\u0001\n-\f\u0011#\u001a8bE2,G\r\u0015:pi>\u001cw\u000e\\:!\u0011\u001dQhI1A\u0005\nm\f1#\u001a8bE2,GmQ5qQ\u0016\u00148+^5uKN,\u0012\u0001 \t\u0004{~dW\"\u0001@\u000b\u0005\r\u0001\u0013bAA\u0001}\n!A*[:u\u0011\u001d\t)A\u0012Q\u0001\nq\fA#\u001a8bE2,GmQ5qQ\u0016\u00148+^5uKN\u0004\u0003\"CA\u0005\r\n\u0007I\u0011BA\u0006\u0003))8/Z(qK:\u001c6\u000f\\\u000b\u0003\u0003\u001b\u00012!EA\b\u0013\r\t\tB\u0005\u0002\b\u0005>|G.Z1o\u0011!\t)B\u0012Q\u0001\n\u00055\u0011aC;tK>\u0003XM\\*tY\u0002Bq!!\u0007G\t\u0003\tY\"\u0001\boK^\u001c6\u000f\\\"p]R,\u0007\u0010^:\u0015\t\u0005u\u00111\u0005\t\u0004\u0019\u0005}\u0011bAA\u0011\u0005\tY1k\u001d7D_:$X\r\u001f;t\u0011!\t)#a\u0006A\u0002\u00055\u0011\u0001\u00045uiB\u0014TI\\1cY\u0016$\u0007bBA\u0015\r\u0012%\u00111F\u0001\u000e]\u0016<8k\u001d7D_:$X\r\u001f;\u0015\r\u00055\u00121GA\u001f!\ra\u0014qF\u0005\u0004\u0003ci$AC*tY\u000e{g\u000e^3yi\"A\u0011QGA\u0014\u0001\u0004\t9$A\u0007kI.\u001c6\u000f\\\"p]R,\u0007\u0010\u001e\t\u0004[\u0005e\u0012bAA\u001e]\tQ1k\u0015'D_:$X\r\u001f;\t\u000f\u0005}\u0012q\u0005a\u0001w\u0005\u0019\u0011\r\u001d8")
public class SslContextsFactory
implements StrictLogging {
    private final HttpConfiguration httpConfig;
    private final long sslSessionTimeoutSeconds;
    private final String[] io$gatling$http$util$SslContextsFactory$$enabledProtocols;
    private final List<String> io$gatling$http$util$SslContextsFactory$$enabledCipherSuites;
    private final boolean useOpenSsl;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private long sslSessionTimeoutSeconds() {
        return this.sslSessionTimeoutSeconds;
    }

    public String[] io$gatling$http$util$SslContextsFactory$$enabledProtocols() {
        return this.io$gatling$http$util$SslContextsFactory$$enabledProtocols;
    }

    public List<String> io$gatling$http$util$SslContextsFactory$$enabledCipherSuites() {
        return this.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites;
    }

    private boolean useOpenSsl() {
        return this.useOpenSsl;
    }

    public SslContexts newSslContexts(boolean http2Enabled) {
        SslContexts sslContexts;
        if (this.useOpenSsl()) {
            BoxedUnit boxedUnit;
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL);
            Object object = this.httpConfig.advanced().sslSessionCacheSize() > 0 ? sslContextBuilder.sessionCacheSize((long)this.httpConfig.advanced().sslSessionCacheSize()) : BoxedUnit.UNIT;
            Object object2 = this.httpConfig.advanced().sslSessionTimeout().$greater((Object)Duration$.MODULE$.Zero()) ? sslContextBuilder.sessionTimeout(this.sslSessionTimeoutSeconds()) : BoxedUnit.UNIT;
            Object object3 = this.io$gatling$http$util$SslContextsFactory$$enabledProtocols().length > 0 ? sslContextBuilder.protocols(this.io$gatling$http$util$SslContextsFactory$$enabledProtocols()) : BoxedUnit.UNIT;
            SslContextBuilder sslContextBuilder2 = this.httpConfig.advanced().sslEnabledCipherSuites().nonEmpty() ? sslContextBuilder.ciphers(this.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites()) : sslContextBuilder.ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS);
            this.httpConfig.ssl().keyManagerFactory().foreach((Function1 & Serializable & scala.Serializable)x$1 -> sslContextBuilder.keyManager(x$1));
            Option option = this.httpConfig.ssl().trustManagerFactory();
            if (option instanceof Some) {
                Some some = (Some)option;
                TrustManagerFactory tmf = (TrustManagerFactory)some.value();
                boxedUnit = sslContextBuilder.trustManager(tmf);
            } else {
                boxedUnit = this.httpConfig.advanced().useInsecureTrustManager() ? sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE) : BoxedUnit.UNIT;
            }
            SslContext sslContext = sslContextBuilder.build();
            None$ alpnSslContext = http2Enabled ? new Some((Object)sslContextBuilder.applicationProtocolConfig(SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn()).build()) : None$.MODULE$;
            sslContexts = new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
        } else {
            SSLContext jdkSslContext = SSLContext.getInstance("TLS");
            jdkSslContext.init((KeyManager[])this.httpConfig.ssl().keyManagerFactory().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKeyManagers()).orNull(Predef$.MODULE$.$conforms()), SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$DefaultTrustManagers(), SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$DefaultSslSecureRandom());
            SslContext sslContext = this.newSslContext(jdkSslContext, null);
            None$ alpnSslContext = http2Enabled ? new Some((Object)this.newSslContext(jdkSslContext, SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn())) : None$.MODULE$;
            sslContexts = new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
        }
        return sslContexts;
    }

    private SslContext newSslContext(SSLContext jdkSslContext, ApplicationProtocolConfig apn) {
        return new DelegatingSslContext(this, jdkSslContext, apn){
            private final /* synthetic */ SslContextsFactory $outer;

            public void initEngine(SSLEngine engine) {
                block0: {
                    if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.$outer.io$gatling$http$util$SslContextsFactory$$enabledProtocols())).nonEmpty()) break block0;
                    engine.setEnabledProtocols(this.$outer.io$gatling$http$util$SslContextsFactory$$enabledProtocols());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super((SslContext)new JdkSslContext(jdkSslContext$1, true, $outer.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites().isEmpty() ? null : $outer.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites(), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS, apn$1, ClientAuth.NONE, null, false));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public SslContextsFactory(HttpConfiguration httpConfig) {
        boolean bl;
        this.httpConfig = httpConfig;
        StrictLogging.$init$((StrictLogging)this);
        this.sslSessionTimeoutSeconds = httpConfig.advanced().sslSessionTimeout().toSeconds();
        this.io$gatling$http$util$SslContextsFactory$$enabledProtocols = (String[])httpConfig.advanced().sslEnabledProtocols().toArray(ClassTag$.MODULE$.apply(String.class));
        this.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)httpConfig.advanced().sslEnabledCipherSuites()).asJava();
        if (httpConfig.advanced().useOpenSsl()) {
            void var2_2;
            BoxedUnit boxedUnit;
            boolean available = OpenSsl.isAvailable();
            if (!available) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("OpenSSL is enabled in the Gatling configuration but it's not available on your architecture.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = var2_2;
        } else {
            bl = false;
        }
        this.useOpenSsl = bl;
    }
}

