/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.response;

import com.typesafe.scalalogging.Logger;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Collections;
import io.gatling.commons.util.Collections$;
import io.gatling.commons.util.Maps;
import io.gatling.commons.util.Maps$;
import io.gatling.commons.util.StringHelper$;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.http.HeaderNames$;
import io.gatling.http.check.HttpCheck;
import io.gatling.http.check.checksum.ChecksumCheck;
import io.gatling.http.client.Request;
import io.gatling.http.response.ByteArrayResponseBody$;
import io.gatling.http.response.ByteArrayResponseBodyUsage$;
import io.gatling.http.response.CharArrayResponseBody$;
import io.gatling.http.response.CharArrayResponseBodyUsage$;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.InputStreamResponseBody$;
import io.gatling.http.response.InputStreamResponseBodyUsage$;
import io.gatling.http.response.NoResponseBody$;
import io.gatling.http.response.Response;
import io.gatling.http.response.ResponseBodyUsageStrategy;
import io.gatling.http.response.ResponseBuilder$;
import io.gatling.http.response.StringResponseBody$;
import io.gatling.http.response.StringResponseBodyUsage$;
import io.gatling.http.util.HttpHelper$;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t]t!B\u0001\u0003\u0011\u0003Y\u0011a\u0004*fgB|gn]3Ck&dG-\u001a:\u000b\u0005\r!\u0011\u0001\u0003:fgB|gn]3\u000b\u0005\u00151\u0011\u0001\u00025uiBT!a\u0002\u0005\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011\"\u0001\u0002j_\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!a\u0004*fgB|gn]3Ck&dG-\u001a:\u0014\u00075\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/yi\u0011\u0001\u0007\u0006\u00033i\tAb]2bY\u0006dwnZ4j]\u001eT!a\u0007\u000f\u0002\u0011QL\b/Z:bM\u0016T\u0011!H\u0001\u0004G>l\u0017BA\u0010\u0019\u00055\u0019FO]5di2{wmZ5oO\")\u0011%\u0004C\u0001E\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\u0006I5!\t!J\u0001\u001a]\u0016<(+Z:q_:\u001cXMQ;jY\u0012,'OR1di>\u0014\u0018\u0010F\u0003'[\u0001+u\n\u0005\u0002(U9\u0011A\u0002K\u0005\u0003S\t\tq\u0001]1dW\u0006<W-\u0003\u0002,Y\t1\"+Z:q_:\u001cXMQ;jY\u0012,'OR1di>\u0014\u0018P\u0003\u0002*\u0005!)af\ta\u0001_\u000511\r[3dWN\u00042\u0001M\u001c;\u001d\t\tdG\u0004\u00023k5\t1G\u0003\u00025\u0015\u00051AH]8pizJ\u0011aE\u0005\u0003SII!\u0001O\u001d\u0003\t1K7\u000f\u001e\u0006\u0003SI\u0001\"a\u000f \u000e\u0003qR!!\u0010\u0003\u0002\u000b\rDWmY6\n\u0005}b$!\u0003%uiB\u001c\u0005.Z2l\u0011\u0015\t5\u00051\u0001C\u0003IIgNZ3s\u0011RlGNU3t_V\u00148-Z:\u0011\u0005E\u0019\u0015B\u0001#\u0013\u0005\u001d\u0011un\u001c7fC:DQAR\u0012A\u0002\u001d\u000bQa\u00197pG.\u0004\"\u0001S'\u000e\u0003%S!AS&\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0019\u001a\tqaY8n[>t7/\u0003\u0002O\u0013\n)1\t\\8dW\")\u0001k\ta\u0001#\u0006i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"AU,\u000e\u0003MS!\u0001V+\u0002\r\r|gNZ5h\u0015\t1f!\u0001\u0003d_J,\u0017B\u0001-T\u0005Q9\u0015\r\u001e7j]\u001e\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u001a!aB\u0001\u0001['\tI\u0006\u0003\u0003\u0005]3\n\u0005\t\u0015!\u0003^\u0003\u001d\u0011X-];fgR\u0004\"AX1\u000e\u0003}S!\u0001\u0019\u0003\u0002\r\rd\u0017.\u001a8u\u0013\t\u0011wLA\u0004SKF,Xm\u001d;\t\u0011\u0011L&\u0011!Q\u0001\n\u0015\fab\u00195fG.\u001cX/\\\"iK\u000e\\7\u000fE\u00021o\u0019\u0004\"a\u001a6\u000e\u0003!T!!\u001b\u001f\u0002\u0011\rDWmY6tk6L!a\u001b5\u0003\u001b\rCWmY6tk6\u001c\u0005.Z2l\u0011!i\u0017L!A!\u0002\u0013q\u0017a\u00052pIf,6/Y4f'R\u0014\u0018\r^3hS\u0016\u001c\bc\u0001\u0019pc&\u0011\u0001/\u000f\u0002\u0004'\u0016\f\bC\u0001\u0007s\u0013\t\u0019(AA\rSKN\u0004xN\\:f\u0005>$\u00170V:bO\u0016\u001cFO]1uK\u001eL\b\u0002C;Z\u0005\u0003\u0005\u000b\u0011\u0002\"\u0002\u001dM$xN]3C_\u0012L\b+\u0019:ug\"A\u0011)\u0017B\u0001B\u0003%!\t\u0003\u0005y3\n\u0005\t\u0015!\u0003z\u00039!WMZ1vYR\u001c\u0005.\u0019:tKR\u00042A_A\u0002\u001b\u0005Y(B\u0001?~\u0003\u001d\u0019\u0007.\u0019:tKRT!A`@\u0002\u00079LwN\u0003\u0002\u0002\u0002\u0005!!.\u0019<b\u0013\r\t)a\u001f\u0002\b\u0007\"\f'o]3u\u0011!1\u0015L!A!\u0002\u00139\u0005BB\u0011Z\t\u0003\tY\u0001\u0006\t\u0002\u000e\u0005=\u0011\u0011CA\n\u0003+\t9\"!\u0007\u0002\u001cA\u0011A\"\u0017\u0005\u00079\u0006%\u0001\u0019A/\t\r\u0011\fI\u00011\u0001f\u0011\u0019i\u0017\u0011\u0002a\u0001]\"1Q/!\u0003A\u0002\tCa!QA\u0005\u0001\u0004\u0011\u0005B\u0002=\u0002\n\u0001\u0007\u0011\u0010\u0003\u0004G\u0003\u0013\u0001\ra\u0012\u0005\n\u0003?I&\u0019!C\u0005\u0003C\t\u0001cY8naV$Xm\u00115fG.\u001cX/\\:\u0016\u0003\tCq!!\nZA\u0003%!)A\td_6\u0004X\u000f^3DQ\u0016\u001c7n];ng\u0002B1\"!\u000bZ\u0001\u0004\u0005\r\u0011\"\u0001\u0002\"\u0005q1\u000f^8sK\"#X\u000e\\(s\u0007N\u001c\bbCA\u00173\u0002\u0007\t\u0019!C\u0001\u0003_\t!c\u001d;pe\u0016DE/\u001c7Pe\u000e\u001b8o\u0018\u0013fcR!\u0011\u0011GA\u001c!\r\t\u00121G\u0005\u0004\u0003k\u0011\"\u0001B+oSRD\u0011\"!\u000f\u0002,\u0005\u0005\t\u0019\u0001\"\u0002\u0007a$\u0013\u0007\u0003\u0006\u0002>e\u0003\r\u0011!Q!\n\t\u000bqb\u001d;pe\u0016DE/\u001c7Pe\u000e\u001b8\u000f\t\u0005\f\u0003\u0003J\u0006\u0019!a\u0001\n\u0003\t\u0019%\u0001\bti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9\u0016\u0005\u0005\u0015\u0003cA\t\u0002H%\u0019\u0011\u0011\n\n\u0003\t1{gn\u001a\u0005\f\u0003\u001bJ\u0006\u0019!a\u0001\n\u0003\ty%\u0001\nti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9`I\u0015\fH\u0003BA\u0019\u0003#B!\"!\u000f\u0002L\u0005\u0005\t\u0019AA#\u0011-\t)&\u0017a\u0001\u0002\u0003\u0006K!!\u0012\u0002\u001fM$\u0018M\u001d;US6,7\u000f^1na\u0002B1\"!\u0017Z\u0001\u0004\u0005\r\u0011\"\u0001\u0002D\u0005aQM\u001c3US6,7\u000f^1na\"Y\u0011QL-A\u0002\u0003\u0007I\u0011AA0\u0003A)g\u000e\u001a+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0003\u00022\u0005\u0005\u0004BCA\u001d\u00037\n\t\u00111\u0001\u0002F!Y\u0011QM-A\u0002\u0003\u0005\u000b\u0015BA#\u00035)g\u000e\u001a+j[\u0016\u001cH/Y7qA!Y\u0011\u0011N-A\u0002\u0003\u0007I\u0011BA\u0011\u0003\u001dI7\u000f\u0013;uaJB1\"!\u001cZ\u0001\u0004\u0005\r\u0011\"\u0003\u0002p\u0005Y\u0011n\u001d%uiB\u0014t\fJ3r)\u0011\t\t$!\u001d\t\u0013\u0005e\u00121NA\u0001\u0002\u0004\u0011\u0005BCA;3\u0002\u0007\t\u0011)Q\u0005\u0005\u0006A\u0011n\u001d%uiB\u0014\u0004\u0005C\u0005\u0002ze\u0003\r\u0011\"\u0003\u0002|\u000511\u000f^1ukN,\"!! \u0011\u000bE\ty(a!\n\u0007\u0005\u0005%C\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u000b\u000b)*\u0004\u0002\u0002\b*\u0019Q!!#\u000b\t\u0005-\u0015QR\u0001\u0006G>$Wm\u0019\u0006\u0005\u0003\u001f\u000b\t*A\u0004iC:$G.\u001a:\u000b\u0007\u0005M\u0005\"A\u0003oKR$\u00180\u0003\u0003\u0002\u0018\u0006\u001d%A\u0005%uiB\u0014Vm\u001d9p]N,7\u000b^1ukND\u0011\"a'Z\u0001\u0004%I!!(\u0002\u0015M$\u0018\r^;t?\u0012*\u0017\u000f\u0006\u0003\u00022\u0005}\u0005BCA\u001d\u00033\u000b\t\u00111\u0001\u0002~!A\u00111U-!B\u0013\ti(A\u0004ti\u0006$Xo\u001d\u0011\t\u0013\u0005\u001d\u0016\f1A\u0005\n\u0005%\u0016AE<je\u0016\u0014V-];fgRDU-\u00193feN,\"!a+\u0011\t\u0005\u0015\u0015QV\u0005\u0005\u0003_\u000b9IA\u0006IiR\u0004\b*Z1eKJ\u001c\b\"CAZ3\u0002\u0007I\u0011BA[\u0003Y9\u0018N]3SKF,Xm\u001d;IK\u0006$WM]:`I\u0015\fH\u0003BA\u0019\u0003oC!\"!\u000f\u00022\u0006\u0005\t\u0019AAV\u0011!\tY,\u0017Q!\n\u0005-\u0016aE<je\u0016\u0014V-];fgRDU-\u00193feN\u0004\u0003\"CA`3\u0002\u0007I\u0011BAU\u0003\u001dAW-\u00193feND\u0011\"a1Z\u0001\u0004%I!!2\u0002\u0017!,\u0017\rZ3sg~#S-\u001d\u000b\u0005\u0003c\t9\r\u0003\u0006\u0002:\u0005\u0005\u0017\u0011!a\u0001\u0003WC\u0001\"a3ZA\u0003&\u00111V\u0001\tQ\u0016\fG-\u001a:tA!I\u0011qZ-A\u0002\u0013%\u0011\u0011[\u0001\u0007G\",hn[:\u0016\u0005\u0005M\u0007\u0003\u0002\u00198\u0003+\u0004B!a6\u0002^6\u0011\u0011\u0011\u001c\u0006\u0005\u00037\f\t*\u0001\u0004ck\u001a4WM]\u0005\u0005\u0003?\fINA\u0004CsR,')\u001e4\t\u0013\u0005\r\u0018\f1A\u0005\n\u0005\u0015\u0018AC2ik:\\7o\u0018\u0013fcR!\u0011\u0011GAt\u0011)\tI$!9\u0002\u0002\u0003\u0007\u00111\u001b\u0005\t\u0003WL\u0006\u0015)\u0003\u0002T\u000691\r[;oWN\u0004\u0003\"CAx3\n\u0007I\u0011BAy\u0003\u001d!\u0017nZ3tiN,\"!a=\u0011\u0011\u0005U\u0018Q B\u0002\u0005\u0013qA!a>\u0002zB\u0011!GE\u0005\u0004\u0003w\u0014\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0000\n\u0005!aA'ba*\u0019\u00111 \n\u0011\t\u0005U(QA\u0005\u0005\u0005\u000f\u0011\tA\u0001\u0004TiJLgn\u001a\t\u0005\u0005\u0017\u0011\t\"\u0004\u0002\u0003\u000e)\u0019!qB@\u0002\u0011M,7-\u001e:jifLAAa\u0005\u0003\u000e\tiQ*Z:tC\u001e,G)[4fgRD\u0001Ba\u0006ZA\u0003%\u00111_\u0001\tI&<Wm\u001d;tA!9!1D-\u0005\u0002\tu\u0011\u0001F;qI\u0006$Xm\u0015;beR$\u0016.\\3ti\u0006l\u0007\u000f\u0006\u0002\u00022!9!\u0011E-\u0005\u0002\tu\u0011AE;qI\u0006$X-\u00128e)&lWm\u001d;b[BDqA!\nZ\t\u0003\u00119#\u0001\u0006bG\u000e,X.\u001e7bi\u0016$B!!\r\u0003*!A\u0011q\u0015B\u0012\u0001\u0004\tY\u000bC\u0004\u0003&e#\tA!\f\u0015\r\u0005E\"q\u0006B\u0019\u0011!\tIHa\u000bA\u0002\u0005\r\u0005\u0002CA`\u0005W\u0001\r!a+\t\u000f\tU\u0012\f\"\u0001\u00038\u0005A1/\u001a;IiR\u0004(\u0007\u0006\u0003\u00022\te\u0002bBA5\u0005g\u0001\rA\u0011\u0005\b\u0005KIF\u0011\u0001B\u001f)\u0011\t\tDa\u0010\t\u0011\t\u0005#1\ba\u0001\u0003+\fqAY=uK\n+h\rC\u0004\u0003Fe#IAa\u0012\u0002\u001dI,7o\u001c7wK\u000eC\u0017M]:fiV\t\u0011\u0010C\u0004\u0003Le#\tA!\u0014\u0002\u001b\t,\u0018\u000e\u001c3SKN\u0004xN\\:f+\t\u0011y\u0005E\u0002\r\u0005#J1Aa\u0015\u0003\u0005)AE\u000f\u001e9SKN,H\u000e\u001e\u0005\b\u0005/JF\u0011\u0001B-\u00031\u0011W/\u001b7e\r\u0006LG.\u001e:f)\u0011\u0011YF!\u0019\u0011\u00071\u0011i&C\u0002\u0003`\t\u00111\u0002\u0013;ua\u001a\u000b\u0017\u000e\\;sK\"A!1\rB+\u0001\u0004\u0011)'A\u0001u!\r\u0001$qM\u0005\u0004\u0005SJ$!\u0003+ie><\u0018M\u00197f\u0011\u001d\u00119&\u0017C\u0005\u0005[\"BAa\u0017\u0003p!A!\u0011\u000fB6\u0001\u0004\u0011\u0019!\u0001\u0007feJ|'/T3tg\u0006<W\rC\u0004\u0003ve#IA!\b\u0002\u001bI,G.Z1tK\u000eCWO\\6t\u0001")
public class ResponseBuilder {
    private final Request request;
    private final Seq<ResponseBodyUsageStrategy> bodyUsageStrategies;
    private final boolean storeBodyParts;
    private final boolean inferHtmlResources;
    private final Charset defaultCharset;
    private final Clock clock;
    private final boolean computeChecksums;
    private boolean storeHtmlOrCss;
    private long startTimestamp;
    private long endTimestamp;
    private boolean isHttp2;
    private Option<HttpResponseStatus> status;
    private HttpHeaders wireRequestHeaders;
    private HttpHeaders headers;
    private List<ByteBuf> chunks;
    private final Map<String, MessageDigest> digests;

    public static Function1<Request, ResponseBuilder> newResponseBuilderFactory(List<HttpCheck> list, boolean bl, Clock clock, GatlingConfiguration gatlingConfiguration) {
        return ResponseBuilder$.MODULE$.newResponseBuilderFactory(list, bl, clock, gatlingConfiguration);
    }

    public static Logger logger() {
        return ResponseBuilder$.MODULE$.logger();
    }

    private boolean computeChecksums() {
        return this.computeChecksums;
    }

    public boolean storeHtmlOrCss() {
        return this.storeHtmlOrCss;
    }

    public void storeHtmlOrCss_$eq(boolean x$1) {
        this.storeHtmlOrCss = x$1;
    }

    public long startTimestamp() {
        return this.startTimestamp;
    }

    public void startTimestamp_$eq(long x$1) {
        this.startTimestamp = x$1;
    }

    public long endTimestamp() {
        return this.endTimestamp;
    }

    public void endTimestamp_$eq(long x$1) {
        this.endTimestamp = x$1;
    }

    private boolean isHttp2() {
        return this.isHttp2;
    }

    private void isHttp2_$eq(boolean x$1) {
        this.isHttp2 = x$1;
    }

    private Option<HttpResponseStatus> status() {
        return this.status;
    }

    private void status_$eq(Option<HttpResponseStatus> x$1) {
        this.status = x$1;
    }

    private HttpHeaders wireRequestHeaders() {
        return this.wireRequestHeaders;
    }

    private void wireRequestHeaders_$eq(HttpHeaders x$1) {
        this.wireRequestHeaders = x$1;
    }

    private HttpHeaders headers() {
        return this.headers;
    }

    private void headers_$eq(HttpHeaders x$1) {
        this.headers = x$1;
    }

    private List<ByteBuf> chunks() {
        return this.chunks;
    }

    private void chunks_$eq(List<ByteBuf> x$1) {
        this.chunks = x$1;
    }

    private Map<String, MessageDigest> digests() {
        return this.digests;
    }

    public void updateStartTimestamp() {
        this.startTimestamp_$eq(this.clock.nowMillis());
    }

    public void updateEndTimestamp() {
        this.endTimestamp_$eq(this.clock.nowMillis());
    }

    public void accumulate(HttpHeaders wireRequestHeaders) {
        this.wireRequestHeaders_$eq(wireRequestHeaders);
    }

    public void accumulate(HttpResponseStatus status, HttpHeaders headers) {
        this.updateEndTimestamp();
        this.status_$eq((Option<HttpResponseStatus>)new Some((Object)status));
        if (this.headers() == EmptyHttpHeaders.INSTANCE) {
            this.headers_$eq(headers);
            this.storeHtmlOrCss_$eq(this.inferHtmlResources && (HttpHelper$.MODULE$.isHtml(headers) || HttpHelper$.MODULE$.isCss(headers)));
        } else {
            this.headers().add(headers);
        }
    }

    public void setHttp2(boolean isHttp2) {
        this.isHttp2_$eq(isHttp2);
    }

    public void accumulate(ByteBuf byteBuf) {
        block2: {
            this.updateEndTimestamp();
            if (!byteBuf.isReadable()) break block2;
            if (this.storeBodyParts || this.storeHtmlOrCss()) {
                ByteBuf byteBuf2 = byteBuf.retain();
                this.chunks_$eq((List<ByteBuf>)this.chunks().$colon$colon((Object)byteBuf2));
            }
            if (this.computeChecksums()) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])byteBuf.nioBuffers())).foreach((Function1 & Serializable & scala.Serializable)nioBuffer -> {
                    ResponseBuilder.$anonfun$accumulate$1(this, nioBuffer);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    private Charset resolveCharset() {
        return (Charset)Option$.MODULE$.apply((Object)this.headers().get(HeaderNames$.MODULE$.ContentType())).flatMap((Function1 & Serializable & scala.Serializable)contentType -> HttpHelper$.MODULE$.extractCharsetFromContentType((String)contentType)).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.defaultCharset);
    }

    public HttpResult buildResponse() {
        HttpFailure httpFailure;
        try {
            HttpFailure httpFailure2;
            Option<HttpResponseStatus> option = this.status();
            if (option instanceof Some) {
                Product product;
                Some some = (Some)option;
                HttpResponseStatus s = (HttpResponseStatus)some.value();
                try {
                    this.endTimestamp_$eq(package$.MODULE$.max(this.endTimestamp(), this.startTimestamp()));
                    Map checksums = Maps.PimpedMap$.MODULE$.forceMapValues$extension(Maps$.MODULE$.PimpedMap(this.digests()), (Function1 & Serializable & scala.Serializable)md -> StringHelper$.MODULE$.bytes2Hex(md.digest()));
                    int contentLength = BoxesRunTime.unboxToInt((Object)Collections.PimpedTraversableOnce$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedTraversableOnce(this.chunks()), (Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.readableBytes()), (Numeric)Numeric.IntIsIntegral$.MODULE$));
                    Set bodyUsages = (Set)this.bodyUsageStrategies.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.bodyUsage(contentLength), scala.collection.package$.MODULE$.breakOut(Set$.MODULE$.canBuildFrom()));
                    Charset resolvedCharset = this.resolveCharset();
                    List properlyOrderedChunks = this.chunks().reverse();
                    NoResponseBody$ body = properlyOrderedChunks.isEmpty() ? NoResponseBody$.MODULE$ : (bodyUsages.contains((Object)ByteArrayResponseBodyUsage$.MODULE$) ? ByteArrayResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset) : (bodyUsages.contains((Object)InputStreamResponseBodyUsage$.MODULE$) ? InputStreamResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset) : (bodyUsages.contains((Object)StringResponseBodyUsage$.MODULE$) ? StringResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset) : (bodyUsages.contains((Object)CharArrayResponseBodyUsage$.MODULE$) ? CharArrayResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset) : (HttpHelper$.MODULE$.isTxt(this.headers()) ? StringResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset) : ByteArrayResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset))))));
                    product = new Response(this.request, this.wireRequestHeaders(), s, this.headers(), body, (Map<String, String>)checksums, contentLength, resolvedCharset, this.startTimestamp(), this.endTimestamp(), this.isHttp2());
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                    if (option2.isEmpty()) {
                        throw throwable;
                    }
                    Throwable t = (Throwable)option2.get();
                    HttpFailure httpFailure3 = this.buildFailure(t);
                    product = httpFailure3;
                }
                httpFailure2 = product;
            } else {
                httpFailure2 = this.buildFailure("How come we're trying to build a response with no status?!");
            }
            httpFailure = httpFailure2;
        }
        finally {
            this.releaseChunks();
        }
        return httpFailure;
    }

    public HttpFailure buildFailure(Throwable t) {
        HttpFailure httpFailure;
        try {
            httpFailure = this.buildFailure(Throwables.PimpedException$.MODULE$.detailedMessage$extension(Throwables$.MODULE$.PimpedException(t)));
        }
        finally {
            this.releaseChunks();
        }
        return httpFailure;
    }

    private HttpFailure buildFailure(String errorMessage) {
        return new HttpFailure(this.request, this.wireRequestHeaders(), this.startTimestamp(), this.endTimestamp(), errorMessage);
    }

    private void releaseChunks() {
        this.chunks().foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.release()));
        this.chunks_$eq((List<ByteBuf>)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$accumulate$1(ResponseBuilder $this, ByteBuffer nioBuffer) {
        $this.digests().values().foreach((Function1 & Serializable & scala.Serializable)digest -> {
            digest.update(nioBuffer.duplicate());
            return BoxedUnit.UNIT;
        });
    }

    public ResponseBuilder(Request request, List<ChecksumCheck> checksumChecks, Seq<ResponseBodyUsageStrategy> bodyUsageStrategies, boolean storeBodyParts, boolean inferHtmlResources, Charset defaultCharset, Clock clock) {
        this.request = request;
        this.bodyUsageStrategies = bodyUsageStrategies;
        this.storeBodyParts = storeBodyParts;
        this.inferHtmlResources = inferHtmlResources;
        this.defaultCharset = defaultCharset;
        this.clock = clock;
        this.computeChecksums = checksumChecks.nonEmpty();
        this.status = None$.MODULE$;
        this.wireRequestHeaders = EmptyHttpHeaders.INSTANCE;
        this.headers = EmptyHttpHeaders.INSTANCE;
        this.chunks = Nil$.MODULE$;
        this.digests = this.computeChecksums() ? (Map)checksumChecks.map((Function1 & Serializable & scala.Serializable)check -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)check.algorithm()), (Object)MessageDigest.getInstance(check.algorithm())), scala.collection.package$.MODULE$.breakOut(Map$.MODULE$.canBuildFrom())) : Predef$.MODULE$.Map().empty();
    }
}

