/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.multipart.impl;

import io.gatling.http.client.ahc.util.MiscUtils;
import io.gatling.http.client.body.multipart.impl.PartImpl;
import io.gatling.http.client.body.multipart.impl.PartImplState;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class MultipartChunkedInput
implements ChunkedInput<ByteBuf> {
    static final int DEFAULT_CHUNK_SIZE = 8192;
    private final List<PartImpl> parts;
    private final long contentLength;
    private final int chunkSize;
    private final AtomicBoolean closed = new AtomicBoolean();
    private boolean endOfInput;
    private long progress = 0L;
    private int currentPartIndex;
    private boolean done = false;

    public MultipartChunkedInput(List<PartImpl> list, long l) {
        this.parts = list;
        this.contentLength = l;
        this.chunkSize = l > 0L ? (int)Math.min(l, 8192L) : 8192;
    }

    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext channelHandlerContext) throws Exception {
        return this.readChunk(channelHandlerContext.alloc());
    }

    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) throws Exception {
        if (this.endOfInput) {
            return null;
        }
        ByteBuf byteBuf = byteBufAllocator.buffer(this.chunkSize);
        ChunkedInputState chunkedInputState = this.copyInto(byteBuf);
        this.progress += (long)byteBuf.writerIndex();
        switch (chunkedInputState) {
            case STOP: {
                this.endOfInput = true;
                return byteBuf;
            }
            case SUSPEND: {
                byteBuf.release();
                return null;
            }
            case CONTINUE: {
                return byteBuf;
            }
        }
        throw new IllegalStateException("Unknown state: " + (Object)((Object)chunkedInputState));
    }

    private ChunkedInputState copyInto(ByteBuf byteBuf) throws IOException {
        if (this.done) {
            return ChunkedInputState.STOP;
        }
        while (byteBuf.isWritable() && !this.done) {
            PartImpl partImpl = this.parts.get(this.currentPartIndex);
            partImpl.copyInto(byteBuf);
            if (partImpl.getState() != PartImplState.DONE) continue;
            ++this.currentPartIndex;
            if (this.currentPartIndex != this.parts.size()) continue;
            this.done = true;
        }
        return ChunkedInputState.CONTINUE;
    }

    public boolean isEndOfInput() {
        return this.endOfInput;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            for (PartImpl partImpl : this.parts) {
                MiscUtils.closeSilently(partImpl);
            }
        }
    }

    public long length() {
        return this.contentLength;
    }

    public long progress() {
        return this.progress;
    }

    private static enum ChunkedInputState {
        CONTINUE,
        SUSPEND,
        STOP;

    }
}

