/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.stats.writer;

import io.gatling.commons.util.Clock;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.writer.AssertionSerializer;
import io.gatling.core.stats.writer.BufferedFileChannelWriter;
import io.gatling.core.stats.writer.BufferedFileChannelWriter$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.ErrorMessage;
import io.gatling.core.stats.writer.ErrorMessageSerializer;
import io.gatling.core.stats.writer.FileData;
import io.gatling.core.stats.writer.GroupMessage;
import io.gatling.core.stats.writer.GroupMessageSerializer;
import io.gatling.core.stats.writer.Init;
import io.gatling.core.stats.writer.LoadEventMessage;
import io.gatling.core.stats.writer.ResponseMessage;
import io.gatling.core.stats.writer.ResponseMessageSerializer;
import io.gatling.core.stats.writer.RunMessageSerializer;
import io.gatling.core.stats.writer.UserMessage;
import io.gatling.core.stats.writer.UserMessageSerializer;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001y3A!\u0001\u0002\u0001\u001b\t\tBj\\4GS2,G)\u0019;b/JLG/\u001a:\u000b\u0005\r!\u0011AB<sSR,'O\u0003\u0002\u0006\r\u0005)1\u000f^1ug*\u0011q\u0001C\u0001\u0005G>\u0014XM\u0003\u0002\n\u0015\u00059q-\u0019;mS:<'\"A\u0006\u0002\u0005%|7\u0001A\n\u0003\u00019\u00012a\u0004\t\u0013\u001b\u0005\u0011\u0011BA\t\u0003\u0005)!\u0015\r^1Xe&$XM\u001d\t\u0003\u001fMI!\u0001\u0006\u0002\u0003\u0011\u0019KG.\u001a#bi\u0006D\u0001B\u0006\u0001\u0003\u0002\u0003\u0006IaF\u0001\u0006G2|7m\u001b\t\u00031ui\u0011!\u0007\u0006\u00035m\tA!\u001e;jY*\u0011A\u0004C\u0001\bG>lWn\u001c8t\u0013\tq\u0012DA\u0003DY>\u001c7\u000e\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\"\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011!%J\u0007\u0002G)\u0011AEB\u0001\u0007G>tg-[4\n\u0005\u0019\u001a#\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g\u000eC\u0003)\u0001\u0011\u0005\u0011&\u0001\u0004=S:LGO\u0010\u000b\u0004U-b\u0003CA\b\u0001\u0011\u00151r\u00051\u0001\u0018\u0011\u0015\u0001s\u00051\u0001\"\u0011\u0015q\u0003\u0001\"\u00010\u0003\u0019yg.\u00138jiR\u0011!\u0003\r\u0005\u0006c5\u0002\rAM\u0001\u0005S:LG\u000f\u0005\u0002\u0010g%\u0011AG\u0001\u0002\u0005\u0013:LG\u000fC\u00037\u0001\u0011\u0005s'A\u0004p]\u001acWo\u001d5\u0015\u0005ar\u0004CA\u001d=\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR$\u0001B+oSRDQaP\u001bA\u0002I\tA\u0001Z1uC\")\u0011\t\u0001C!\u0005\u0006IqN\\'fgN\fw-\u001a\u000b\u0004q\rC\u0005\"\u0002#A\u0001\u0004)\u0015aB7fgN\fw-\u001a\t\u0003\u001f\u0019K!a\u0012\u0002\u0003!1{\u0017\rZ#wK:$X*Z:tC\u001e,\u0007\"B A\u0001\u0004\u0011\u0002\"\u0002&\u0001\t\u0003Z\u0015aB8o\u0007J\f7\u000f\u001b\u000b\u0004q1K\u0006\"B'J\u0001\u0004q\u0015!B2bkN,\u0007CA(W\u001d\t\u0001F\u000b\u0005\u0002Ru5\t!K\u0003\u0002T\u0019\u00051AH]8pizJ!!\u0016\u001e\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+jBQaP%A\u0002IAQa\u0017\u0001\u0005Bq\u000baa\u001c8Ti>\u0004HC\u0001\u001d^\u0011\u0015y$\f1\u0001\u0013\u0001")
public class LogFileDataWriter
extends DataWriter<FileData> {
    private final GatlingConfiguration configuration;

    @Override
    public FileData onInit(Init init) {
        BufferedFileChannelWriter writer = BufferedFileChannelWriter$.MODULE$.apply(init.runMessage().runId(), this.configuration);
        this.system().registerOnTermination((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> writer.close());
        AssertionSerializer assertionSerializer = new AssertionSerializer(writer);
        init.assertions().foreach((Function1 & Serializable & scala.Serializable)assertion -> {
            assertionSerializer.serialize(assertion);
            return BoxedUnit.UNIT;
        });
        new RunMessageSerializer(writer).serialize(init.runMessage());
        return new FileData(new UserMessageSerializer(writer), new ResponseMessageSerializer(writer), new GroupMessageSerializer(writer), new ErrorMessageSerializer(writer), writer);
    }

    @Override
    public void onFlush(FileData data) {
    }

    @Override
    public void onMessage(LoadEventMessage message, FileData data) {
        LoadEventMessage loadEventMessage = message;
        if (loadEventMessage instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)loadEventMessage;
            data.userMessageSerializer().serialize(userMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof GroupMessage) {
            GroupMessage groupMessage = (GroupMessage)loadEventMessage;
            data.groupMessageSerializer().serialize(groupMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
            data.responseMessageSerializer().serialize(responseMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ErrorMessage) {
            ErrorMessage errorMessage = (ErrorMessage)loadEventMessage;
            data.errorMessageSerializer().serialize(errorMessage);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void onCrash(String cause, FileData data) {
    }

    @Override
    public void onStop(FileData data) {
        data.writer().close();
    }

    public LogFileDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.configuration = configuration;
    }
}

