/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.controller.inject;

import akka.actor.ActorSystem;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.core.scenario.Scenario;
import io.gatling.core.session.Block;
import io.gatling.core.session.Session;
import io.gatling.core.session.Session$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.stats.message.Start$;
import io.gatling.core.stats.writer.UserMessage;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d!B\u0001\u0003\u0003\u0003i!\u0001C,pe.dw.\u00193\u000b\u0005\r!\u0011AB5oU\u0016\u001cGO\u0003\u0002\u0006\r\u0005Q1m\u001c8ue>dG.\u001a:\u000b\u0005\u001dA\u0011\u0001B2pe\u0016T!!\u0003\u0006\u0002\u000f\u001d\fG\u000f\\5oO*\t1\"\u0001\u0002j_\u000e\u00011c\u0001\u0001\u000f)A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\u000f\u000e\u0003YQ!a\u0006\r\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005eQ\u0012\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003m\t1aY8n\u0013\tibCA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\u0005\t?\u0001\u0011\t\u0011)A\u0005A\u0005A1oY3oCJLw\u000e\u0005\u0002\"G5\t!E\u0003\u0002 \r%\u0011AE\t\u0002\t'\u000e,g.\u0019:j_\"Aa\u0005\u0001B\u0001B\u0003%q%A\u0005vg\u0016\u0014\u0018\nZ$f]B\u0011\u0001&M\u0007\u0002S)\u0011!fK\u0001\u0007CR|W.[2\u000b\u00051j\u0013AC2p]\u000e,(O]3oi*\u0011afL\u0001\u0005kRLGNC\u00011\u0003\u0011Q\u0017M^1\n\u0005IJ#AC!u_6L7\rT8oO\"AA\u0007\u0001B\u0001B\u0003%Q'A\u0005ti\u0006\u0014H\u000fV5nKB\u0011qBN\u0005\u0003oA\u0011A\u0001T8oO\"A\u0011\b\u0001B\u0001B\u0003%!(\u0001\u0004tsN$X-\u001c\t\u0003w\u0001k\u0011\u0001\u0010\u0006\u0003{y\nQ!Y2u_JT\u0011aP\u0001\u0005C.\\\u0017-\u0003\u0002By\tY\u0011i\u0019;peNK8\u000f^3n\u0011!\u0019\u0005A!A!\u0002\u0013!\u0015aC:uCR\u001cXI\\4j]\u0016\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012\u0004\u0002\u000bM$\u0018\r^:\n\u0005%3%aC*uCR\u001cXI\\4j]\u0016D\u0001b\u0013\u0001\u0003\u0002\u0003\u0006I\u0001T\u0001\u0006G2|7m\u001b\t\u0003\u001bFk\u0011A\u0014\u0006\u0003]=S!\u0001\u0015\u0005\u0002\u000f\r|W.\\8og&\u0011!K\u0014\u0002\u0006\u00072|7m\u001b\u0005\u0006)\u0002!\t!V\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fYC\u0016LW.];B\u0011q\u000bA\u0007\u0002\u0005!)qd\u0015a\u0001A!)ae\u0015a\u0001O!)Ag\u0015a\u0001k!)\u0011h\u0015a\u0001u!)1i\u0015a\u0001\t\")1j\u0015a\u0001\u0019\"9q\f\u0001a\u0001\n\u0013\u0001\u0017!C:dQ\u0016$W\u000f\\3e+\u0005\t\u0007CA\bc\u0013\t\u0019\u0007CA\u0002J]RDq!\u001a\u0001A\u0002\u0013%a-A\u0007tG\",G-\u001e7fI~#S-\u001d\u000b\u0003O*\u0004\"a\u00045\n\u0005%\u0004\"\u0001B+oSRDqa\u001b3\u0002\u0002\u0003\u0007\u0011-A\u0002yIEBa!\u001c\u0001!B\u0013\t\u0017AC:dQ\u0016$W\u000f\\3eA!9q\u000e\u0001a\u0001\n\u0013\u0001\u0017aB:u_B\u0004X\r\u001a\u0005\bc\u0002\u0001\r\u0011\"\u0003s\u0003-\u0019Ho\u001c9qK\u0012|F%Z9\u0015\u0005\u001d\u001c\bbB6q\u0003\u0003\u0005\r!\u0019\u0005\u0007k\u0002\u0001\u000b\u0015B1\u0002\u0011M$x\u000e\u001d9fI\u0002Bqa\u001e\u0001A\u0002\u0013%\u00010\u0001\u0007bY2\u001c6\r[3ek2,G-F\u0001z!\ty!0\u0003\u0002|!\t9!i\\8mK\u0006t\u0007bB?\u0001\u0001\u0004%IA`\u0001\u0011C2d7k\u00195fIVdW\rZ0%KF$\"aZ@\t\u000f-d\u0018\u0011!a\u0001s\"9\u00111\u0001\u0001!B\u0013I\u0018!D1mYN\u001b\u0007.\u001a3vY\u0016$\u0007\u0005C\u0004\u0002\b\u0001!I!!\u0003\u0002/%t7M]3nK:$8k\u00195fIVdW\rZ+tKJ\u001cH#A4\t\u000f\u00055\u0001\u0001\"\u0005\u0002\n\u0005y1/\u001a;BY2\u001c6\r[3ek2,G\rC\u0004\u0002\u0012\u0001!\t\"!\u0003\u0002+%t7M]3nK:$8\u000b^8qa\u0016$Wk]3sg\"9\u0011Q\u0003\u0001\u0005\n\u0005]\u0011!C:uCJ$Xk]3s)\r9\u0017\u0011\u0004\u0005\b\u00037\t\u0019\u00021\u00016\u0003\u0019)8/\u001a:JI\"9\u0011q\u0004\u0001\u0005\u0012\u0005\u0005\u0012AC5oU\u0016\u001cG/V:feR\u0019q-a\t\t\u0011\u0005\u0015\u0012Q\u0004a\u0001\u0003O\tQ\u0001Z3mCf\u0004B!!\u000b\u000225\u0011\u00111\u0006\u0006\u0005\u0003[\ty#\u0001\u0005ekJ\fG/[8o\u0015\ta\u0003#\u0003\u0003\u00024\u0005-\"A\u0004$j]&$X\rR;sCRLwN\u001c\u0005\u0007\u0003o\u0001A\u0011\u00031\u0002%\u001d,GoQ8oGV\u0014(/\u001a8u+N,'o\u001d\u0005\b\u0003w\u0001a\u0011AA\u001f\u0003-IgN[3di\n\u000bGo\u00195\u0015\u0007\u001d\fy\u0004\u0003\u0005\u0002B\u0005e\u0002\u0019AA\u0014\u0003-\u0011\u0017\r^2i/&tGm\\<\t\u000f\u0005\u0015\u0003A\"\u0001\u0002H\u00059QM\u001c3Vg\u0016\u0014HcA4\u0002J!A\u00111JA\"\u0001\u0004\ti%A\u0006vg\u0016\u0014X*Z:tC\u001e,\u0007\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005Mc)\u0001\u0004xe&$XM]\u0005\u0005\u0003/\n\tFA\u0006Vg\u0016\u0014X*Z:tC\u001e,\u0007BBA.\u0001\u0011\u0005\u00010A\njg\u0006cG.V:feN\u001c6\r[3ek2,G\r\u0003\u0004\u0002`\u0001!\t\u0001_\u0001\u0012SN\fE\u000e\\+tKJ\u001c8\u000b^8qa\u0016$\u0007")
public abstract class Workload
implements StrictLogging {
    private final Scenario scenario;
    private final AtomicLong userIdGen;
    private final ActorSystem system;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private int scheduled;
    private int stopped;
    private boolean allScheduled;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private int scheduled() {
        return this.scheduled;
    }

    private void scheduled_$eq(int x$1) {
        this.scheduled = x$1;
    }

    private int stopped() {
        return this.stopped;
    }

    private void stopped_$eq(int x$1) {
        this.stopped = x$1;
    }

    private boolean allScheduled() {
        return this.allScheduled;
    }

    private void allScheduled_$eq(boolean x$1) {
        this.allScheduled = x$1;
    }

    private void incrementScheduledUsers() {
        this.scheduled_$eq(this.scheduled() + 1);
    }

    public void setAllScheduled() {
        this.allScheduled_$eq(true);
    }

    public void incrementStoppedUsers() {
        this.stopped_$eq(this.stopped() + 1);
    }

    private void startUser(long userId) {
        BoxedUnit boxedUnit;
        String x$1 = this.scenario.name();
        long x$2 = userId;
        long x$3 = this.clock.nowMillis();
        Function1<Session, BoxedUnit> x$4 = this.scenario.onExit();
        Map<String, Object> x$5 = Session$.MODULE$.apply$default$4();
        long x$6 = Session$.MODULE$.apply$default$5();
        Status x$7 = Session$.MODULE$.apply$default$6();
        List<Block> x$8 = Session$.MODULE$.apply$default$7();
        Session rawSession = new Session(x$1, x$2, x$3, x$5, x$6, x$7, x$8, x$4);
        Session session = (Session)this.scenario.onStart().apply((Object)rawSession);
        this.scenario.entry().$bang(session);
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Start user #{}", new Object[]{BoxesRunTime.boxToLong((long)session.userId())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.statsEngine.logUser(new UserMessage(session, Start$.MODULE$, session.startDate()));
    }

    public void injectUser(FiniteDuration delay) {
        this.incrementScheduledUsers();
        long userId = this.userIdGen.incrementAndGet();
        if (delay.$less$eq((Object)Duration$.MODULE$.Zero())) {
            this.startUser(userId);
        } else {
            this.system.scheduler().scheduleOnce(delay, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.startUser(userId), (ExecutionContext)this.system.dispatcher());
        }
    }

    public int getConcurrentUsers() {
        return this.scheduled() - this.stopped();
    }

    public abstract void injectBatch(FiniteDuration var1);

    public abstract void endUser(UserMessage var1);

    public boolean isAllUsersScheduled() {
        return this.allScheduled();
    }

    public boolean isAllUsersStopped() {
        return this.allScheduled() && this.scheduled() == this.stopped();
    }

    public Workload(Scenario scenario, AtomicLong userIdGen, long startTime, ActorSystem system, StatsEngine statsEngine, Clock clock) {
        this.scenario = scenario;
        this.userIdGen = userIdGen;
        this.system = system;
        this.statsEngine = statsEngine;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.scheduled = 0;
        this.stopped = 0;
        this.allScheduled = false;
    }
}

