/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.core.feeder;

import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.feeder.FeederBuilder;
import io.gatling.core.feeder.FeederSupport;
import io.gatling.core.feeder.FeederWrapper;
import io.gatling.core.feeder.JsonFeederFileParser;
import io.gatling.core.feeder.RecordSeqFeederBuilder;
import io.gatling.core.feeder.RecordSeqFeederBuilder$;
import io.gatling.core.feeder.SeparatedValuesParser$;
import io.gatling.core.json.JsonParsers;
import io.gatling.core.util.Resource;
import io.gatling.core.util.Resource$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.compat.java8.JFunction1;

public abstract class FeederSupport$class {
    private static /* synthetic */ java.util.Map $deserializeLambdaCache$;

    public static RecordSeqFeederBuilder seq2FeederBuilder(FeederSupport $this, IndexedSeq data) {
        return new RecordSeqFeederBuilder(data, RecordSeqFeederBuilder$.MODULE$.apply$default$2());
    }

    public static RecordSeqFeederBuilder array2FeederBuilder(FeederSupport $this, Map[] data) {
        return new RecordSeqFeederBuilder(Predef$.MODULE$.wrapRefArray((Object[])data), RecordSeqFeederBuilder$.MODULE$.apply$default$2());
    }

    public static FeederBuilder feeder2FeederBuilder(FeederSupport $this, Iterator feeder) {
        return new FeederWrapper(feeder);
    }

    public static RecordSeqFeederBuilder csv(FeederSupport $this, String fileName, char quoteChar, char escapeChar, GatlingConfiguration configuration) {
        return $this.separatedValues(fileName, SeparatedValuesParser$.MODULE$.CommaSeparator(), quoteChar, escapeChar, configuration);
    }

    public static char csv$default$2(FeederSupport $this) {
        return '\"';
    }

    public static char csv$default$3(FeederSupport $this) {
        return '\u0000';
    }

    public static RecordSeqFeederBuilder ssv(FeederSupport $this, String fileName, char quoteChar, char escapeChar, GatlingConfiguration configuration) {
        return $this.separatedValues(fileName, SeparatedValuesParser$.MODULE$.SemicolonSeparator(), quoteChar, escapeChar, configuration);
    }

    public static char ssv$default$2(FeederSupport $this) {
        return '\"';
    }

    public static char ssv$default$3(FeederSupport $this) {
        return '\u0000';
    }

    public static RecordSeqFeederBuilder tsv(FeederSupport $this, String fileName, char quoteChar, char escapeChar, GatlingConfiguration configuration) {
        return $this.separatedValues(fileName, SeparatedValuesParser$.MODULE$.TabulationSeparator(), quoteChar, escapeChar, configuration);
    }

    public static char tsv$default$2(FeederSupport $this) {
        return '\"';
    }

    public static char tsv$default$3(FeederSupport $this) {
        return '\u0000';
    }

    public static RecordSeqFeederBuilder separatedValues(FeederSupport $this, String fileName, char separator, char quoteChar, char escapeChar, GatlingConfiguration configuration) {
        return $this.separatedValues(Resource$.MODULE$.feeder(fileName, configuration), separator, quoteChar, escapeChar, configuration);
    }

    public static RecordSeqFeederBuilder separatedValues(FeederSupport $this, Validation resource, char separator, char quoteChar, char escapeChar, GatlingConfiguration configuration) {
        return $this.feederBuilder((Validation<Resource>)resource, (Function1)(JFunction1 & Serializable & scala.Serializable)x$1 -> SeparatedValuesParser$.MODULE$.parse((Resource)x$1, separator, quoteChar, escapeChar, configuration));
    }

    public static char separatedValues$default$3(FeederSupport $this) {
        return '\"';
    }

    public static char separatedValues$default$4(FeederSupport $this) {
        return '\u0000';
    }

    public static RecordSeqFeederBuilder jsonFile(FeederSupport $this, String fileName, GatlingConfiguration configuration, JsonParsers jsonParsers) {
        return $this.jsonFile(Resource$.MODULE$.feeder(fileName, configuration), jsonParsers);
    }

    public static RecordSeqFeederBuilder jsonFile(FeederSupport $this, Validation resource2, JsonParsers jsonParsers) {
        JsonFeederFileParser jsonFeederFileParser = new JsonFeederFileParser(jsonParsers);
        return $this.feederBuilder((Validation<Resource>)resource2, (Function1)(JFunction1 & Serializable & scala.Serializable)resource -> jsonFeederFileParser.parse((Resource)resource));
    }

    public static RecordSeqFeederBuilder feederBuilder(FeederSupport $this, Validation resource, Function1 recordParser) {
        Validation validation = resource;
        if (!(validation instanceof Success)) {
            if (validation instanceof Failure) {
                Failure failure = (Failure)validation;
                String message = failure.message();
                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not locate feeder file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message})));
            }
            throw new MatchError((Object)validation);
        }
        Success success = (Success)validation;
        Resource res = (Resource)success.value();
        RecordSeqFeederBuilder recordSeqFeederBuilder = new RecordSeqFeederBuilder((IndexedSeq)recordParser.apply((Object)res), RecordSeqFeederBuilder$.MODULE$.apply$default$2());
        return recordSeqFeederBuilder;
    }

    public static RecordSeqFeederBuilder jsonUrl(FeederSupport $this, String url, JsonParsers jsonParsers) {
        return new RecordSeqFeederBuilder<Object>(new JsonFeederFileParser(jsonParsers).url(url), RecordSeqFeederBuilder$.MODULE$.apply$default$2());
    }

    public static void $init$(FeederSupport $this) {
    }
}

