package io.fabric8.kubernetes.api.model.policy;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface RuntimeClassStrategyOptionsFluent<A extends RuntimeClassStrategyOptionsFluent<A>> extends Fluent<A> {


    public A addToAllowedRuntimeClassNames(int index,String item);
    public A setToAllowedRuntimeClassNames(int index,String item);
    public A addToAllowedRuntimeClassNames(String... items);
    public A addAllToAllowedRuntimeClassNames(Collection<String> items);
    public A removeFromAllowedRuntimeClassNames(String... items);
    public A removeAllFromAllowedRuntimeClassNames(Collection<String> items);
    public List<String> getAllowedRuntimeClassNames();
    public String getAllowedRuntimeClassName(int index);
    public String getFirstAllowedRuntimeClassName();
    public String getLastAllowedRuntimeClassName();
    public String getMatchingAllowedRuntimeClassName(Predicate<String> predicate);
    public Boolean hasMatchingAllowedRuntimeClassName(Predicate<String> predicate);
    public A withAllowedRuntimeClassNames(List<String> allowedRuntimeClassNames);
    public A withAllowedRuntimeClassNames(String... allowedRuntimeClassNames);
    public Boolean hasAllowedRuntimeClassNames();
    public A addNewAllowedRuntimeClassName(StringBuilder arg1);
    public A addNewAllowedRuntimeClassName(int[] arg1,int arg2,int arg3);
    public A addNewAllowedRuntimeClassName(char[] arg1);
    public A addNewAllowedRuntimeClassName(StringBuffer arg1);
    public A addNewAllowedRuntimeClassName(byte[] arg1,int arg2);
    public A addNewAllowedRuntimeClassName(byte[] arg1);
    public A addNewAllowedRuntimeClassName(char[] arg1,int arg2,int arg3);
    public A addNewAllowedRuntimeClassName(byte[] arg1,int arg2,int arg3);
    public A addNewAllowedRuntimeClassName(byte[] arg1,int arg2,int arg3,int arg4);
    public A addNewAllowedRuntimeClassName(String arg1);
    public String getDefaultRuntimeClassName();
    public A withDefaultRuntimeClassName(String defaultRuntimeClassName);
    public Boolean hasDefaultRuntimeClassName();
    public A withNewDefaultRuntimeClassName(StringBuilder arg1);
    public A withNewDefaultRuntimeClassName(int[] arg1,int arg2,int arg3);
    public A withNewDefaultRuntimeClassName(char[] arg1);
    public A withNewDefaultRuntimeClassName(StringBuffer arg1);
    public A withNewDefaultRuntimeClassName(byte[] arg1,int arg2);
    public A withNewDefaultRuntimeClassName(byte[] arg1);
    public A withNewDefaultRuntimeClassName(char[] arg1,int arg2,int arg3);
    public A withNewDefaultRuntimeClassName(byte[] arg1,int arg2,int arg3);
    public A withNewDefaultRuntimeClassName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewDefaultRuntimeClassName(String arg1);
}
