/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.gatewayapi.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.GatewayAddress;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.GatewayAddressBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.GatewayAddressFluent;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.GatewayStatus;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ListenerStatus;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ListenerStatusBuilder;
import io.fabric8.kubernetes.api.model.gatewayapi.v1beta1.ListenerStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class GatewayStatusFluent<A extends GatewayStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<GatewayAddressBuilder> addresses = new ArrayList();
    private List<Condition> conditions = new ArrayList<Condition>();
    private ArrayList<ListenerStatusBuilder> listeners = new ArrayList();
    private Map<String, Object> additionalProperties;

    public GatewayStatusFluent() {
    }

    public GatewayStatusFluent(GatewayStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GatewayStatus instance) {
        GatewayStatus gatewayStatus = instance = instance != null ? instance : new GatewayStatus();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withConditions(instance.getConditions());
            this.withListeners(instance.getListeners());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAddresses(int index, GatewayAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").add(index, builder);
            this.addresses.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToAddresses(int index, GatewayAddress item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
        if (index < 0 || index >= this.addresses.size()) {
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        } else {
            this._visitables.get((Object)"addresses").set(index, builder);
            this.addresses.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToAddresses(GatewayAddress ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToAddresses(Collection<GatewayAddress> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList();
        }
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get((Object)"addresses").add(builder);
            this.addresses.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(GatewayAddress ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAddresses(Collection<GatewayAddress> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (GatewayAddress item : items) {
            GatewayAddressBuilder builder = new GatewayAddressBuilder(item);
            this._visitables.get((Object)"addresses").remove((Object)builder);
            this.addresses.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromAddresses(Predicate<GatewayAddressBuilder> predicate) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        Iterator<GatewayAddressBuilder> each = this.addresses.iterator();
        List visitables = this._visitables.get((Object)"addresses");
        while (each.hasNext()) {
            GatewayAddressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<GatewayAddress> buildAddresses() {
        return this.addresses != null ? GatewayStatusFluent.build(this.addresses) : null;
    }

    public GatewayAddress buildAddress(int index) {
        return this.addresses.get(index).build();
    }

    public GatewayAddress buildFirstAddress() {
        return this.addresses.get(0).build();
    }

    public GatewayAddress buildLastAddress() {
        return this.addresses.get(this.addresses.size() - 1).build();
    }

    public GatewayAddress buildMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
        for (GatewayAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
        for (GatewayAddressBuilder item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<GatewayAddress> addresses) {
        if (this.addresses != null) {
            this._visitables.get((Object)"addresses").clear();
        }
        if (addresses != null) {
            this.addresses = new ArrayList();
            for (GatewayAddress item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(GatewayAddress ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (GatewayAddress item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public A addNewAddress(String type, String value) {
        return this.addToAddresses(new GatewayAddress(type, value));
    }

    public AddressesNested<A> addNewAddress() {
        return new AddressesNested(-1, null);
    }

    public AddressesNested<A> addNewAddressLike(GatewayAddress item) {
        return new AddressesNested(-1, item);
    }

    public AddressesNested<A> setNewAddressLike(int index, GatewayAddress item) {
        return new AddressesNested(index, item);
    }

    public AddressesNested<A> editAddress(int index) {
        if (this.addresses.size() <= index) {
            throw new RuntimeException("Can't edit addresses. Index exceeds size.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editFirstAddress() {
        if (this.addresses.size() == 0) {
            throw new RuntimeException("Can't edit first addresses. The list is empty.");
        }
        return this.setNewAddressLike(0, this.buildAddress(0));
    }

    public AddressesNested<A> editLastAddress() {
        int index = this.addresses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last addresses. The list is empty.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public AddressesNested<A> editMatchingAddress(Predicate<GatewayAddressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.addresses.size(); ++i) {
            if (!predicate.test(this.addresses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching addresses. No match found.");
        }
        return this.setNewAddressLike(index, this.buildAddress(index));
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public A addToListeners(int index, ListenerStatus item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
        if (index < 0 || index >= this.listeners.size()) {
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        } else {
            this._visitables.get((Object)"listeners").add(index, builder);
            this.listeners.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToListeners(int index, ListenerStatus item) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
        if (index < 0 || index >= this.listeners.size()) {
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        } else {
            this._visitables.get((Object)"listeners").set(index, builder);
            this.listeners.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToListeners(ListenerStatus ... items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToListeners(Collection<ListenerStatus> items) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get((Object)"listeners").add(builder);
            this.listeners.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromListeners(ListenerStatus ... items) {
        if (this.listeners == null) {
            return (A)((Object)this);
        }
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get((Object)"listeners").remove((Object)builder);
            this.listeners.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromListeners(Collection<ListenerStatus> items) {
        if (this.listeners == null) {
            return (A)((Object)this);
        }
        for (ListenerStatus item : items) {
            ListenerStatusBuilder builder = new ListenerStatusBuilder(item);
            this._visitables.get((Object)"listeners").remove((Object)builder);
            this.listeners.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromListeners(Predicate<ListenerStatusBuilder> predicate) {
        if (this.listeners == null) {
            return (A)((Object)this);
        }
        Iterator<ListenerStatusBuilder> each = this.listeners.iterator();
        List visitables = this._visitables.get((Object)"listeners");
        while (each.hasNext()) {
            ListenerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<ListenerStatus> buildListeners() {
        return this.listeners != null ? GatewayStatusFluent.build(this.listeners) : null;
    }

    public ListenerStatus buildListener(int index) {
        return this.listeners.get(index).build();
    }

    public ListenerStatus buildFirstListener() {
        return this.listeners.get(0).build();
    }

    public ListenerStatus buildLastListener() {
        return this.listeners.get(this.listeners.size() - 1).build();
    }

    public ListenerStatus buildMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        for (ListenerStatusBuilder item : this.listeners) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        for (ListenerStatusBuilder item : this.listeners) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withListeners(List<ListenerStatus> listeners) {
        if (this.listeners != null) {
            this._visitables.get((Object)"listeners").clear();
        }
        if (listeners != null) {
            this.listeners = new ArrayList();
            for (ListenerStatus item : listeners) {
                this.addToListeners(item);
            }
        } else {
            this.listeners = null;
        }
        return (A)((Object)this);
    }

    public A withListeners(ListenerStatus ... listeners) {
        if (this.listeners != null) {
            this.listeners.clear();
            this._visitables.remove((Object)"listeners");
        }
        if (listeners != null) {
            for (ListenerStatus item : listeners) {
                this.addToListeners(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasListeners() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public ListenersNested<A> addNewListener() {
        return new ListenersNested(-1, null);
    }

    public ListenersNested<A> addNewListenerLike(ListenerStatus item) {
        return new ListenersNested(-1, item);
    }

    public ListenersNested<A> setNewListenerLike(int index, ListenerStatus item) {
        return new ListenersNested(index, item);
    }

    public ListenersNested<A> editListener(int index) {
        if (this.listeners.size() <= index) {
            throw new RuntimeException("Can't edit listeners. Index exceeds size.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public ListenersNested<A> editFirstListener() {
        if (this.listeners.size() == 0) {
            throw new RuntimeException("Can't edit first listeners. The list is empty.");
        }
        return this.setNewListenerLike(0, this.buildListener(0));
    }

    public ListenersNested<A> editLastListener() {
        int index = this.listeners.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last listeners. The list is empty.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public ListenersNested<A> editMatchingListener(Predicate<ListenerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.listeners.size(); ++i) {
            if (!predicate.test(this.listeners.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching listeners. No match found.");
        }
        return this.setNewListenerLike(index, this.buildListener(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GatewayStatusFluent that = (GatewayStatusFluent)((Object)o);
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.listeners, that.listeners)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.conditions, this.listeners, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.listeners != null && !this.listeners.isEmpty()) {
            sb.append("listeners:");
            sb.append(this.listeners + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ListenersNested<N>
    extends ListenerStatusFluent<ListenersNested<N>>
    implements Nested<N> {
        ListenerStatusBuilder builder;
        int index;

        ListenersNested(int index, ListenerStatus item) {
            this.index = index;
            this.builder = new ListenerStatusBuilder(this, item);
        }

        public N and() {
            return (N)GatewayStatusFluent.this.setToListeners(this.index, this.builder.build());
        }

        public N endListener() {
            return this.and();
        }
    }

    public class AddressesNested<N>
    extends GatewayAddressFluent<AddressesNested<N>>
    implements Nested<N> {
        GatewayAddressBuilder builder;
        int index;

        AddressesNested(int index, GatewayAddress item) {
            this.index = index;
            this.builder = new GatewayAddressBuilder(this, item);
        }

        public N and() {
            return (N)GatewayStatusFluent.this.setToAddresses(this.index, this.builder.build());
        }

        public N endAddress() {
            return this.and();
        }
    }
}

