/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsBuilder;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsFluent;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaPropsOrArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class JSONSchemaPropsOrArrayFluent<A extends JSONSchemaPropsOrArrayFluent<A>>
extends BaseFluent<A> {
    private ArrayList<JSONSchemaPropsBuilder> jSONSchemas = new ArrayList();
    private JSONSchemaPropsBuilder schema;
    private Map<String, Object> additionalProperties;

    public JSONSchemaPropsOrArrayFluent() {
    }

    public JSONSchemaPropsOrArrayFluent(JSONSchemaPropsOrArray instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(JSONSchemaPropsOrArray instance) {
        JSONSchemaPropsOrArray jSONSchemaPropsOrArray = instance = instance != null ? instance : new JSONSchemaPropsOrArray();
        if (instance != null) {
            this.withJSONSchemas(instance.getJSONSchemas());
            this.withSchema(instance.getSchema());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToJSONSchemas(int index, JSONSchemaProps item) {
        if (this.jSONSchemas == null) {
            this.jSONSchemas = new ArrayList();
        }
        JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
        if (index < 0 || index >= this.jSONSchemas.size()) {
            this._visitables.get((Object)"jSONSchemas").add(builder);
            this.jSONSchemas.add(builder);
        } else {
            this._visitables.get((Object)"jSONSchemas").add(builder);
            this.jSONSchemas.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToJSONSchemas(int index, JSONSchemaProps item) {
        if (this.jSONSchemas == null) {
            this.jSONSchemas = new ArrayList();
        }
        JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
        if (index < 0 || index >= this.jSONSchemas.size()) {
            this._visitables.get((Object)"jSONSchemas").add(builder);
            this.jSONSchemas.add(builder);
        } else {
            this._visitables.get((Object)"jSONSchemas").add(builder);
            this.jSONSchemas.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToJSONSchemas(JSONSchemaProps ... items) {
        if (this.jSONSchemas == null) {
            this.jSONSchemas = new ArrayList();
        }
        for (JSONSchemaProps item : items) {
            JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
            this._visitables.get((Object)"jSONSchemas").add(builder);
            this.jSONSchemas.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToJSONSchemas(Collection<JSONSchemaProps> items) {
        if (this.jSONSchemas == null) {
            this.jSONSchemas = new ArrayList();
        }
        for (JSONSchemaProps item : items) {
            JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
            this._visitables.get((Object)"jSONSchemas").add(builder);
            this.jSONSchemas.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromJSONSchemas(JSONSchemaProps ... items) {
        if (this.jSONSchemas == null) {
            return (A)((Object)this);
        }
        for (JSONSchemaProps item : items) {
            JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
            this._visitables.get((Object)"jSONSchemas").remove((Object)builder);
            this.jSONSchemas.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromJSONSchemas(Collection<JSONSchemaProps> items) {
        if (this.jSONSchemas == null) {
            return (A)((Object)this);
        }
        for (JSONSchemaProps item : items) {
            JSONSchemaPropsBuilder builder = new JSONSchemaPropsBuilder(item);
            this._visitables.get((Object)"jSONSchemas").remove((Object)builder);
            this.jSONSchemas.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromJSONSchemas(Predicate<JSONSchemaPropsBuilder> predicate) {
        if (this.jSONSchemas == null) {
            return (A)((Object)this);
        }
        Iterator<JSONSchemaPropsBuilder> each = this.jSONSchemas.iterator();
        List visitables = this._visitables.get((Object)"jSONSchemas");
        while (each.hasNext()) {
            JSONSchemaPropsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<JSONSchemaProps> buildJSONSchemas() {
        return this.jSONSchemas != null ? JSONSchemaPropsOrArrayFluent.build(this.jSONSchemas) : null;
    }

    public JSONSchemaProps buildJSONSchema(int index) {
        return this.jSONSchemas.get(index).build();
    }

    public JSONSchemaProps buildFirstJSONSchema() {
        return this.jSONSchemas.get(0).build();
    }

    public JSONSchemaProps buildLastJSONSchema() {
        return this.jSONSchemas.get(this.jSONSchemas.size() - 1).build();
    }

    public JSONSchemaProps buildMatchingJSONSchema(Predicate<JSONSchemaPropsBuilder> predicate) {
        for (JSONSchemaPropsBuilder item : this.jSONSchemas) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingJSONSchema(Predicate<JSONSchemaPropsBuilder> predicate) {
        for (JSONSchemaPropsBuilder item : this.jSONSchemas) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withJSONSchemas(List<JSONSchemaProps> jSONSchemas) {
        if (this.jSONSchemas != null) {
            this._visitables.get((Object)"jSONSchemas").clear();
        }
        if (jSONSchemas != null) {
            this.jSONSchemas = new ArrayList();
            for (JSONSchemaProps item : jSONSchemas) {
                this.addToJSONSchemas(item);
            }
        } else {
            this.jSONSchemas = null;
        }
        return (A)((Object)this);
    }

    public A withJSONSchemas(JSONSchemaProps ... jSONSchemas) {
        if (this.jSONSchemas != null) {
            this.jSONSchemas.clear();
            this._visitables.remove((Object)"jSONSchemas");
        }
        if (jSONSchemas != null) {
            for (JSONSchemaProps item : jSONSchemas) {
                this.addToJSONSchemas(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasJSONSchemas() {
        return this.jSONSchemas != null && !this.jSONSchemas.isEmpty();
    }

    public JSONSchemasNested<A> addNewJSONSchema() {
        return new JSONSchemasNested(-1, null);
    }

    public JSONSchemasNested<A> addNewJSONSchemaLike(JSONSchemaProps item) {
        return new JSONSchemasNested(-1, item);
    }

    public JSONSchemasNested<A> setNewJSONSchemaLike(int index, JSONSchemaProps item) {
        return new JSONSchemasNested(index, item);
    }

    public JSONSchemasNested<A> editJSONSchema(int index) {
        if (this.jSONSchemas.size() <= index) {
            throw new RuntimeException("Can't edit jSONSchemas. Index exceeds size.");
        }
        return this.setNewJSONSchemaLike(index, this.buildJSONSchema(index));
    }

    public JSONSchemasNested<A> editFirstJSONSchema() {
        if (this.jSONSchemas.size() == 0) {
            throw new RuntimeException("Can't edit first jSONSchemas. The list is empty.");
        }
        return this.setNewJSONSchemaLike(0, this.buildJSONSchema(0));
    }

    public JSONSchemasNested<A> editLastJSONSchema() {
        int index = this.jSONSchemas.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last jSONSchemas. The list is empty.");
        }
        return this.setNewJSONSchemaLike(index, this.buildJSONSchema(index));
    }

    public JSONSchemasNested<A> editMatchingJSONSchema(Predicate<JSONSchemaPropsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.jSONSchemas.size(); ++i) {
            if (!predicate.test(this.jSONSchemas.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching jSONSchemas. No match found.");
        }
        return this.setNewJSONSchemaLike(index, this.buildJSONSchema(index));
    }

    public JSONSchemaProps buildSchema() {
        return this.schema != null ? this.schema.build() : null;
    }

    public A withSchema(JSONSchemaProps schema) {
        this._visitables.remove((Object)"schema");
        if (schema != null) {
            this.schema = new JSONSchemaPropsBuilder(schema);
            this._visitables.get((Object)"schema").add(this.schema);
        } else {
            this.schema = null;
            this._visitables.get((Object)"schema").remove((Object)this.schema);
        }
        return (A)((Object)this);
    }

    public boolean hasSchema() {
        return this.schema != null;
    }

    public SchemaNested<A> withNewSchema() {
        return new SchemaNested(null);
    }

    public SchemaNested<A> withNewSchemaLike(JSONSchemaProps item) {
        return new SchemaNested(item);
    }

    public SchemaNested<A> editSchema() {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(null));
    }

    public SchemaNested<A> editOrNewSchema() {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(new JSONSchemaPropsBuilder().build()));
    }

    public SchemaNested<A> editOrNewSchemaLike(JSONSchemaProps item) {
        return this.withNewSchemaLike(Optional.ofNullable(this.buildSchema()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JSONSchemaPropsOrArrayFluent that = (JSONSchemaPropsOrArrayFluent)((Object)o);
        if (!Objects.equals(this.jSONSchemas, that.jSONSchemas)) {
            return false;
        }
        if (!Objects.equals((Object)this.schema, (Object)that.schema)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.jSONSchemas, this.schema, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jSONSchemas != null && !this.jSONSchemas.isEmpty()) {
            sb.append("jSONSchemas:");
            sb.append(String.valueOf(this.jSONSchemas) + ",");
        }
        if (this.schema != null) {
            sb.append("schema:");
            sb.append(String.valueOf((Object)this.schema) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SchemaNested<N>
    extends JSONSchemaPropsFluent<SchemaNested<N>>
    implements Nested<N> {
        JSONSchemaPropsBuilder builder;

        SchemaNested(JSONSchemaProps item) {
            this.builder = new JSONSchemaPropsBuilder(this, item);
        }

        public N and() {
            return (N)JSONSchemaPropsOrArrayFluent.this.withSchema(this.builder.build());
        }

        public N endSchema() {
            return this.and();
        }
    }

    public class JSONSchemasNested<N>
    extends JSONSchemaPropsFluent<JSONSchemasNested<N>>
    implements Nested<N> {
        JSONSchemaPropsBuilder builder;
        int index;

        JSONSchemasNested(int index, JSONSchemaProps item) {
            this.index = index;
            this.builder = new JSONSchemaPropsBuilder(this, item);
        }

        public N and() {
            return (N)JSONSchemaPropsOrArrayFluent.this.setToJSONSchemas(this.index, this.builder.build());
        }

        public N endJSONSchema() {
            return this.and();
        }
    }
}

