
                                          

package io.fabric8.kubernetes.client.handlers.core.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.core.v1.EndpointsOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class EndpointsHandler implements ResourceHandler<Endpoints, EndpointsBuilder> {

  @Override
  public String getKind() {
    return Endpoints.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "v1";
      }

  @Override
  public Endpoints create(OkHttpClient client, Config config, String namespace, Endpoints item, boolean dryRun) {
    return new EndpointsOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public Endpoints replace(OkHttpClient client, Config config, String namespace, Endpoints item, boolean dryRun) {
    return new EndpointsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public Endpoints reload(OkHttpClient client, Config config, String namespace, Endpoints item) {
    return new EndpointsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public EndpointsBuilder edit(Endpoints item) {
    return new EndpointsBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Endpoints item, boolean dryRun) {
    return new EndpointsOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Endpoints item, Watcher<Endpoints> watcher) {
    return new EndpointsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Endpoints item, String resourceVersion, Watcher<Endpoints> watcher) {
    return new EndpointsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Endpoints item, ListOptions options, Watcher<Endpoints> watcher) {
    return new EndpointsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public Endpoints waitUntilReady(OkHttpClient client, Config config, String namespace, Endpoints item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new EndpointsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Endpoints waitUntilCondition(OkHttpClient client, Config config, String namespace, Endpoints item, Predicate<Endpoints> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new EndpointsOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
