/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.service.helper;

import com.google.gson.JsonObject;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.util.DockerFileUtil;
import io.fabric8.maven.docker.util.Logger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class BuildArgResolver {
    private static final String ARG_PREFIX = "docker.buildArg.";
    private final Logger log;

    public BuildArgResolver(Logger log) {
        this.log = log;
    }

    public Map<String, String> resolveBuildArgs(BuildService.BuildContext buildContext) {
        Map<String, String> buildArgsFromProject = this.addBuildArgsFromProperties(buildContext.getMojoParameters().getProject().getProperties());
        Map<String, String> buildArgsFromSystem = this.addBuildArgsFromProperties(System.getProperties());
        Map<String, String> buildArgsFromDockerConfig = this.addBuildArgsFromDockerConfig();
        return BuildArgResolver.mergeBuildArgsFrom(buildArgsFromDockerConfig, buildContext.getBuildArgs() != null ? buildContext.getBuildArgs() : Collections.emptyMap(), buildArgsFromProject, buildArgsFromSystem);
    }

    private Map<String, String> addBuildArgsFromProperties(Properties properties) {
        HashMap<String, String> buildArgs = new HashMap<String, String>();
        for (Object keyObj : properties.keySet()) {
            String key = (String)keyObj;
            if (!key.startsWith(ARG_PREFIX)) continue;
            String argKey = key.replaceFirst(ARG_PREFIX, "");
            String value = properties.getProperty(key);
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            buildArgs.put(argKey, value);
        }
        this.log.debug("Build args set %s", buildArgs);
        return buildArgs;
    }

    private Map<String, String> addBuildArgsFromDockerConfig() {
        JsonObject proxies;
        JsonObject dockerConfig = DockerFileUtil.readDockerConfig();
        if (dockerConfig == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> buildArgs = new HashMap<String, String>();
        if (dockerConfig.has("proxies") && (proxies = dockerConfig.getAsJsonObject("proxies")).has("default")) {
            JsonObject defaultProxyObj = proxies.getAsJsonObject("default");
            String[] proxyMapping = new String[]{"httpProxy", "http_proxy", "httpsProxy", "https_proxy", "noProxy", "no_proxy", "ftpProxy", "ftp_proxy"};
            for (int index = 0; index < proxyMapping.length; index += 2) {
                if (!defaultProxyObj.has(proxyMapping[index])) continue;
                buildArgs.put(proxyMapping[index + 1], defaultProxyObj.get(proxyMapping[index]).getAsString());
            }
        }
        this.log.debug("Build args set %s", buildArgs);
        return buildArgs;
    }

    @SafeVarargs
    private static Map<String, String> mergeBuildArgsFrom(Map<String, String> ... buildArgSources) {
        HashMap<String, String> buildArgs = new HashMap<String, String>();
        Stream.of(buildArgSources).filter(Objects::nonNull).flatMap(map -> map.entrySet().stream()).forEach(entry -> buildArgs.put((String)entry.getKey(), (String)entry.getValue()));
        return buildArgs;
    }
}

