/*
 * Decompiled with CFR 0.152.
 */
package io.coodoo.framework.listing.control;

import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ListingUtil {
    private ListingUtil() {
    }

    public static List<Field> getFields(Class<?> targetClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> inheritanceClass = targetClass; inheritanceClass != null; inheritanceClass = inheritanceClass.getSuperclass()) {
            fields.addAll(Arrays.asList(inheritanceClass.getDeclaredFields()));
        }
        return fields;
    }

    public static String likeValue(String value) {
        return "%" + value.toLowerCase() + "%";
    }

    public static boolean isQuoted(String value) {
        return value.startsWith("\"") && value.endsWith("\"");
    }

    public static String removeQuotes(String value) {
        return value.replaceAll("^\"|\"$", "");
    }

    public static List<String> split(String value) {
        return Arrays.asList(value.split("\\|", -1));
    }

    public static LocalDateTime parseFilterDate(String dateString, boolean end) {
        Matcher yearMatcher = Pattern.compile("^(\\d{4})$").matcher(dateString);
        if (yearMatcher.find()) {
            LocalDateTime date = LocalDateTime.of((int)Integer.valueOf(yearMatcher.group(1)), 1, 1, 0, 0, 0);
            if (end) {
                return date.plusYears(1L).minusSeconds(1L);
            }
            return date;
        }
        Matcher monthYearMatcher = Pattern.compile("^(\\d{1,2})\\.(\\d{4})$").matcher(dateString);
        if (monthYearMatcher.find()) {
            LocalDateTime date = LocalDateTime.of((int)Integer.valueOf(monthYearMatcher.group(2)), Integer.valueOf(monthYearMatcher.group(1)), 1, 0, 0, 0);
            if (end) {
                return date.plusMonths(1L).minusSeconds(1L);
            }
            return date;
        }
        Matcher dayMonthYearMatcher = Pattern.compile("^(\\d{1,2})\\.(\\d{1,2})\\.(\\d{4})$").matcher(dateString);
        if (dayMonthYearMatcher.find()) {
            LocalDateTime date = LocalDateTime.of((int)Integer.valueOf(dayMonthYearMatcher.group(3)), Integer.valueOf(dayMonthYearMatcher.group(2)), (int)Integer.valueOf(dayMonthYearMatcher.group(1)), 0, 0, 0);
            if (end) {
                return date.plusDays(1L).minusSeconds(1L);
            }
            return date;
        }
        return null;
    }
}

