/*
 * Decompiled with CFR 0.152.
 */
package coil.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Build;
import android.util.Log;
import androidx.core.content.ContextCompat;
import coil.network.EmptyNetworkObserverStrategy;
import coil.network.NetworkObserverStrategyApi14;
import coil.network.NetworkObserverStrategyApi21;
import coil.util.CoilLogger;
import coil.util.LogsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b`\u0018\u0000 \u00072\u00020\u0001:\u0002\u0007\bJ\b\u0010\u0002\u001a\u00020\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\t"}, d2={"Lcoil/network/NetworkObserverStrategy;", "", "isOnline", "", "start", "", "stop", "Companion", "Listener", "coil-base_release"})
public interface NetworkObserverStrategy {
    public static final Companion Companion = coil.network.NetworkObserverStrategy$Companion.$$INSTANCE;

    public void start();

    public void stop();

    public boolean isOnline();

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcoil/network/NetworkObserverStrategy$Listener;", "", "onConnectivityChange", "", "isOnline", "", "coil-base_release"})
    public static interface Listener {
        public void onConnectivityChange(boolean var1);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0086\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcoil/network/NetworkObserverStrategy$Companion;", "", "()V", "TAG", "", "invoke", "Lcoil/network/NetworkObserverStrategy;", "context", "Landroid/content/Context;", "listener", "Lcoil/network/NetworkObserverStrategy$Listener;", "coil-base_release"})
    public static final class Companion {
        private static final String TAG = "NetworkObserverStrategy";
        static final /* synthetic */ Companion $$INSTANCE;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final NetworkObserverStrategy invoke(@NotNull Context context, @NotNull Listener listener2) {
            NetworkObserverStrategy networkObserverStrategy;
            ConnectivityManager connectivityManager;
            block7: {
                String $this$isPermissionGranted$iv;
                block6: {
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    Intrinsics.checkParameterIsNotNull((Object)listener2, (String)"listener");
                    Context $this$getSystemService$iv = context;
                    boolean $i$f$getSystemService = false;
                    connectivityManager = (ConnectivityManager)ContextCompat.getSystemService((Context)$this$getSystemService$iv, ConnectivityManager.class);
                    if (connectivityManager == null) break block6;
                    $this$getSystemService$iv = context;
                    String permission$iv = "android.permission.ACCESS_NETWORK_STATE";
                    boolean $i$f$isPermissionGranted = false;
                    if (ContextCompat.checkSelfPermission((Context)$this$isPermissionGranted$iv, (String)permission$iv) == 0) break block7;
                }
                $this$isPermissionGranted$iv = TAG;
                int priority$iv = 5;
                boolean $i$f$log = false;
                if (CoilLogger.INSTANCE.getEnabled$coil_base_release() && CoilLogger.INSTANCE.getLevel$coil_base_release() <= priority$iv) {
                    void tag$iv;
                    void var9_9 = tag$iv;
                    int n = priority$iv;
                    boolean bl = false;
                    String string = "Unable to register network observer.";
                    Log.println((int)n, (String)var9_9, (String)string);
                }
                return EmptyNetworkObserverStrategy.INSTANCE;
            }
            try {
                networkObserverStrategy = Build.VERSION.SDK_INT >= 21 ? (NetworkObserverStrategy)new NetworkObserverStrategyApi21(connectivityManager, listener2) : (NetworkObserverStrategy)new NetworkObserverStrategyApi14(context, connectivityManager, listener2);
            }
            catch (Exception e) {
                LogsKt.log(TAG, new RuntimeException("Failed to register network observer.", e));
                networkObserverStrategy = EmptyNetworkObserverStrategy.INSTANCE;
            }
            return networkObserverStrategy;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

