/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.v02;

import io.cloudevents.Builder;
import io.cloudevents.CloudEvent;
import io.cloudevents.extensions.ExtensionFormat;
import io.cloudevents.fun.EventBuilder;
import io.cloudevents.v02.Accessor;
import io.cloudevents.v02.AttributesImpl;
import io.cloudevents.v02.CloudEventImpl;
import java.net.URI;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.Validation;
import javax.validation.Validator;

public class CloudEventBuilder<T>
implements EventBuilder<T, AttributesImpl>,
Builder<AttributesImpl, T> {
    private static Validator VALIDATOR;
    private static final String SPEC_VERSION = "0.2";
    private static final String MESSAGE_SEPARATOR = ", ";
    private static final String MESSAGE = "'%s' %s";
    private static final String ERR_MESSAGE = "invalid payload: %s";
    private String type;
    private String id;
    private URI source;
    private ZonedDateTime time;
    private URI schemaurl;
    private String contenttype;
    private T data;
    private final Set<ExtensionFormat> extensions = new HashSet<ExtensionFormat>();
    private Validator validator;

    private CloudEventBuilder() {
    }

    private static Validator getValidator() {
        if (null == VALIDATOR) {
            VALIDATOR = Validation.buildDefaultValidatorFactory().getValidator();
        }
        return VALIDATOR;
    }

    public static <T> CloudEventBuilder<T> builder() {
        return new CloudEventBuilder<T>();
    }

    public static <T> CloudEventBuilder<T> builder(CloudEvent<AttributesImpl, T> base) {
        Objects.requireNonNull(base);
        CloudEventBuilder<T> result = new CloudEventBuilder<T>();
        AttributesImpl attributes = base.getAttributes();
        result.withId(attributes.getId()).withSource(attributes.getSource()).withType(attributes.getType());
        attributes.getTime().ifPresent(result::withTime);
        attributes.getSchemaurl().ifPresent(result::withSchemaurl);
        attributes.getContenttype().ifPresent(result::withContenttype);
        Accessor.extensionsOf(base).forEach(result::withExtension);
        base.getData().ifPresent(result::withData);
        return result;
    }

    public static <T> CloudEventImpl<T> of(T data, AttributesImpl attributes, Collection<ExtensionFormat> extensions, Validator validator) {
        CloudEventBuilder<T> builder = new CloudEventBuilder<T>().withId(attributes.getId()).withSource(attributes.getSource()).withType(attributes.getType());
        attributes.getTime().ifPresent(builder::withTime);
        attributes.getSchemaurl().ifPresent(builder::withSchemaurl);
        attributes.getContenttype().ifPresent(builder::withContenttype);
        extensions.forEach(builder::withExtension);
        return builder.withData(data).withValidator(validator).build();
    }

    @Override
    public CloudEvent<AttributesImpl, T> build(T data, AttributesImpl attributes, Collection<ExtensionFormat> extensions) {
        return CloudEventBuilder.of(data, attributes, extensions, this.validator);
    }

    public CloudEventImpl<T> build() {
        AttributesImpl attributes = new AttributesImpl(this.type, SPEC_VERSION, this.source, this.id, this.time, this.schemaurl, this.contenttype);
        CloudEventImpl<T> event = new CloudEventImpl<T>(attributes, this.data, this.extensions);
        if (this.validator == null) {
            this.validator = CloudEventBuilder.getValidator();
        }
        Set violations = this.validator.validate(event, new Class[0]);
        violations.addAll(this.validator.validate((Object)event.getAttributes(), new Class[0]));
        String errs = violations.stream().map(v -> String.format(MESSAGE, v.getPropertyPath(), v.getMessage())).collect(Collectors.joining(MESSAGE_SEPARATOR));
        Optional.ofNullable("".equals(errs) ? null : errs).ifPresent(e -> {
            throw new IllegalStateException(String.format(ERR_MESSAGE, e));
        });
        return event;
    }

    public CloudEventBuilder<T> withType(String type) {
        this.type = type;
        return this;
    }

    public CloudEventBuilder<T> withId(String id) {
        this.id = id;
        return this;
    }

    public CloudEventBuilder<T> withSource(URI source) {
        this.source = source;
        return this;
    }

    public CloudEventBuilder<T> withTime(ZonedDateTime time) {
        this.time = time;
        return this;
    }

    public CloudEventBuilder<T> withSchemaurl(URI schemaurl) {
        this.schemaurl = schemaurl;
        return this;
    }

    public CloudEventBuilder<T> withContenttype(String contenttype) {
        this.contenttype = contenttype;
        return this;
    }

    public CloudEventBuilder<T> withData(T data) {
        this.data = data;
        return this;
    }

    public CloudEventBuilder<T> withExtension(ExtensionFormat extension) {
        this.extensions.add(extension);
        return this;
    }

    public CloudEventBuilder<T> withValidator(Validator validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public <TT> CloudEvent<AttributesImpl, TT> build(CloudEvent<AttributesImpl, T> base, String id, TT newData) {
        return this.build(base, id, newData, null);
    }

    public <TT> CloudEvent<AttributesImpl, TT> build(CloudEvent<AttributesImpl, T> base, String id, TT newData, Validator validator) {
        Objects.requireNonNull(base);
        AttributesImpl attributes = base.getAttributes();
        CloudEventBuilder<TT> builder = new CloudEventBuilder<T>().withId(id).withSource(attributes.getSource()).withType(attributes.getType());
        attributes.getTime().ifPresent(builder::withTime);
        attributes.getSchemaurl().ifPresent(builder::withSchemaurl);
        attributes.getContenttype().ifPresent(builder::withContenttype);
        Collection<ExtensionFormat> extensions = Accessor.extensionsOf(base);
        extensions.forEach(builder::withExtension);
        return builder.withData(newData).withValidator(validator).build();
    }
}

