/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.internal.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import reactor.core.publisher.FluxSink;

final class ReadCompletionHandler
implements CompletionHandler<Integer, ByteBuf> {
    private final AsynchronousFileChannel channel;
    private final ByteBufAllocator allocator;
    private final int bufferSize;
    private final FluxSink<ByteBuf> sink;
    private final AtomicLong position;
    private final AtomicReference<State> state = new AtomicReference<State>(State.IDLE);

    ReadCompletionHandler(AsynchronousFileChannel channel, ByteBufAllocator allocator, int bufferSize, FluxSink<ByteBuf> sink) {
        this.channel = channel;
        this.allocator = allocator;
        this.bufferSize = bufferSize;
        this.sink = sink;
        this.position = new AtomicLong(0L);
    }

    public void request(long ignored) {
        this.tryRead();
    }

    public void cancel() {
        this.state.getAndSet(State.DISPOSED);
        this.tryCloseChannel();
    }

    private void tryRead() {
        if (this.sink.requestedFromDownstream() > 0L && this.state.compareAndSet(State.IDLE, State.READING)) {
            this.read();
        }
    }

    private void read() {
        ByteBuf buf = this.allocator.ioBuffer(this.bufferSize);
        ByteBuffer byteBuffer = buf.nioBuffer(buf.writerIndex(), buf.writableBytes());
        this.channel.read(byteBuffer, this.position.get(), buf, this);
    }

    @Override
    public void completed(Integer read, ByteBuf buf) {
        if (State.DISPOSED.equals((Object)this.state.get())) {
            buf.release();
            this.tryCloseChannel();
            return;
        }
        if (read == -1) {
            buf.release();
            this.tryCloseChannel();
            this.state.set(State.DISPOSED);
            this.sink.complete();
            return;
        }
        this.position.addAndGet(read.intValue());
        buf.writerIndex(read.intValue());
        this.sink.next((Object)buf);
        if (this.sink.requestedFromDownstream() > 0L) {
            this.read();
            return;
        }
        if (this.state.compareAndSet(State.READING, State.IDLE)) {
            this.tryRead();
        }
    }

    @Override
    public void failed(Throwable exc, ByteBuf buf) {
        buf.release();
        this.tryCloseChannel();
        this.state.set(State.DISPOSED);
        this.sink.error(exc);
    }

    void tryCloseChannel() {
        if (this.channel.isOpen()) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static enum State {
        IDLE,
        READING,
        DISPOSED;

    }
}

