/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.message.server.DecodeContext;
import io.asyncer.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import io.asyncer.r2dbc.mysql.message.server.EofMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import io.asyncer.r2dbc.mysql.message.server.SyntheticMetadataMessage;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.jetbrains.annotations.Nullable;

abstract class MetadataDecodeContext
implements DecodeContext {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MetadataDecodeContext.class);
    private final boolean eofDeprecated;

    MetadataDecodeContext(boolean eofDeprecated) {
        this.eofDeprecated = eofDeprecated;
    }

    abstract boolean isInMetadata();

    @Nullable
    final SyntheticMetadataMessage putPart(ServerMessage message) {
        if (message instanceof DefinitionMetadataMessage) {
            int index = this.putMetadata((DefinitionMetadataMessage)message);
            if (this.eofDeprecated) {
                SyntheticMetadataMessage bundle = this.checkComplete(index, null);
                if (bundle != null) {
                    logger.debug("Respond a metadata bundle by filled-up");
                }
                return bundle;
            }
            return null;
        }
        if (message instanceof EofMessage) {
            if (this.eofDeprecated) {
                throw new IllegalStateException("Unexpected " + message + " because server has deprecated EOF");
            }
            int currentIndex = this.currentIndex();
            SyntheticMetadataMessage bundle = this.checkComplete(currentIndex, (EofMessage)message);
            if (bundle == null) {
                if (logger.isErrorEnabled()) {
                    logger.error("Unexpected {} when metadata unfilled, fill index: {}, checkpoint(s): {}", new Object[]{message, currentIndex, this.loggingPoints()});
                }
            } else {
                logger.debug("Respond a metadata bundle by {}", (Object)message);
            }
            return bundle;
        }
        throw new IllegalStateException("Unknown message type " + message.getClass().getSimpleName() + " when reading metadata");
    }

    @Nullable
    protected abstract SyntheticMetadataMessage checkComplete(int var1, @Nullable EofMessage var2);

    protected abstract int putMetadata(DefinitionMetadataMessage var1);

    protected abstract int currentIndex();

    protected abstract Object loggingPoints();
}

