/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.internal.util;

import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.netty.buffer.ByteBuf;

public final class VarIntUtils {
    private static final int VAR_INT_1_BYTE_LIMIT = 250;
    private static final int VAR_INT_2_BYTE_LIMIT = 65535;
    private static final short VAR_INT_2_BYTE_CODE = 252;
    private static final int VAR_INT_3_BYTE_LIMIT = 0xFFFFFF;
    private static final short VAR_INT_3_BYTE_CODE = 253;
    static final short VAR_INT_8_BYTE_CODE = 254;
    private static final int MEDIUM_BYTES = 3;
    private static final int MEDIUM_SIZE = 24;

    public static long crossReadVarInt(ByteBuf firstPart, ByteBuf secondPart) {
        AssertUtils.requireNonNull(firstPart, "firstPart must not be null");
        AssertUtils.requireNonNull(secondPart, "secondPart must not be null");
        short firstByte = firstPart.readUnsignedByte();
        if (firstByte < 252) {
            return firstByte;
        }
        if (firstByte == 252) {
            int readable = firstPart.readableBytes();
            switch (readable) {
                case 0: {
                    return secondPart.readUnsignedShortLE();
                }
                case 1: {
                    return firstPart.readUnsignedByte() | secondPart.readUnsignedByte() << 8;
                }
            }
            return firstPart.readUnsignedShortLE();
        }
        if (firstByte == 253) {
            int readable = firstPart.readableBytes();
            switch (readable) {
                case 0: {
                    return secondPart.readUnsignedMediumLE();
                }
                case 1: {
                    return (long)firstPart.readUnsignedByte() | (long)secondPart.readUnsignedShortLE() << 8;
                }
                case 2: {
                    return (long)firstPart.readUnsignedShortLE() | (long)secondPart.readUnsignedByte() << 16;
                }
            }
            return firstPart.readUnsignedMediumLE();
        }
        return VarIntUtils.crossReadLong0(firstPart, secondPart);
    }

    public static long readVarInt(ByteBuf buf) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        short firstByte = buf.readUnsignedByte();
        if (firstByte < 252) {
            return firstByte;
        }
        if (firstByte == 252) {
            return buf.readUnsignedShortLE();
        }
        if (firstByte == 253) {
            return buf.readUnsignedMediumLE();
        }
        return buf.readLongLE();
    }

    public static int checkNextVarInt(ByteBuf buf) {
        int byteSize = AssertUtils.requireNonNull(buf, "buf must not be null").readableBytes();
        if (byteSize <= 0) {
            return -1;
        }
        short firstByte = buf.getUnsignedByte(buf.readerIndex());
        if (firstByte < 252) {
            return byteSize - 1;
        }
        if (firstByte == 252) {
            return byteSize - 3;
        }
        if (firstByte == 253) {
            return byteSize - 4;
        }
        if (firstByte == 254) {
            return byteSize - 9;
        }
        return -1;
    }

    public static int varIntBytes(int value) {
        if (value <= 250) {
            return 1;
        }
        if (value <= 65535) {
            return 3;
        }
        if (value <= 0xFFFFFF) {
            return 4;
        }
        return 9;
    }

    public static void reserveVarInt(ByteBuf buf) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        buf.writeZero(9);
    }

    public static ByteBuf setReservedVarInt(ByteBuf buf, int value) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        AssertUtils.require(value >= 0, "value must not be a negative integer");
        if (value <= 250) {
            int index = buf.readerIndex() + 8;
            return buf.setByte(index, value).skipBytes(8);
        }
        if (value <= 65535) {
            int index = buf.readerIndex() + 6;
            return buf.setByte(index, 252).setShortLE(index + 1, value).skipBytes(6);
        }
        if (value <= 0xFFFFFF) {
            int index = buf.readerIndex() + 5;
            return buf.setByte(index, 253).setMediumLE(index + 1, value).skipBytes(5);
        }
        int index = buf.readerIndex();
        return buf.setByte(index, 254).setLongLE(index + 1, (long)value);
    }

    public static void setReservedVarInt(ByteBuf buf, long value) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        AssertUtils.require(value >= 0L, "value must not be a negative integer");
        if (value <= 250L) {
            int index = buf.readerIndex() + 8;
            buf.setByte(index, (int)value).skipBytes(8);
        } else if (value <= 65535L) {
            int index = buf.readerIndex() + 6;
            buf.setByte(index, 252).setShortLE(index + 1, (int)value).skipBytes(6);
        } else if (value <= 0xFFFFFFL) {
            int index = buf.readerIndex() + 5;
            buf.setByte(index, 253).setMediumLE(index + 1, (int)value).skipBytes(5);
        } else {
            int index = buf.readerIndex();
            buf.setByte(index, 254).setLongLE(index + 1, value);
        }
    }

    public static void writeVarInt(ByteBuf buf, int value) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        AssertUtils.require(value >= 0, "value must not be a negative integer");
        if (value <= 250) {
            buf.writeByte(value);
        } else if (value <= 65535) {
            buf.writeByte(252).writeShortLE(value);
        } else if (value <= 0xFFFFFF) {
            buf.writeByte(253).writeMediumLE(value);
        } else {
            buf.writeByte(254).writeLongLE((long)value);
        }
    }

    public static void writeVarInt(ByteBuf buf, long value) {
        AssertUtils.requireNonNull(buf, "buf must not be null");
        AssertUtils.require(value >= 0L, "value must not be a negative integer");
        if (value <= 250L) {
            buf.writeByte((int)value);
        } else if (value <= 65535L) {
            buf.writeByte(252).writeShortLE((int)value);
        } else if (value <= 0xFFFFFFL) {
            buf.writeByte(253).writeMediumLE((int)value);
        } else {
            buf.writeByte(254).writeLongLE(value);
        }
    }

    private static long crossReadLong0(ByteBuf firstPart, ByteBuf secondPart) {
        int readable = firstPart.readableBytes();
        if (readable == 0) {
            return secondPart.readLongLE();
        }
        switch (readable) {
            case 1: {
                long low = firstPart.readUnsignedByte();
                long middle = secondPart.readUnsignedIntLE() << 8;
                long high = (long)secondPart.readUnsignedMediumLE() << 40;
                return high | middle | low;
            }
            case 2: {
                long low = firstPart.readUnsignedShortLE();
                long middle = secondPart.readUnsignedIntLE() << 16;
                long high = (long)secondPart.readUnsignedShortLE() << 48;
                return high | middle | low;
            }
            case 3: {
                long low = firstPart.readUnsignedMediumLE();
                long middle = secondPart.readUnsignedIntLE() << 24;
                long high = (long)secondPart.readUnsignedByte() << 56;
                return high | middle | low;
            }
            case 4: {
                long low = firstPart.readUnsignedIntLE();
                long high = secondPart.readUnsignedIntLE() << 32;
                return high | low;
            }
            case 5: {
                long low = firstPart.readUnsignedIntLE();
                long middle = (long)firstPart.readUnsignedByte() << 32;
                long high = (long)secondPart.readUnsignedMediumLE() << 40;
                return high | middle | low;
            }
            case 6: {
                long low = firstPart.readUnsignedIntLE();
                long middle = (long)firstPart.readUnsignedShortLE() << 32;
                long high = (long)secondPart.readUnsignedShortLE() << 48;
                return high | middle | low;
            }
            case 7: {
                long low = firstPart.readUnsignedIntLE();
                long middle = (long)firstPart.readUnsignedMediumLE() << 32;
                long high = (long)secondPart.readUnsignedByte() << 56;
                return high | middle | low;
            }
        }
        return firstPart.readLongLE();
    }

    private VarIntUtils() {
    }
}

