/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.internal.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

final class CumulateEnvelopeSubscriber
implements CoreSubscriber<ByteBuf>,
Scannable,
Subscription {
    private final CoreSubscriber<? super ByteBuf> actual;
    private final ByteBufAllocator alloc;
    private final int size;
    private final AtomicInteger sequenceId;
    private boolean done;
    private Subscription s;
    private ByteBuf cumulated;

    CumulateEnvelopeSubscriber(CoreSubscriber<? super ByteBuf> actual, ByteBufAllocator alloc, int size, AtomicInteger sequenceId) {
        this.actual = actual;
        this.alloc = alloc;
        this.size = size;
        this.sequenceId = sequenceId;
    }

    public void onSubscribe(Subscription s) {
        if (Operators.validate((Subscription)this.s, (Subscription)s)) {
            this.s = s;
            this.actual.onSubscribe((Subscription)this);
        }
    }

    public void onNext(ByteBuf buf) {
        if (this.done) {
            Operators.onNextDropped((Object)buf, (Context)this.actual.currentContext());
            return;
        }
        if (!buf.isReadable()) {
            buf.release();
            return;
        }
        try {
            ByteBuf cumulated = this.cumulated = CumulateEnvelopeSubscriber.cumulate(this.alloc, this.cumulated, buf);
            while (cumulated.readableBytes() >= this.size) {
                this.actual.onNext((Object)this.alloc.ioBuffer(4).writeMediumLE(this.size).writeByte(this.sequenceId.getAndIncrement()));
                this.actual.onNext((Object)cumulated.readRetainedSlice(this.size));
            }
            if (!cumulated.isReadable()) {
                this.cumulated = null;
                cumulated.release();
            }
        }
        catch (Throwable e) {
            Throwable t = Operators.onNextError((Object)buf, (Throwable)e, (Context)this.actual.currentContext(), (Subscription)this.s);
            if (t == null) {
                this.s.request(1L);
            }
            this.onError(t);
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            Operators.onErrorDropped((Throwable)t, (Context)this.actual.currentContext());
            return;
        }
        this.done = true;
        ByteBuf cumulated = this.cumulated;
        if (cumulated != null) {
            cumulated.release();
        }
        this.actual.onError(t);
    }

    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        ByteBuf cumulated = this.cumulated;
        this.cumulated = null;
        int size = cumulated == null ? 0 : cumulated.readableBytes();
        ByteBuf header = null;
        try {
            header = this.alloc.ioBuffer(4);
            header.writeMediumLE(size).writeByte(this.sequenceId.getAndIncrement());
        }
        catch (Throwable e) {
            if (cumulated != null) {
                cumulated.release();
            }
            if (header != null) {
                header.release();
            }
            this.actual.onError(e);
            return;
        }
        this.actual.onNext((Object)header);
        if (cumulated != null) {
            if (size > 0) {
                this.actual.onNext((Object)cumulated);
            } else {
                cumulated.release();
            }
        }
        this.actual.onComplete();
    }

    public void request(long n) {
        this.s.request(n);
    }

    public void cancel() {
        this.s.cancel();
    }

    public Context currentContext() {
        return this.actual.currentContext();
    }

    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.PARENT) {
            return this.s;
        }
        if (key == Scannable.Attr.ACTUAL) {
            return this.actual;
        }
        if (key == Scannable.Attr.TERMINATED) {
            return this.done;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuf cumulate(ByteBufAllocator alloc, @Nullable ByteBuf cumulated, ByteBuf buf) {
        if (cumulated == null) {
            return buf;
        }
        ByteBuf releasing = null;
        try {
            int needBytes = buf.readableBytes();
            if (needBytes > cumulated.maxWritableBytes() || needBytes > cumulated.maxFastWritableBytes() && cumulated.refCnt() > 1 || cumulated.isReadOnly()) {
                int oldBytes = cumulated.readableBytes();
                int bufBytes = buf.readableBytes();
                int newBytes = oldBytes + bufBytes;
                int newCapacity = alloc.calculateNewCapacity(newBytes, Integer.MAX_VALUE);
                ByteBuf result = releasing = alloc.ioBuffer(newCapacity);
                result.setBytes(0, cumulated, cumulated.readerIndex(), oldBytes).setBytes(oldBytes, buf, buf.readerIndex(), bufBytes).writerIndex(newBytes);
                buf.readerIndex(buf.writerIndex());
                releasing = cumulated;
                ByteBuf byteBuf = result;
                return byteBuf;
            }
            cumulated.writeBytes(buf, buf.readerIndex(), needBytes);
            buf.readerIndex(buf.writerIndex());
            ByteBuf byteBuf = cumulated;
            return byteBuf;
        }
        finally {
            buf.release();
            if (releasing != null) {
                releasing.release();
            }
        }
    }
}

