/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.api.MySqlReadableMetadata;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import io.asyncer.r2dbc.mysql.codec.ByteCodec;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.CodecUtils;
import io.asyncer.r2dbc.mysql.codec.ShortCodec;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class IntegerCodec
extends AbstractPrimitiveCodec<Integer> {
    static final IntegerCodec INSTANCE = new IntegerCodec();

    private IntegerCodec() {
        super(Integer.TYPE, Integer.class);
    }

    @Override
    public Integer decode(ByteBuf value, MySqlReadableMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        return IntegerCodec.decodeInt(value, binary, metadata.getType());
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Integer;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        int v = (Integer)value;
        if ((byte)v == v) {
            return new ByteCodec.ByteMySqlParameter((byte)v);
        }
        if ((short)v == v) {
            return new ShortCodec.ShortMySqlParameter((short)v);
        }
        return new IntMySqlParameter(v);
    }

    @Override
    public boolean doCanDecode(MySqlReadableMetadata metadata) {
        return metadata.getType().isNumeric();
    }

    static int decodeInt(ByteBuf buf, boolean binary, MySqlType type) {
        if (binary) {
            return IntegerCodec.decodeBinary(buf, type);
        }
        switch (type) {
            case FLOAT: {
                return (int)Float.parseFloat(buf.toString(StandardCharsets.US_ASCII));
            }
            case DOUBLE: {
                return (int)Double.parseDouble(buf.toString(StandardCharsets.US_ASCII));
            }
            case DECIMAL: {
                return IntegerCodec.decimalInt(buf);
            }
        }
        return CodecUtils.parseInt(buf);
    }

    private static int decodeBinary(ByteBuf buf, MySqlType type) {
        switch (type) {
            case BIGINT_UNSIGNED: 
            case BIGINT: 
            case INT_UNSIGNED: 
            case INT: 
            case MEDIUMINT_UNSIGNED: 
            case MEDIUMINT: {
                return buf.readIntLE();
            }
            case SMALLINT_UNSIGNED: {
                return buf.readUnsignedShortLE();
            }
            case SMALLINT: 
            case YEAR: {
                return buf.readShortLE();
            }
            case TINYINT_UNSIGNED: {
                return buf.readUnsignedByte();
            }
            case TINYINT: {
                return buf.readByte();
            }
            case DECIMAL: {
                return IntegerCodec.decimalInt(buf);
            }
            case FLOAT: {
                return (int)buf.readFloatLE();
            }
            case DOUBLE: {
                return (int)buf.readDoubleLE();
            }
        }
        throw new IllegalStateException("Cannot decode type " + (Object)((Object)type) + " as an Integer");
    }

    private static int decimalInt(ByteBuf buf) {
        return new BigDecimal(buf.toString(StandardCharsets.US_ASCII)).intValue();
    }

    static final class IntMySqlParameter
    extends AbstractMySqlParameter {
        private final int value;

        IntMySqlParameter(int value) {
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary(ByteBufAllocator allocator) {
            return Mono.fromSupplier(() -> allocator.buffer(4).writeIntLE(this.value));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeInt(this.value));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.INT;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IntMySqlParameter)) {
                return false;
            }
            IntMySqlParameter intValue = (IntMySqlParameter)o;
            return this.value == intValue.value;
        }

        public int hashCode() {
            return this.value;
        }

        @Override
        public String toString() {
            return Integer.toString(this.value);
        }
    }
}

