/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.api.MySqlReadableMetadata;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.Codec;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.StringCodec;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import reactor.core.publisher.Mono;

final class EnumCodec
implements Codec<Enum> {
    static final EnumCodec INSTANCE = new EnumCodec();

    private EnumCodec() {
    }

    @Override
    public Class<? extends Enum> getMainClass() {
        return Enum.class;
    }

    @Override
    public Enum<?> decode(ByteBuf value, MySqlReadableMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        Charset charset = metadata.getCharCollation(context).getCharset();
        return Enum.valueOf(target, value.toString(charset));
    }

    @Override
    public boolean canDecode(MySqlReadableMetadata metadata, Class<?> target) {
        return metadata.getType() == MySqlType.ENUM && target.isEnum();
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Enum;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return new EnumMySqlParameter((Enum)value, context);
    }

    private static final class EnumMySqlParameter
    extends AbstractMySqlParameter {
        private final Enum<?> value;
        private final CodecContext context;

        private EnumMySqlParameter(Enum<?> value, CodecContext context) {
            this.value = value;
            this.context = context;
        }

        public Mono<ByteBuf> publishBinary(ByteBufAllocator allocator) {
            return Mono.fromSupplier(() -> StringCodec.encodeCharSequence(allocator, this.value.name(), this.context));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.write(this.value.name()));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.VARCHAR;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EnumMySqlParameter)) {
                return false;
            }
            EnumMySqlParameter enumValue = (EnumMySqlParameter)o;
            return this.value.equals(enumValue.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }
}

