/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.api.MySqlReadableMetadata;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.AbstractPrimitiveCodec;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.codec.CodecUtils;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Mono;

final class DoubleCodec
extends AbstractPrimitiveCodec<Double> {
    static final DoubleCodec INSTANCE = new DoubleCodec();

    private DoubleCodec() {
        super(Double.TYPE, Double.class);
    }

    @Override
    public Double decode(ByteBuf value, MySqlReadableMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        MySqlType type = metadata.getType();
        if (binary) {
            return DoubleCodec.decodeBinary(value, type);
        }
        switch (metadata.getType()) {
            case FLOAT: 
            case DOUBLE: 
            case DECIMAL: 
            case BIGINT_UNSIGNED: {
                return Double.parseDouble(value.toString(StandardCharsets.US_ASCII));
            }
        }
        return CodecUtils.parseLong(value);
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Double;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return new DoubleMySqlParameter((Double)value);
    }

    @Override
    public boolean doCanDecode(MySqlReadableMetadata metadata) {
        return metadata.getType().isNumeric();
    }

    private static double decodeBinary(ByteBuf buf, MySqlType type) {
        switch (type) {
            case BIGINT_UNSIGNED: {
                long v = buf.readLongLE();
                if (v < 0L) {
                    return CodecUtils.unsignedBigInteger(v).doubleValue();
                }
                return v;
            }
            case BIGINT: {
                return buf.readLongLE();
            }
            case INT_UNSIGNED: {
                return buf.readUnsignedIntLE();
            }
            case INT: 
            case MEDIUMINT_UNSIGNED: 
            case MEDIUMINT: {
                return buf.readIntLE();
            }
            case SMALLINT_UNSIGNED: {
                return buf.readUnsignedShortLE();
            }
            case SMALLINT: 
            case YEAR: {
                return buf.readShortLE();
            }
            case TINYINT_UNSIGNED: {
                return buf.readUnsignedByte();
            }
            case TINYINT: {
                return buf.readByte();
            }
            case DECIMAL: {
                return Double.parseDouble(buf.toString(StandardCharsets.US_ASCII));
            }
            case FLOAT: {
                return buf.readFloatLE();
            }
            case DOUBLE: {
                return buf.readDoubleLE();
            }
        }
        throw new IllegalStateException("Cannot decode type " + (Object)((Object)type) + " as a Double");
    }

    private static final class DoubleMySqlParameter
    extends AbstractMySqlParameter {
        private final double value;

        private DoubleMySqlParameter(double value) {
            this.value = value;
        }

        public Mono<ByteBuf> publishBinary(ByteBufAllocator allocator) {
            return Mono.fromSupplier(() -> {
                ByteBuf buf = allocator.buffer(8);
                try {
                    return buf.writeDoubleLE(this.value);
                }
                catch (Throwable e) {
                    buf.release();
                    throw e;
                }
            });
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.writeDouble(this.value));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.DOUBLE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DoubleMySqlParameter)) {
                return false;
            }
            DoubleMySqlParameter that = (DoubleMySqlParameter)o;
            return Double.compare(that.value, this.value) == 0;
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.value);
            return (int)(temp ^ temp >>> 32);
        }

        @Override
        public String toString() {
            return Double.toString(this.value);
        }
    }
}

