/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.api;

import io.asyncer.r2dbc.mysql.api.MySqlTransactionDefinition;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.Option;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class SimpleTransactionDefinition
implements MySqlTransactionDefinition {
    static final SimpleTransactionDefinition EMPTY = new SimpleTransactionDefinition(Collections.emptyMap());
    private final Map<Option<?>, Object> options;

    private SimpleTransactionDefinition(Map<Option<?>, Object> options) {
        this.options = options;
    }

    public <T> T getAttribute(Option<T> option) {
        return (T)this.options.get(option);
    }

    @Override
    public MySqlTransactionDefinition isolationLevel(IsolationLevel isolationLevel) {
        AssertUtils.requireNonNull(isolationLevel, "isolationLevel must not be null");
        return this.with(ISOLATION_LEVEL, isolationLevel);
    }

    @Override
    public MySqlTransactionDefinition withoutIsolationLevel() {
        return this.without(ISOLATION_LEVEL);
    }

    @Override
    public MySqlTransactionDefinition readOnly() {
        return this.with(READ_ONLY, true);
    }

    @Override
    public MySqlTransactionDefinition readWrite() {
        return this.with(READ_ONLY, false);
    }

    @Override
    public MySqlTransactionDefinition withoutMutability() {
        return this.without(READ_ONLY);
    }

    @Override
    public MySqlTransactionDefinition lockWaitTimeout(Duration timeout) {
        AssertUtils.requireNonNull(timeout, "timeout must not be null");
        return this.with(LOCK_WAIT_TIMEOUT, timeout);
    }

    @Override
    public MySqlTransactionDefinition withoutLockWaitTimeout() {
        return this.without(LOCK_WAIT_TIMEOUT);
    }

    @Override
    public MySqlTransactionDefinition consistent() {
        return this.with(WITH_CONSISTENT_SNAPSHOT, true);
    }

    @Override
    public MySqlTransactionDefinition consistent(String engine) {
        AssertUtils.requireNonNull(engine, "engine must not be null");
        return this.consistent0(CONSISTENT_SNAPSHOT_ENGINE, engine);
    }

    @Override
    public MySqlTransactionDefinition consistent(String engine, long sessionId) {
        AssertUtils.requireNonNull(engine, "engine must not be null");
        HashMap options = new HashMap(this.options);
        options.put(WITH_CONSISTENT_SNAPSHOT, true);
        options.put(CONSISTENT_SNAPSHOT_ENGINE, engine);
        options.put(CONSISTENT_SNAPSHOT_FROM_SESSION, sessionId);
        return SimpleTransactionDefinition.of(options);
    }

    @Override
    public MySqlTransactionDefinition consistentFromSession(long sessionId) {
        return this.consistent0(CONSISTENT_SNAPSHOT_FROM_SESSION, sessionId);
    }

    @Override
    public MySqlTransactionDefinition withoutConsistent() {
        if (this.options.isEmpty()) {
            return this;
        }
        HashMap options = new HashMap(this.options);
        options.remove(WITH_CONSISTENT_SNAPSHOT);
        options.remove(CONSISTENT_SNAPSHOT_ENGINE);
        options.remove(CONSISTENT_SNAPSHOT_FROM_SESSION);
        return SimpleTransactionDefinition.of(options);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleTransactionDefinition)) {
            return false;
        }
        SimpleTransactionDefinition that = (SimpleTransactionDefinition)o;
        return this.options.equals(that.options);
    }

    public int hashCode() {
        return this.options.hashCode();
    }

    public String toString() {
        return "SimpleTransactionDefinition" + this.options;
    }

    private <T> MySqlTransactionDefinition with(Option<T> option, T value) {
        if (this.options.isEmpty()) {
            return new SimpleTransactionDefinition(Collections.singletonMap(option, value));
        }
        if (value.equals(this.options.get(option))) {
            return this;
        }
        HashMap options = new HashMap(this.options);
        options.put(option, value);
        return SimpleTransactionDefinition.of(options);
    }

    private SimpleTransactionDefinition without(Option<?> option) {
        AssertUtils.requireNonNull(option, "option must not be null");
        if (!this.options.containsKey(option)) {
            return this;
        }
        if (this.options.size() == 1) {
            return EMPTY;
        }
        HashMap options = new HashMap(this.options);
        options.remove(option);
        return SimpleTransactionDefinition.of(options);
    }

    private <T> MySqlTransactionDefinition consistent0(Option<T> option, T value) {
        if (Boolean.TRUE.equals(this.options.get(WITH_CONSISTENT_SNAPSHOT))) {
            return this.with(option, value);
        }
        HashMap options = new HashMap(this.options);
        options.put(WITH_CONSISTENT_SNAPSHOT, true);
        options.put(option, value);
        return SimpleTransactionDefinition.of(options);
    }

    private static SimpleTransactionDefinition of(Map<Option<?>, Object> options) {
        switch (options.size()) {
            case 0: {
                return EMPTY;
            }
            case 1: {
                Map.Entry<Option<?>, Object> e = options.entrySet().iterator().next();
                return new SimpleTransactionDefinition(Collections.singletonMap(e.getKey(), e.getValue()));
            }
        }
        return new SimpleTransactionDefinition(options);
    }
}

