/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.AbstractTransactionState;
import io.asyncer.r2dbc.mysql.QueryLogger;
import io.asyncer.r2dbc.mysql.client.FluxExchangeable;
import io.asyncer.r2dbc.mysql.message.client.ClientMessage;
import io.asyncer.r2dbc.mysql.message.client.PingMessage;
import io.asyncer.r2dbc.mysql.message.client.TextQueryMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Operators;
import reactor.core.publisher.SynchronousSink;

final class TransactionBatchExchangeable
extends FluxExchangeable<Void> {
    private final AbstractTransactionState state;

    TransactionBatchExchangeable(AbstractTransactionState state) {
        this.state = state;
    }

    @Override
    public void accept(ServerMessage message, SynchronousSink<Void> sink) {
        this.state.accept(message, sink);
    }

    public void dispose() {
    }

    public void subscribe(CoreSubscriber<? super ClientMessage> s) {
        if (this.state.cancelTasks()) {
            s.onSubscribe(Operators.scalarSubscription(s, (Object)PingMessage.INSTANCE));
            return;
        }
        String sql = this.state.batchStatement();
        QueryLogger.log(sql);
        this.state.setSql(sql);
        s.onSubscribe(Operators.scalarSubscription(s, (Object)new TextQueryMessage(sql)));
    }
}

