/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.api.MySqlNativeTypeMetadata;
import io.asyncer.r2dbc.mysql.collation.CharCollation;

final class MySqlTypeMetadata
implements MySqlNativeTypeMetadata {
    private static final short NOT_NULL = 1;
    private static final short UNSIGNED = 32;
    public static final short BINARY = 128;
    private static final short ENUM = 256;
    private static final short SET = 2048;
    private static final short ALL_USED = 2465;
    private final int typeId;
    private final short definitions;
    private final int collationId;

    MySqlTypeMetadata(int typeId, int definitions, int collationId) {
        this.typeId = typeId;
        this.definitions = (short)(definitions & 0x9A1);
        this.collationId = collationId;
    }

    @Override
    public int getTypeId() {
        return this.typeId;
    }

    @Override
    public boolean isNotNull() {
        return (this.definitions & 1) != 0;
    }

    @Override
    public boolean isUnsigned() {
        return (this.definitions & 0x20) != 0;
    }

    @Override
    public boolean isBinary() {
        return this.collationId == 0 && (this.definitions & 0x80) != 0 || this.collationId == CharCollation.BINARY_ID;
    }

    @Override
    public boolean isEnum() {
        return (this.definitions & 0x100) != 0;
    }

    @Override
    public boolean isSet() {
        return (this.definitions & 0x800) != 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlTypeMetadata)) {
            return false;
        }
        MySqlTypeMetadata that = (MySqlTypeMetadata)o;
        return this.typeId == that.typeId && this.definitions == that.definitions && this.collationId == that.collationId;
    }

    public int hashCode() {
        int result = 31 * this.typeId + this.definitions;
        return 31 * result + this.collationId;
    }

    public String toString() {
        return "MySqlTypeMetadata{typeId=" + this.typeId + ", definitions=0x" + Integer.toHexString(this.definitions) + ", collationId=" + this.collationId + '}';
    }
}

