/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.MySqlColumnDescriptor;
import io.asyncer.r2dbc.mysql.api.MySqlRowMetadata;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.InternalArrays;
import io.asyncer.r2dbc.mysql.message.server.DefinitionMetadataMessage;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

final class MySqlRowDescriptor
implements MySqlRowMetadata {
    private final MySqlColumnDescriptor[] originMetadata;
    @Nullable
    private Map<String, Integer> indexMap;

    @VisibleForTesting
    MySqlRowDescriptor(MySqlColumnDescriptor[] metadata) {
        this.originMetadata = metadata;
    }

    @Override
    public MySqlColumnDescriptor getColumnMetadata(int index) {
        if (index < 0 || index >= this.originMetadata.length) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", total: " + this.originMetadata.length);
        }
        return this.originMetadata[index];
    }

    private static Map<String, Integer> createIndexMap(MySqlColumnDescriptor[] metadata) {
        int size = metadata.length;
        HashMap<String, Integer> map = new HashMap<String, Integer>(size);
        for (int i = 0; i < size; ++i) {
            map.putIfAbsent(metadata[i].getName().toLowerCase(Locale.ROOT), i);
        }
        return map;
    }

    private int find(String name) {
        Map<String, Integer> indexMap = this.indexMap;
        if (null == indexMap) {
            indexMap = this.indexMap = MySqlRowDescriptor.createIndexMap(this.originMetadata);
        }
        return indexMap.getOrDefault(name.toLowerCase(Locale.ROOT), -1);
    }

    @Override
    public MySqlColumnDescriptor getColumnMetadata(String name) {
        AssertUtils.requireNonNull(name, "name must not be null");
        int index = this.find(name);
        if (index < 0) {
            throw new NoSuchElementException("Column name '" + name + "' does not exist");
        }
        return this.originMetadata[index];
    }

    @Override
    public boolean contains(String name) {
        AssertUtils.requireNonNull(name, "name must not be null");
        return this.find(name) >= 0;
    }

    public List<MySqlColumnDescriptor> getColumnMetadatas() {
        return InternalArrays.asImmutableList(this.originMetadata);
    }

    public String toString() {
        return "MySqlRowDescriptor{metadata=" + Arrays.toString(this.originMetadata) + '}';
    }

    MySqlColumnDescriptor[] unwrap() {
        return this.originMetadata;
    }

    static MySqlRowDescriptor create(DefinitionMetadataMessage[] columns) {
        int size = columns.length;
        MySqlColumnDescriptor[] metadata = new MySqlColumnDescriptor[size];
        for (int i = 0; i < size; ++i) {
            metadata[i] = MySqlColumnDescriptor.create(i, columns[i]);
        }
        return new MySqlRowDescriptor(metadata);
    }
}

