/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.Extensions;
import io.asyncer.r2dbc.mysql.MySqlSslConfiguration;
import io.asyncer.r2dbc.mysql.constant.CompressionAlgorithm;
import io.asyncer.r2dbc.mysql.constant.SslMode;
import io.asyncer.r2dbc.mysql.constant.ZeroDateOption;
import io.asyncer.r2dbc.mysql.extension.Extension;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.InternalArrays;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.resolver.AddressResolverGroup;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.net.ssl.HostnameVerifier;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;
import reactor.netty.internal.util.Metrics;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpResources;

public final class MySqlConnectionConfiguration {
    private static final int DEFAULT_PORT = 3306;
    private final boolean isHost;
    private final String domain;
    private final int port;
    private final MySqlSslConfiguration ssl;
    private final boolean tcpKeepAlive;
    private final boolean tcpNoDelay;
    @Nullable
    private final Duration connectTimeout;
    private final boolean preserveInstants;
    private final String connectionTimeZone;
    private final boolean forceConnectionTimeZoneToSession;
    private final ZeroDateOption zeroDateOption;
    private final String user;
    @Nullable
    private final CharSequence password;
    private final String database;
    private final boolean createDatabaseIfNotExist;
    @Nullable
    private final Predicate<String> preferPrepareStatement;
    private final List<String> sessionVariables;
    @Nullable
    private final Duration lockWaitTimeout;
    @Nullable
    private final Duration statementTimeout;
    @Nullable
    private final Path loadLocalInfilePath;
    private final int localInfileBufferSize;
    private final int queryCacheSize;
    private final int prepareCacheSize;
    private final Set<CompressionAlgorithm> compressionAlgorithms;
    private final int zstdCompressionLevel;
    private final LoopResources loopResources;
    private final Extensions extensions;
    @Nullable
    private final Publisher<String> passwordPublisher;
    @Nullable
    private final AddressResolverGroup<?> resolver;
    private final boolean metrics;
    private final boolean tinyInt1isBit;

    private MySqlConnectionConfiguration(boolean isHost, String domain, int port, MySqlSslConfiguration ssl, boolean tcpKeepAlive, boolean tcpNoDelay, @Nullable Duration connectTimeout, ZeroDateOption zeroDateOption, boolean preserveInstants, String connectionTimeZone, boolean forceConnectionTimeZoneToSession, String user, @Nullable CharSequence password, @Nullable String database, boolean createDatabaseIfNotExist, @Nullable Predicate<String> preferPrepareStatement, List<String> sessionVariables, @Nullable Duration lockWaitTimeout, @Nullable Duration statementTimeout, @Nullable Path loadLocalInfilePath, int localInfileBufferSize, int queryCacheSize, int prepareCacheSize, Set<CompressionAlgorithm> compressionAlgorithms, int zstdCompressionLevel, @Nullable LoopResources loopResources, Extensions extensions, @Nullable Publisher<String> passwordPublisher, @Nullable AddressResolverGroup<?> resolver, boolean metrics, boolean tinyInt1isBit) {
        this.isHost = isHost;
        this.domain = domain;
        this.port = port;
        this.tcpKeepAlive = tcpKeepAlive;
        this.tcpNoDelay = tcpNoDelay;
        this.connectTimeout = connectTimeout;
        this.ssl = ssl;
        this.preserveInstants = preserveInstants;
        this.connectionTimeZone = AssertUtils.requireNonNull(connectionTimeZone, "connectionTimeZone must not be null");
        this.forceConnectionTimeZoneToSession = forceConnectionTimeZoneToSession;
        this.zeroDateOption = AssertUtils.requireNonNull(zeroDateOption, "zeroDateOption must not be null");
        this.user = AssertUtils.requireNonNull(user, "user must not be null");
        this.password = password;
        this.database = database == null || database.isEmpty() ? "" : database;
        this.createDatabaseIfNotExist = createDatabaseIfNotExist;
        this.preferPrepareStatement = preferPrepareStatement;
        this.sessionVariables = sessionVariables;
        this.lockWaitTimeout = lockWaitTimeout;
        this.statementTimeout = statementTimeout;
        this.loadLocalInfilePath = loadLocalInfilePath;
        this.localInfileBufferSize = localInfileBufferSize;
        this.queryCacheSize = queryCacheSize;
        this.prepareCacheSize = prepareCacheSize;
        this.compressionAlgorithms = compressionAlgorithms;
        this.zstdCompressionLevel = zstdCompressionLevel;
        this.loopResources = loopResources == null ? TcpResources.get() : loopResources;
        this.extensions = extensions;
        this.passwordPublisher = passwordPublisher;
        this.resolver = resolver;
        this.metrics = metrics;
        this.tinyInt1isBit = tinyInt1isBit;
    }

    public static Builder builder() {
        return new Builder();
    }

    boolean isHost() {
        return this.isHost;
    }

    String getDomain() {
        return this.domain;
    }

    int getPort() {
        return this.port;
    }

    @Nullable
    Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    MySqlSslConfiguration getSsl() {
        return this.ssl;
    }

    boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    ZeroDateOption getZeroDateOption() {
        return this.zeroDateOption;
    }

    boolean isPreserveInstants() {
        return this.preserveInstants;
    }

    String getConnectionTimeZone() {
        return this.connectionTimeZone;
    }

    boolean isForceConnectionTimeZoneToSession() {
        return this.forceConnectionTimeZoneToSession;
    }

    String getUser() {
        return this.user;
    }

    @Nullable
    CharSequence getPassword() {
        return this.password;
    }

    String getDatabase() {
        return this.database;
    }

    boolean isCreateDatabaseIfNotExist() {
        return this.createDatabaseIfNotExist;
    }

    @Nullable
    Predicate<String> getPreferPrepareStatement() {
        return this.preferPrepareStatement;
    }

    List<String> getSessionVariables() {
        return this.sessionVariables;
    }

    @Nullable
    Duration getLockWaitTimeout() {
        return this.lockWaitTimeout;
    }

    @Nullable
    Duration getStatementTimeout() {
        return this.statementTimeout;
    }

    @Nullable
    Path getLoadLocalInfilePath() {
        return this.loadLocalInfilePath;
    }

    int getLocalInfileBufferSize() {
        return this.localInfileBufferSize;
    }

    int getQueryCacheSize() {
        return this.queryCacheSize;
    }

    int getPrepareCacheSize() {
        return this.prepareCacheSize;
    }

    Set<CompressionAlgorithm> getCompressionAlgorithms() {
        return this.compressionAlgorithms;
    }

    int getZstdCompressionLevel() {
        return this.zstdCompressionLevel;
    }

    LoopResources getLoopResources() {
        return this.loopResources;
    }

    Extensions getExtensions() {
        return this.extensions;
    }

    @Nullable
    Publisher<String> getPasswordPublisher() {
        return this.passwordPublisher;
    }

    @Nullable
    AddressResolverGroup<?> getResolver() {
        return this.resolver;
    }

    boolean isMetrics() {
        return this.metrics;
    }

    boolean isTinyInt1isBit() {
        return this.tinyInt1isBit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MySqlConnectionConfiguration)) {
            return false;
        }
        MySqlConnectionConfiguration that = (MySqlConnectionConfiguration)o;
        return this.isHost == that.isHost && this.domain.equals(that.domain) && this.port == that.port && this.ssl.equals(that.ssl) && this.tcpKeepAlive == that.tcpKeepAlive && this.tcpNoDelay == that.tcpNoDelay && Objects.equals(this.connectTimeout, that.connectTimeout) && this.preserveInstants == that.preserveInstants && Objects.equals(this.connectionTimeZone, that.connectionTimeZone) && this.forceConnectionTimeZoneToSession == that.forceConnectionTimeZoneToSession && this.zeroDateOption == that.zeroDateOption && this.user.equals(that.user) && Objects.equals(this.password, that.password) && this.database.equals(that.database) && this.createDatabaseIfNotExist == that.createDatabaseIfNotExist && Objects.equals(this.preferPrepareStatement, that.preferPrepareStatement) && this.sessionVariables.equals(that.sessionVariables) && Objects.equals(this.lockWaitTimeout, that.lockWaitTimeout) && Objects.equals(this.statementTimeout, that.statementTimeout) && Objects.equals(this.loadLocalInfilePath, that.loadLocalInfilePath) && this.localInfileBufferSize == that.localInfileBufferSize && this.queryCacheSize == that.queryCacheSize && this.prepareCacheSize == that.prepareCacheSize && this.compressionAlgorithms.equals(that.compressionAlgorithms) && this.zstdCompressionLevel == that.zstdCompressionLevel && Objects.equals(this.loopResources, that.loopResources) && this.extensions.equals(that.extensions) && Objects.equals(this.passwordPublisher, that.passwordPublisher) && Objects.equals(this.resolver, that.resolver) && this.metrics == that.metrics && this.tinyInt1isBit == that.tinyInt1isBit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isHost, this.domain, this.port, this.ssl, this.tcpKeepAlive, this.tcpNoDelay, this.connectTimeout, this.preserveInstants, this.connectionTimeZone, this.forceConnectionTimeZoneToSession, this.zeroDateOption, this.user, this.password, this.database, this.createDatabaseIfNotExist, this.preferPrepareStatement, this.sessionVariables, this.lockWaitTimeout, this.statementTimeout, this.loadLocalInfilePath, this.localInfileBufferSize, this.queryCacheSize, this.prepareCacheSize, this.compressionAlgorithms, this.zstdCompressionLevel, this.loopResources, this.extensions, this.passwordPublisher, this.resolver, this.metrics, this.tinyInt1isBit});
    }

    public String toString() {
        return "MySqlConnectionConfiguration{" + (this.isHost ? "host='" + this.domain + "', port=" + this.port + ", ssl=" + this.ssl + ", tcpNoDelay=" + this.tcpNoDelay + ", tcpKeepAlive=" + this.tcpKeepAlive : "unixSocket='" + this.domain + "'") + this.buildCommonToStringPart() + '}';
    }

    private String buildCommonToStringPart() {
        return ", connectTimeout=" + this.connectTimeout + ", preserveInstants=" + this.preserveInstants + ", connectionTimeZone=" + this.connectionTimeZone + ", forceConnectionTimeZoneToSession=" + this.forceConnectionTimeZoneToSession + ", zeroDateOption=" + (Object)((Object)this.zeroDateOption) + ", user='" + this.user + "', password=" + this.password + ", database='" + this.database + "', createDatabaseIfNotExist=" + this.createDatabaseIfNotExist + ", preferPrepareStatement=" + this.preferPrepareStatement + ", sessionVariables=" + this.sessionVariables + ", lockWaitTimeout=" + this.lockWaitTimeout + ", statementTimeout=" + this.statementTimeout + ", loadLocalInfilePath=" + this.loadLocalInfilePath + ", localInfileBufferSize=" + this.localInfileBufferSize + ", queryCacheSize=" + this.queryCacheSize + ", prepareCacheSize=" + this.prepareCacheSize + ", compressionAlgorithms=" + this.compressionAlgorithms + ", zstdCompressionLevel=" + this.zstdCompressionLevel + ", loopResources=" + this.loopResources + ", extensions=" + this.extensions + ", passwordPublisher=" + this.passwordPublisher + ", resolver=" + this.resolver + ", metrics=" + this.metrics + ", tinyint1isBit=" + this.tinyInt1isBit;
    }

    public static final class Builder {
        @Nullable
        private String database;
        private boolean createDatabaseIfNotExist;
        private boolean isHost = true;
        private String domain;
        @Nullable
        private CharSequence password;
        private int port = 3306;
        @Nullable
        private Duration connectTimeout;
        private String user;
        private ZeroDateOption zeroDateOption = ZeroDateOption.USE_NULL;
        private boolean preserveInstants = true;
        private String connectionTimeZone = "LOCAL";
        private boolean forceConnectionTimeZoneToSession;
        @Nullable
        private SslMode sslMode;
        private String[] tlsVersion = InternalArrays.EMPTY_STRINGS;
        @Nullable
        private HostnameVerifier sslHostnameVerifier;
        @Nullable
        private String sslCa;
        @Nullable
        private String sslKey;
        @Nullable
        private CharSequence sslKeyPassword;
        @Nullable
        private String sslCert;
        @Nullable
        private Function<SslContextBuilder, SslContextBuilder> sslContextBuilderCustomizer;
        private boolean tcpKeepAlive;
        private boolean tcpNoDelay;
        @Nullable
        private Predicate<String> preferPrepareStatement;
        @Nullable
        private Duration lockWaitTimeout;
        @Nullable
        private Duration statementTimeout;
        private List<String> sessionVariables = Collections.emptyList();
        @Nullable
        private Path loadLocalInfilePath;
        private int localInfileBufferSize = 8192;
        private int queryCacheSize = 0;
        private int prepareCacheSize = 256;
        private Set<CompressionAlgorithm> compressionAlgorithms = Collections.singleton(CompressionAlgorithm.UNCOMPRESSED);
        private int zstdCompressionLevel = 3;
        @Nullable
        private LoopResources loopResources;
        private boolean autodetectExtensions = true;
        private final List<Extension> extensions = new ArrayList<Extension>();
        @Nullable
        private Publisher<String> passwordPublisher;
        @Nullable
        private AddressResolverGroup<?> resolver;
        private boolean metrics;
        private boolean tinyInt1isBit = true;

        public MySqlConnectionConfiguration build() {
            SslMode sslMode = this.requireSslMode();
            if (this.isHost) {
                AssertUtils.requireNonNull(this.domain, "host must not be null when using TCP socket");
                AssertUtils.require(this.sslCert == null && this.sslKey == null || this.sslCert != null && this.sslKey != null, "sslCert and sslKey must be both null or both non-null");
            } else {
                AssertUtils.requireNonNull(this.domain, "unixSocket must not be null when using unix domain socket");
                AssertUtils.require(!sslMode.startSsl(), "sslMode must be disabled when using unix domain socket");
            }
            int prepareCacheSize = this.preferPrepareStatement == null ? 0 : this.prepareCacheSize;
            MySqlSslConfiguration ssl = MySqlSslConfiguration.create(sslMode, this.tlsVersion, this.sslHostnameVerifier, this.sslCa, this.sslKey, this.sslKeyPassword, this.sslCert, this.sslContextBuilderCustomizer);
            return new MySqlConnectionConfiguration(this.isHost, this.domain, this.port, ssl, this.tcpKeepAlive, this.tcpNoDelay, this.connectTimeout, this.zeroDateOption, this.preserveInstants, this.connectionTimeZone, this.forceConnectionTimeZoneToSession, this.user, this.password, this.database, this.createDatabaseIfNotExist, this.preferPrepareStatement, this.sessionVariables, this.lockWaitTimeout, this.statementTimeout, this.loadLocalInfilePath, this.localInfileBufferSize, this.queryCacheSize, prepareCacheSize, this.compressionAlgorithms, this.zstdCompressionLevel, this.loopResources, Extensions.from(this.extensions, this.autodetectExtensions), this.passwordPublisher, this.resolver, this.metrics, this.tinyInt1isBit);
        }

        public Builder database(@Nullable String database) {
            this.database = database;
            return this;
        }

        public Builder createDatabaseIfNotExist(boolean enabled) {
            this.createDatabaseIfNotExist = enabled;
            return this;
        }

        public Builder unixSocket(String unixSocket) {
            this.domain = AssertUtils.requireNonNull(unixSocket, "unixSocket must not be null");
            this.isHost = false;
            return this;
        }

        public Builder host(String host) {
            this.domain = AssertUtils.requireNonNull(host, "host must not be null");
            this.isHost = true;
            return this;
        }

        public Builder password(@Nullable CharSequence password) {
            this.password = password;
            return this;
        }

        public Builder port(int port) {
            AssertUtils.require(port >= 0 && port <= 65535, "port must be between 0 and 65535");
            this.port = port;
            return this;
        }

        public Builder connectTimeout(@Nullable Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder user(String user) {
            this.user = AssertUtils.requireNonNull(user, "user must not be null");
            return this;
        }

        public Builder username(String user) {
            return this.user(user);
        }

        public Builder preserveInstants(boolean enabled) {
            this.preserveInstants = enabled;
            return this;
        }

        public Builder connectionTimeZone(String connectionTimeZone) {
            AssertUtils.requireNonEmpty(connectionTimeZone, "connectionTimeZone must not be empty");
            this.connectionTimeZone = connectionTimeZone;
            return this;
        }

        public Builder forceConnectionTimeZoneToSession(boolean enabled) {
            this.forceConnectionTimeZoneToSession = enabled;
            return this;
        }

        @Deprecated
        public Builder serverZoneId(@Nullable ZoneId serverZoneId) {
            return this.connectionTimeZone(serverZoneId == null ? "SERVER" : serverZoneId.getId());
        }

        public Builder zeroDateOption(ZeroDateOption zeroDate) {
            this.zeroDateOption = AssertUtils.requireNonNull(zeroDate, "zeroDateOption must not be null");
            return this;
        }

        public Builder sslMode(SslMode sslMode) {
            this.sslMode = AssertUtils.requireNonNull(sslMode, "sslMode must not be null");
            return this;
        }

        public Builder tlsVersion(String ... tlsVersion) {
            AssertUtils.requireNonNull(tlsVersion, "tlsVersion must not be null");
            int size = tlsVersion.length;
            if (size > 0) {
                String[] versions = new String[size];
                System.arraycopy(tlsVersion, 0, versions, 0, size);
                this.tlsVersion = versions;
            } else {
                this.tlsVersion = InternalArrays.EMPTY_STRINGS;
            }
            return this;
        }

        public Builder sslHostnameVerifier(HostnameVerifier sslHostnameVerifier) {
            this.sslHostnameVerifier = AssertUtils.requireNonNull(sslHostnameVerifier, "sslHostnameVerifier must not be null");
            return this;
        }

        public Builder sslCa(@Nullable String sslCa) {
            this.sslCa = sslCa;
            return this;
        }

        public Builder sslCert(@Nullable String sslCert) {
            this.sslCert = sslCert;
            return this;
        }

        public Builder sslKey(@Nullable String sslKey) {
            this.sslKey = sslKey;
            return this;
        }

        public Builder sslKeyPassword(@Nullable CharSequence sslKeyPassword) {
            this.sslKeyPassword = sslKeyPassword;
            return this;
        }

        public Builder sslContextBuilderCustomizer(Function<SslContextBuilder, SslContextBuilder> customizer) {
            AssertUtils.requireNonNull(customizer, "sslContextBuilderCustomizer must not be null");
            this.sslContextBuilderCustomizer = customizer;
            return this;
        }

        public Builder tcpKeepAlive(boolean enabled) {
            this.tcpKeepAlive = enabled;
            return this;
        }

        public Builder tcpNoDelay(boolean enabled) {
            this.tcpNoDelay = enabled;
            return this;
        }

        public Builder useClientPrepareStatement() {
            this.preferPrepareStatement = null;
            return this;
        }

        public Builder useServerPrepareStatement() {
            return this.useServerPrepareStatement(sql -> false);
        }

        public Builder useServerPrepareStatement(Predicate<String> preferPrepareStatement) {
            AssertUtils.requireNonNull(preferPrepareStatement, "preferPrepareStatement must not be null");
            this.preferPrepareStatement = preferPrepareStatement;
            return this;
        }

        public Builder sessionVariables(String ... sessionVariables) {
            AssertUtils.requireNonNull(sessionVariables, "sessionVariables must not be null");
            this.sessionVariables = InternalArrays.toImmutableList(sessionVariables);
            return this;
        }

        public Builder lockWaitTimeout(@Nullable Duration lockWaitTimeout) {
            this.lockWaitTimeout = lockWaitTimeout;
            return this;
        }

        public Builder statementTimeout(@Nullable Duration statementTimeout) {
            this.statementTimeout = statementTimeout;
            return this;
        }

        public Builder allowLoadLocalInfileInPath(@Nullable String path) {
            this.loadLocalInfilePath = path == null ? null : Paths.get(path, new String[0]);
            return this;
        }

        public Builder localInfileBufferSize(int localInfileBufferSize) {
            AssertUtils.require(localInfileBufferSize > 0, "localInfileBufferSize must be positive");
            this.localInfileBufferSize = localInfileBufferSize;
            return this;
        }

        public Builder queryCacheSize(int queryCacheSize) {
            this.queryCacheSize = queryCacheSize;
            return this;
        }

        public Builder prepareCacheSize(int prepareCacheSize) {
            this.prepareCacheSize = prepareCacheSize;
            return this;
        }

        public Builder compressionAlgorithms(CompressionAlgorithm ... compressionAlgorithms) {
            AssertUtils.requireNonNull(compressionAlgorithms, "compressionAlgorithms must not be null");
            AssertUtils.require(compressionAlgorithms.length != 0, "compressionAlgorithms must not be empty");
            if (compressionAlgorithms.length == 1) {
                AssertUtils.requireNonNull(compressionAlgorithms[0], "compressionAlgorithms must not contain null");
                this.compressionAlgorithms = Collections.singleton(compressionAlgorithms[0]);
            } else {
                EnumSet<CompressionAlgorithm> algorithms = EnumSet.noneOf(CompressionAlgorithm.class);
                for (CompressionAlgorithm algorithm : compressionAlgorithms) {
                    AssertUtils.requireNonNull(algorithm, "compressionAlgorithms must not contain null");
                    algorithms.add(algorithm);
                }
                this.compressionAlgorithms = algorithms;
            }
            return this;
        }

        public Builder zstdCompressionLevel(int level) {
            AssertUtils.require(level >= 1 && level <= 22, "level must be between 1 and 22");
            this.zstdCompressionLevel = level;
            return this;
        }

        public Builder loopResources(LoopResources loopResources) {
            this.loopResources = AssertUtils.requireNonNull(loopResources, "loopResources must not be null");
            return this;
        }

        public Builder autodetectExtensions(boolean enabled) {
            this.autodetectExtensions = enabled;
            return this;
        }

        public Builder extendWith(Extension extension) {
            this.extensions.add(AssertUtils.requireNonNull(extension, "extension must not be null"));
            return this;
        }

        public Builder passwordPublisher(Publisher<String> passwordPublisher) {
            this.passwordPublisher = passwordPublisher;
            return this;
        }

        public Builder resolver(AddressResolverGroup<?> resolver) {
            this.resolver = resolver;
            return this;
        }

        public Builder metrics(boolean enabled) {
            AssertUtils.require(!enabled || Metrics.isMicrometerAvailable(), "dependency `io.micrometer:micrometer-core` must be added to classpath if metrics enabled");
            this.metrics = enabled;
            return this;
        }

        public Builder tinyInt1isBit(boolean tinyInt1isBit) {
            this.tinyInt1isBit = tinyInt1isBit;
            return this;
        }

        private SslMode requireSslMode() {
            SslMode sslMode = this.sslMode;
            if (sslMode == null) {
                sslMode = this.isHost ? SslMode.PREFERRED : SslMode.DISABLED;
            }
            return sslMode;
        }

        private Builder() {
        }
    }
}

