/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.Capability;
import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.VarIntUtils;
import io.asyncer.r2dbc.mysql.message.server.CompleteMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerStatusMessage;
import io.asyncer.r2dbc.mysql.message.server.WarningMessage;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public final class OkMessage
implements WarningMessage,
ServerStatusMessage,
CompleteMessage {
    private static final int SESSION_TRACK_SYSTEM_VARIABLES = 0;
    private static final int MIN_SIZE = 7;
    private final boolean isEndOfRows;
    private final long affectedRows;
    private final long lastInsertId;
    private final short serverStatuses;
    private final int warnings;
    private final String information;
    private final Map<String, String> systemVariables;

    private OkMessage(boolean isEndOfRows, long affectedRows, long lastInsertId, short serverStatuses, int warnings, String information, Map<String, String> systemVariables) {
        this.isEndOfRows = isEndOfRows;
        this.affectedRows = affectedRows;
        this.lastInsertId = lastInsertId;
        this.serverStatuses = serverStatuses;
        this.warnings = warnings;
        this.information = AssertUtils.requireNonNull(information, "information must not be null");
        this.systemVariables = AssertUtils.requireNonNull(systemVariables, "systemVariables must not be null");
    }

    public boolean isEndOfRows() {
        return this.isEndOfRows;
    }

    public long getAffectedRows() {
        return this.affectedRows;
    }

    public long getLastInsertId() {
        return this.lastInsertId;
    }

    @Override
    public short getServerStatuses() {
        return this.serverStatuses;
    }

    @Override
    public int getWarnings() {
        return this.warnings;
    }

    @Nullable
    public String getSystemVariable(String key) {
        return this.systemVariables.get(key);
    }

    @Override
    public boolean isDone() {
        return (this.serverStatuses & 8) == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OkMessage)) {
            return false;
        }
        OkMessage okMessage = (OkMessage)o;
        return this.isEndOfRows == okMessage.isEndOfRows && this.affectedRows == okMessage.affectedRows && this.lastInsertId == okMessage.lastInsertId && this.serverStatuses == okMessage.serverStatuses && this.warnings == okMessage.warnings && this.information.equals(okMessage.information) && this.systemVariables.equals(okMessage.systemVariables);
    }

    public int hashCode() {
        int result = this.isEndOfRows ? 1 : 0;
        result = 31 * result + (int)(this.affectedRows ^ this.affectedRows >>> 32);
        result = 31 * result + (int)(this.lastInsertId ^ this.lastInsertId >>> 32);
        result = 31 * result + this.serverStatuses;
        result = 31 * result + this.warnings;
        result = 31 * result + this.information.hashCode();
        return 31 * result + this.systemVariables.hashCode();
    }

    public String toString() {
        if (this.warnings == 0) {
            return "OkMessage{isEndOfRows=" + this.isEndOfRows + ", affectedRows=" + Long.toUnsignedString(this.affectedRows) + ", lastInsertId=" + Long.toUnsignedString(this.lastInsertId) + ", serverStatuses=" + Integer.toHexString(this.serverStatuses) + ", information='" + this.information + "', systemVariables=" + this.systemVariables + '}';
        }
        return "OkMessage{isEndOfRows=" + this.isEndOfRows + ", affectedRows=" + Long.toUnsignedString(this.affectedRows) + ", lastInsertId=" + Long.toUnsignedString(this.lastInsertId) + ", serverStatuses=" + Integer.toHexString(this.serverStatuses) + ", warnings=" + this.warnings + ", information='" + this.information + "', systemVariables=" + this.systemVariables + "}";
    }

    static boolean isValidSize(int bytes) {
        return bytes >= 7;
    }

    static OkMessage decode(boolean isEndOfRows, ByteBuf buf, ConnectionContext context) {
        int warnings;
        short serverStatuses;
        buf.skipBytes(1);
        Capability capability = context.getCapability();
        long affectedRows = VarIntUtils.readVarInt(buf);
        long lastInsertId = VarIntUtils.readVarInt(buf);
        if (capability.isProtocol41()) {
            serverStatuses = buf.readShortLE();
            warnings = buf.readUnsignedShortLE();
        } else if (capability.isTransactionAllowed()) {
            serverStatuses = buf.readShortLE();
            warnings = 0;
        } else {
            serverStatuses = 0;
            warnings = 0;
        }
        if (buf.isReadable()) {
            Charset charset = context.getClientCollation().getCharset();
            int sizeAfterVarInt = VarIntUtils.checkNextVarInt(buf);
            if (sizeAfterVarInt < 0) {
                return new OkMessage(isEndOfRows, affectedRows, lastInsertId, serverStatuses, warnings, buf.toString(charset), Collections.emptyMap());
            }
            int oldReaderIndex = buf.readerIndex();
            long infoSize = VarIntUtils.readVarInt(buf);
            if (infoSize > (long)sizeAfterVarInt) {
                String info = buf.toString(oldReaderIndex, buf.writerIndex() - oldReaderIndex, charset);
                return new OkMessage(isEndOfRows, affectedRows, lastInsertId, serverStatuses, warnings, info, Collections.emptyMap());
            }
            String information = buf.readCharSequence((int)infoSize, charset).toString();
            Map<String, String> systemVariables = Collections.emptyMap();
            while (VarIntUtils.checkNextVarInt(buf) >= 0) {
                int stateInfoSize = (int)VarIntUtils.readVarInt(buf);
                ByteBuf stateInfo = buf.readSlice(stateInfoSize);
                while (stateInfo.isReadable()) {
                    if (stateInfo.readByte() == 0) {
                        systemVariables = OkMessage.readServerVariables(stateInfo, context);
                        continue;
                    }
                    int skipBytes = (int)VarIntUtils.readVarInt(stateInfo);
                    stateInfo.skipBytes(skipBytes);
                }
            }
            return new OkMessage(isEndOfRows, affectedRows, lastInsertId, serverStatuses, warnings, information, systemVariables);
        }
        return new OkMessage(isEndOfRows, affectedRows, lastInsertId, serverStatuses, warnings, "", Collections.emptyMap());
    }

    private static Map<String, String> readServerVariables(ByteBuf buf, ConnectionContext context) {
        HashMap<String, String> map = new HashMap<String, String>();
        Charset charset = context.getClientCollation().getCharset();
        int size = (int)VarIntUtils.readVarInt(buf);
        ByteBuf sessionVar = buf.readSlice(size);
        while (sessionVar.readableBytes() > 0) {
            int variableSize = (int)VarIntUtils.readVarInt(sessionVar);
            String variable = sessionVar.toString(sessionVar.readerIndex(), variableSize, charset);
            sessionVar.skipBytes(variableSize);
            int valueSize = (int)VarIntUtils.readVarInt(sessionVar);
            String value = sessionVar.toString(sessionVar.readerIndex(), valueSize, charset);
            sessionVar.skipBytes(valueSize);
            map.put(variable, value);
        }
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry entry = map.entrySet().iterator().next();
                return Collections.singletonMap(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }
}

