/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.collation;

import io.asyncer.r2dbc.mysql.collation.AbstractCharCollation;
import io.asyncer.r2dbc.mysql.collation.CharsetTarget;
import java.nio.charset.Charset;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;

final class LazyInitCharCollation
extends AbstractCharCollation {
    private final ReentrantLock lock = new ReentrantLock();
    @Nullable
    private volatile Charset cached;

    LazyInitCharCollation(int id, String name, CharsetTarget target) {
        super(id, name, target);
    }

    @Override
    public Charset getCharset() {
        Charset cached = this.cached;
        if (cached == null) {
            this.lock.lock();
            try {
                cached = this.cached;
                if (cached == null) {
                    this.cached = cached = this.target.getCharset();
                }
                Charset charset = cached;
                return charset;
            }
            finally {
                this.lock.unlock();
            }
        }
        return cached;
    }

    public String toString() {
        return "LazyInitCharCollation{id=" + this.id + ", name='" + this.name + "', target=" + this.target + '}';
    }
}

