/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.codec;

import io.asyncer.r2dbc.mysql.MySqlParameter;
import io.asyncer.r2dbc.mysql.ParameterWriter;
import io.asyncer.r2dbc.mysql.api.MySqlReadableMetadata;
import io.asyncer.r2dbc.mysql.codec.AbstractClassedCodec;
import io.asyncer.r2dbc.mysql.codec.AbstractMySqlParameter;
import io.asyncer.r2dbc.mysql.codec.CodecContext;
import io.asyncer.r2dbc.mysql.constant.MySqlType;
import io.asyncer.r2dbc.mysql.internal.util.VarIntUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.nio.charset.Charset;
import reactor.core.publisher.Mono;

final class StringCodec
extends AbstractClassedCodec<String> {
    static final StringCodec INSTANCE = new StringCodec();

    private StringCodec() {
        super(String.class);
    }

    @Override
    public String decode(ByteBuf value, MySqlReadableMetadata metadata, Class<?> target, boolean binary, CodecContext context) {
        if (!value.isReadable()) {
            return "";
        }
        return value.toString(metadata.getCharCollation(context).getCharset());
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof CharSequence;
    }

    @Override
    public MySqlParameter encode(Object value, CodecContext context) {
        return new StringMySqlParameter((CharSequence)value, context);
    }

    @Override
    protected boolean doCanDecode(MySqlReadableMetadata metadata) {
        return metadata.getType().isString();
    }

    static ByteBuf encodeCharSequence(ByteBufAllocator allocator, CharSequence value, CodecContext context) {
        int length = value.length();
        if (length <= 0) {
            return allocator.buffer(1).writeByte(0);
        }
        Charset charset = context.getClientCollation().getCharset();
        ByteBuf content = allocator.buffer();
        try {
            VarIntUtils.reserveVarInt(content);
            return VarIntUtils.setReservedVarInt(content, content.writeCharSequence(value, charset));
        }
        catch (Throwable e) {
            content.release();
            throw e;
        }
    }

    private static final class StringMySqlParameter
    extends AbstractMySqlParameter {
        private final CharSequence value;
        private final CodecContext context;

        private StringMySqlParameter(CharSequence value, CodecContext context) {
            this.value = value;
            this.context = context;
        }

        public Mono<ByteBuf> publishBinary(ByteBufAllocator allocator) {
            return Mono.fromSupplier(() -> StringCodec.encodeCharSequence(allocator, this.value, this.context));
        }

        @Override
        public Mono<Void> publishText(ParameterWriter writer) {
            return Mono.fromRunnable(() -> writer.append(this.value));
        }

        @Override
        public MySqlType getType() {
            return MySqlType.VARCHAR;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StringMySqlParameter)) {
                return false;
            }
            StringMySqlParameter that = (StringMySqlParameter)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        @Override
        public String toString() {
            return this.value.toString();
        }
    }
}

