/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;

public final class ServerVersion
implements Comparable<ServerVersion> {
    private static final String MARIADB_RPL_HACK_PREFIX = "5.5.5-";
    private static final String ENTERPRISE = "enterprise";
    private static final String COMMERCIAL = "commercial";
    private static final String ADVANCED = "advanced";
    private final transient String origin;
    private final int major;
    private final int minor;
    private final int patch;
    private final boolean isMariaDb;

    private ServerVersion(String origin, int major, int minor, int patch, boolean isMariaDb) {
        this.origin = origin;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.isMariaDb = isMariaDb;
    }

    public boolean isGreaterThanOrEqualTo(ServerVersion version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isLessThan(ServerVersion version) {
        return this.compareTo(version) < 0;
    }

    @Override
    public int compareTo(ServerVersion version) {
        if (this.major != version.major) {
            return this.major < version.major ? -1 : 1;
        }
        if (this.minor != version.minor) {
            return this.minor < version.minor ? -1 : 1;
        }
        if (this.patch != version.patch) {
            return this.patch < version.patch ? -1 : 1;
        }
        return 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean isMariaDb() {
        return this.isMariaDb;
    }

    public boolean isEnterprise() {
        return this.origin.contains(ENTERPRISE) || this.origin.contains(COMMERCIAL) || this.origin.contains(ADVANCED);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerVersion)) {
            return false;
        }
        ServerVersion that = (ServerVersion)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch;
    }

    public int hashCode() {
        int hash = 31 * this.major + this.minor;
        return 31 * hash + this.patch;
    }

    public String toString() {
        if (this.origin.isEmpty()) {
            return String.format("%d.%d.%d", this.major, this.minor, this.patch);
        }
        return this.origin;
    }

    public static ServerVersion parse(String version) {
        AssertUtils.requireNonNull(version, "version must not be null");
        int length = version.length();
        int[] index = new int[]{0};
        boolean isMariaDb = false;
        if (version.startsWith(MARIADB_RPL_HACK_PREFIX)) {
            isMariaDb = true;
            index[0] = MARIADB_RPL_HACK_PREFIX.length();
        }
        int[] parts = new int[]{0, 0, 0};
        int i = 0;
        while (true) {
            parts[i] = ServerVersion.readInt(version, length, index);
            if (index[0] >= length) break;
            if (i == 2 || version.charAt(index[0]) != '.') {
                if (isMariaDb) break;
                isMariaDb = version.indexOf("MariaDB", index[0]) >= 0;
                break;
            }
            index[0] = index[0] + 1;
            ++i;
        }
        return ServerVersion.create0(version, parts[0], parts[1], parts[2], isMariaDb);
    }

    public static ServerVersion create(int major, int minor, int patch) {
        return ServerVersion.create0("", major, minor, patch, false);
    }

    public static ServerVersion create(int major, int minor, int patch, boolean isMariaDb) {
        return ServerVersion.create0("", major, minor, patch, isMariaDb);
    }

    private static ServerVersion create0(String origin, int major, int minor, int patch, boolean isMariaDb) {
        AssertUtils.require(major >= 0, "major version must not be a negative integer");
        AssertUtils.require(minor >= 0, "minor version must not be a negative integer");
        AssertUtils.require(patch >= 0, "patch version must not be a negative integer");
        return new ServerVersion(origin, major, minor, patch, isMariaDb);
    }

    private static int readInt(String input, int length, int[] index) {
        char ch;
        int i;
        int ans = 0;
        for (i = index[0]; i < length && (ch = input.charAt(i)) >= '0' && ch <= '9'; ++i) {
            ans = ans * 10 + (ch - 48);
        }
        index[0] = i;
        return ans;
    }
}

