/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.proxy;

import io.appium.java_client.proxy.HasMethodCallListeners;
import io.appium.java_client.proxy.MethodCallListener;
import io.appium.java_client.proxy.NotImplementedException;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.Callable;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.SuperCall;
import net.bytebuddy.implementation.bind.annotation.This;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Interceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Interceptor.class);

    private Interceptor() {
    }

    @RuntimeType
    public static Object intercept(@This Object self, @Origin Method method, @AllArguments Object[] args, @SuperCall Callable<?> callable) throws Throwable {
        MethodCallListener[] listeners = ((HasMethodCallListeners)self).getMethodCallListeners();
        if (listeners == null || listeners.length == 0) {
            return callable.call();
        }
        for (MethodCallListener listener : listeners) {
            try {
                listener.beforeCall(self, method, args);
            }
            catch (NotImplementedException notImplementedException) {
            }
            catch (Exception e) {
                LOGGER.atError().log("Got an unexpected error in beforeCall listener of {}.{} method", new Object[]{self.getClass().getName(), method.getName(), e});
            }
        }
        Object result = MethodCallListener.UNSET;
        for (MethodCallListener listener : listeners) {
            try {
                result = listener.call(self, method, args, callable);
                if (result == MethodCallListener.UNSET) continue;
                break;
            }
            catch (NotImplementedException notImplementedException) {
            }
            catch (Exception e) {
                try {
                    result = listener.onError(self, method, args, e);
                    if (result != MethodCallListener.UNSET) {
                        return result;
                    }
                }
                catch (NotImplementedException notImplementedException) {
                    // empty catch block
                }
                throw e;
            }
        }
        if (MethodCallListener.UNSET == result) {
            try {
                result = callable.call();
            }
            catch (Exception e) {
                for (MethodCallListener listener : listeners) {
                    try {
                        result = listener.onError(self, method, args, e);
                        if (result == MethodCallListener.UNSET) continue;
                        return result;
                    }
                    catch (NotImplementedException notImplementedException) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
        UUID endResult = result == MethodCallListener.UNSET ? null : result;
        for (MethodCallListener listener : listeners) {
            try {
                listener.afterCall(self, method, args, endResult);
            }
            catch (NotImplementedException notImplementedException) {
            }
            catch (Exception e) {
                LOGGER.atError().log("Got an unexpected error in afterCall listener of {}.{} method", new Object[]{self.getClass().getName(), method.getName(), e});
            }
        }
        return endResult;
    }
}

